/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.integration.forge.energy;

import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.nbt.NBTBuilder;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import com.valkyrieofnight.vlib.integration.forge.energy.IConfigurableIORateForgeEnergy;
import com.valkyrieofnight.vlib.integration.forge.energy.IVLEnergyStorage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.energy.IEnergyStorage;

public class VLConfigurableRateEnergyStorage
implements IVLEnergyStorage,
IConfigurableIORateForgeEnergy {
    private int capacity;
    private int stored = 0;
    private int inputRate;
    private int outputRate;
    private int maxInputRate;
    private int maxOutputRate;
    private IOMode mode;

    public VLConfigurableRateEnergyStorage(int capacity, int stored, int inputRate, int outputRate, int maxInputRate, int maxOutputRate, IOMode mode) {
        this.capacity = capacity;
        this.stored = stored;
        this.inputRate = inputRate;
        this.outputRate = outputRate;
        this.maxInputRate = maxInputRate;
        this.maxOutputRate = maxOutputRate;
        this.mode = mode;
    }

    public VLConfigurableRateEnergyStorage(int capacity, int maxInputRate, int maxOutputRate) {
        this(capacity, 0, maxInputRate, maxOutputRate, maxInputRate, maxOutputRate, IOMode.BOTH);
    }

    public VLConfigurableRateEnergyStorage(int capacity, IOMode mode) {
        this.capacity = capacity;
        this.mode = mode;
    }

    @Override
    public boolean isInputModeSupported() {
        return true;
    }

    @Override
    public boolean isOutputModeSupported() {
        return true;
    }

    @Override
    public IOMode getIOMode() {
        return this.mode;
    }

    @Override
    public void setCurrentIOMode(IOMode mode) {
        this.mode = mode;
    }

    @Override
    public int getInputRate() {
        return this.inputRate;
    }

    @Override
    public int getOutputRate() {
        return this.outputRate;
    }

    @Override
    public int getMaxInputRate() {
        return this.maxInputRate;
    }

    @Override
    public int getMaxOutputRate() {
        return this.maxOutputRate;
    }

    @Override
    public void setInputRate(int rate) {
        this.inputRate = Math.min(rate, this.maxInputRate);
    }

    @Override
    public void setOutputRate(int rate) {
        this.inputRate = Math.min(rate, this.maxOutputRate);
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.inputRate, Math.min(this.capacity - this.stored, maxReceive));
        if (!simulate) {
            this.stored += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int receiveEnergyForced(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.stored, maxReceive);
        if (!simulate) {
            this.stored += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.outputRate, Math.min(this.stored, maxExtract));
        if (!simulate) {
            this.stored -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public int extractEnergyForced(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.stored, maxExtract);
        if (!simulate) {
            this.stored -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.stored;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    @Override
    public CompoundNBT serializeNBT() {
        return NBTBuilder.create().putInt("capacity", this.capacity).putInt("stored", this.capacity).putInt("input_rate", this.inputRate).putInt("output_rate", this.outputRate).putInt("max_input_rate", this.maxInputRate).putInt("max_output_rate", this.maxOutputRate).putInt("mode", this.mode.ordinal()).build();
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.capacity = nbt.func_74762_e("capacity");
        this.stored = nbt.func_74762_e("stored");
        this.inputRate = nbt.func_74762_e("input_rate");
        this.outputRate = nbt.func_74762_e("output_rate");
        this.maxInputRate = nbt.func_74762_e("max_input_rate");
        this.maxOutputRate = nbt.func_74762_e("max_output_rate");
        this.mode = IOMode.getFromOrdinal(nbt.func_74762_e("mode"));
    }

    @Override
    @NotNull
    public IEnergyStorage getEnergyStorage() {
        return this;
    }
}

