/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.integration.forge.energy;

import com.valkyrieofnight.vlib.core.util.nbt.NBTBuilder;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import com.valkyrieofnight.vlib.integration.forge.energy.IVLLongEnergyStorage;
import net.minecraft.nbt.CompoundNBT;

public class VLLongMaxTransferBattery
implements IVLLongEnergyStorage {
    protected final IOMode mode;
    protected long capacity;
    protected long stored = 0L;

    public VLLongMaxTransferBattery(long capacity, IOMode mode) {
        this.capacity = capacity;
        this.mode = mode;
    }

    @Override
    public IOMode getIOMode() {
        return this.mode;
    }

    @Override
    public int receiveEnergyForced(int maxReceive, boolean simulate) {
        int intCap = (int)Math.min(this.capacity, Integer.MAX_VALUE);
        int intSto = (int)Math.min(this.stored, Integer.MAX_VALUE);
        int energyReceived = Math.min(intCap - intSto, Math.min(intCap, maxReceive));
        if (!simulate) {
            this.stored += (long)energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int extractEnergyForced(int maxExtract, boolean simulate) {
        int intCap = (int)Math.min(this.capacity, Integer.MAX_VALUE);
        int intSto = (int)Math.min(this.stored, Integer.MAX_VALUE);
        int energyExtracted = Math.min(intSto, Math.min(intCap, maxExtract));
        if (!simulate) {
            this.stored -= (long)energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public long receiveEnergyForced(long maxReceive, boolean simulate) {
        long energyReceived = Math.min(this.capacity - this.stored, Math.min(this.capacity, maxReceive));
        if (!simulate) {
            this.stored += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public long extractEnergyForced(long maxExtract, boolean simulate) {
        long energyExtracted = Math.min(this.stored, Math.min(this.capacity, maxExtract));
        if (!simulate) {
            this.stored -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long getStored() {
        return this.stored;
    }

    public int getEnergyStored() {
        return (int)Math.min(this.stored, Integer.MAX_VALUE);
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(this.capacity, Integer.MAX_VALUE);
    }

    @Override
    public CompoundNBT serializeNBT() {
        return NBTBuilder.create().putLong("capacity", this.capacity).putLong("stored", this.stored).build();
    }

    @Override
    public void deserializeNBT(CompoundNBT compoundNBT) {
        if (compoundNBT.func_74764_b("capacity")) {
            this.capacity = compoundNBT.func_74763_f("capacity");
        }
        if (compoundNBT.func_74764_b("stored")) {
            this.stored = compoundNBT.func_74763_f("stored");
        }
    }

    public int getEnergyRoom() {
        return (int)Math.min(this.capacity - this.stored, Integer.MAX_VALUE);
    }
}

