/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.integration.forge.energy.tile;

import com.valkyrieofnight.vlib.core.util.convenience.ITick;
import com.valkyrieofnight.vlib.core.util.enums.EnumIO;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action;
import com.valkyrieofnight.vlib.core.util.obj.InventoryUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyIOHandlerOld
implements ITick {
    private final Action setChangedMethod;
    private final IInventory energyIO;
    private final IEnergyStorage energyStorage;
    protected int energyContainerInput = 0;
    protected int energyContainerBuffer = 1;
    protected int energyContainerOutput = 2;
    protected EnumIO mode;
    protected boolean ignoreItemEnergyTransferLimits;

    public EnergyIOHandlerOld(IInventory energyIO, IEnergyStorage energyStorage, EnumIO mode, boolean ignoreItemEnergyTransferLimits, Action setChangedMethod) {
        this.energyIO = energyIO;
        this.energyStorage = energyStorage;
        this.setChangedMethod = setChangedMethod;
        this.mode = mode;
        this.ignoreItemEnergyTransferLimits = ignoreItemEnergyTransferLimits;
    }

    public EnergyIOHandlerOld(IInventory energyIO, IEnergyStorage energyStorage, EnumIO mode, boolean ignoreItemEnergyTransferLimits) {
        this(energyIO, energyStorage, mode, ignoreItemEnergyTransferLimits, () -> {});
    }

    public void changeIOSlots(int input, int buffer, int output) {
        this.energyContainerInput = input;
        this.energyContainerBuffer = buffer;
        this.energyContainerOutput = output;
    }

    @Override
    public void tick() {
        if (this.energyIO.func_70301_a(this.energyContainerBuffer).func_190926_b() && this.energyStorageIsValid()) {
            InventoryUtils.moveItem(this.energyIO, this.energyContainerInput, this.energyContainerBuffer, 1, false);
            this.setChangedMethod.execute();
        }
        if (!this.energyIO.func_70301_a(this.energyContainerBuffer).func_190926_b()) {
            boolean itemFinishedProcessing = this.processItem(this.energyIO.func_70301_a(this.energyContainerBuffer));
            if (itemFinishedProcessing) {
                InventoryUtils.moveItem(this.energyIO, this.energyContainerBuffer, this.energyContainerOutput, 1, false);
            }
            this.setChangedMethod.execute();
        }
    }

    private boolean processItem(ItemStack stack) {
        AtomicBoolean processed = new AtomicBoolean(false);
        if (this.mode == EnumIO.INPUT) {
            stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(es -> {
                int stackMaxExtractAmount = es.extractEnergy(Integer.MAX_VALUE, true);
                int storageReceiveAmount = this.energyStorage.receiveEnergy(stackMaxExtractAmount, false);
                es.extractEnergy(storageReceiveAmount, false);
                if (es.getEnergyStored() == 0) {
                    processed.set(true);
                }
            });
        } else {
            stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(es -> {
                int storageMaxExtractAmount = this.energyStorage.extractEnergy(Integer.MAX_VALUE, true);
                int stackReceiveAmount = es.receiveEnergy(storageMaxExtractAmount, false);
                this.energyStorage.extractEnergy(stackReceiveAmount, false);
                if (es.getEnergyStored() == es.getMaxEnergyStored()) {
                    processed.set(true);
                }
            });
        }
        return processed.get();
    }

    private boolean energyStorageIsValid() {
        return this.mode == EnumIO.INPUT ? this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored() : this.energyStorage.getEnergyStored() > 0;
    }
}

