/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.modifier.attribute;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.modifier.attribute.Attribute;
import com.valkyrieofnight.vlib.modifier.attribute.AttributeID;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class AttributeRegistry {
    private static volatile AttributeRegistry inst;
    protected volatile ConcurrentMap<AttributeID, Attribute> attributeMap = Maps.newConcurrentMap();

    public static AttributeRegistry getInstance() {
        if (inst == null) {
            inst = new AttributeRegistry();
        }
        return inst;
    }

    private AttributeRegistry() {
    }

    public void register(Attribute attribute) {
        if (attribute == null) {
            return;
        }
        this.attributeMap.put(attribute.getID(), attribute);
    }

    public boolean hasAttribute(AttributeID attributeID) {
        if (attributeID == null) {
            return false;
        }
        return this.attributeMap.containsKey(attributeID);
    }

    public Attribute getByID(AttributeID attributeID) {
        if (!this.attributeMap.containsKey(attributeID)) {
            return null;
        }
        return (Attribute)this.attributeMap.get(attributeID);
    }

    public List<ITextComponent> getTooltipList(CompoundNBT nbt) {
        ArrayList tt = Lists.newArrayList();
        for (Map.Entry aent : this.attributeMap.entrySet()) {
            AttributeID id = (AttributeID)aent.getKey();
            Attribute attr = (Attribute)aent.getValue();
            if (!nbt.func_74764_b(id.toString())) continue;
            tt.add(attr.generateTooltip(nbt));
        }
        return tt;
    }
}

