/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.modloader.events;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.module.registry.IMCRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.stats.StatType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvent;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.blockplacer.BlockPlacerType;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.IRuleTestType;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeRegEvents
implements IMCRegistry {
    private List<Block> blocks = Lists.newCopyOnWriteArrayList();
    private List<TileEntityType<?>> tileTypes = Lists.newCopyOnWriteArrayList();
    private List<Item> items = Lists.newCopyOnWriteArrayList();
    private List<Fluid> fluids = Lists.newCopyOnWriteArrayList();
    private List<EntityType<?>> entityTypes = Lists.newCopyOnWriteArrayList();
    private List<Potion> potions = Lists.newCopyOnWriteArrayList();
    private List<DimensionType> dimensionTypes = Lists.newCopyOnWriteArrayList();
    private List<Effect> effects = Lists.newCopyOnWriteArrayList();
    private List<Enchantment> enchants = Lists.newCopyOnWriteArrayList();
    private List<ContainerType<?>> containerTypes = Lists.newCopyOnWriteArrayList();
    private List<IRecipeType<?>> recipeTypes = Lists.newCopyOnWriteArrayList();
    private List<IRecipeSerializer<?>> recipeSerializers = Lists.newCopyOnWriteArrayList();
    private List<SoundEvent> soundEvents = Lists.newCopyOnWriteArrayList();
    private List<IFutureReloadListener> listeners = Lists.newCopyOnWriteArrayList();
    private List<WorldCarver<?>> worldCarvers = Lists.newCopyOnWriteArrayList();
    private List<SurfaceBuilder<?>> surfaceBuilders = Lists.newCopyOnWriteArrayList();
    private List<Feature<?>> features = Lists.newCopyOnWriteArrayList();
    private List<Placement<?>> placements = Lists.newCopyOnWriteArrayList();
    private List<Biome> biomes = Lists.newCopyOnWriteArrayList();
    private List<BlockStateProviderType<?>> blockStateProviderTypes = Lists.newCopyOnWriteArrayList();
    private List<BlockPlacerType<?>> blockPlacerTypes = Lists.newCopyOnWriteArrayList();
    private List<FoliagePlacerType<?>> foliagePlacerTypes = Lists.newCopyOnWriteArrayList();
    private List<TreeDecoratorType<?>> treeDecoratorTypes = Lists.newCopyOnWriteArrayList();
    private List<ParticleType<? extends IParticleData>> particleTypes = Lists.newCopyOnWriteArrayList();
    private List<BiomeProvider> biomeProviderTypes = Lists.newCopyOnWriteArrayList();
    private List<ChunkGenerator> chunkGeneratorTypes = Lists.newCopyOnWriteArrayList();
    private List<PaintingType> paintingTypes = Lists.newCopyOnWriteArrayList();
    private List<VLID> customStats = Lists.newCopyOnWriteArrayList();
    private List<ChunkStatus> chunkStatuses = Lists.newCopyOnWriteArrayList();
    private List<Structure<?>> structures = Lists.newCopyOnWriteArrayList();
    private List<IRuleTestType> ruleTestTypes = Lists.newCopyOnWriteArrayList();
    private List<IStructureProcessorType> structureProcessorTypes = Lists.newCopyOnWriteArrayList();
    private List<IJigsawDeserializer> jigsawDeserializers = Lists.newCopyOnWriteArrayList();
    private List<StatType<?>> statTypes = Lists.newCopyOnWriteArrayList();
    private List<VillagerType> villagerTypes = Lists.newCopyOnWriteArrayList();
    private List<VillagerProfession> villagerProfessions = Lists.newCopyOnWriteArrayList();
    private List<PointOfInterestType> pointOfInterestTypes = Lists.newCopyOnWriteArrayList();
    private List<MemoryModuleType<?>> memoryModuleTypes = Lists.newCopyOnWriteArrayList();
    private List<SensorType<?>> sensorTypes = Lists.newCopyOnWriteArrayList();
    private List<Schedule> schedules = Lists.newCopyOnWriteArrayList();
    private List<Activity> activities = Lists.newCopyOnWriteArrayList();

    public ForgeRegEvents() {
        MinecraftForge.EVENT_BUS.addListener(this::eAddResourceLoaderEvent);
    }

    @SubscribeEvent
    public void eBlock(RegistryEvent.Register<Block> e) {
        this.blocks.forEach(block -> e.getRegistry().register((IForgeRegistryEntry)block));
    }

    @SubscribeEvent
    public void eTileType(RegistryEvent.Register<TileEntityType<?>> e) {
        this.tileTypes.forEach(tileType -> e.getRegistry().register((IForgeRegistryEntry)tileType));
    }

    @SubscribeEvent
    public void eItem(RegistryEvent.Register<Item> e) {
        this.items.forEach(item -> e.getRegistry().register((IForgeRegistryEntry)item));
    }

    @SubscribeEvent
    public void eFluid(RegistryEvent.Register<Fluid> e) {
        this.fluids.forEach(fluid -> e.getRegistry().register((IForgeRegistryEntry)fluid));
    }

    @SubscribeEvent
    public void eEntityType(RegistryEvent.Register<EntityType<?>> e) {
        this.entityTypes.forEach(entityType -> e.getRegistry().register((IForgeRegistryEntry)entityType));
    }

    @SubscribeEvent
    public void ePotion(RegistryEvent.Register<Potion> e) {
        this.potions.forEach(potion -> e.getRegistry().register((IForgeRegistryEntry)potion));
    }

    @SubscribeEvent
    public void eEffect(RegistryEvent.Register<Effect> e) {
        this.effects.forEach(effect -> e.getRegistry().register((IForgeRegistryEntry)effect));
    }

    @SubscribeEvent
    public void eSoundEvent(RegistryEvent.Register<SoundEvent> e) {
        this.soundEvents.forEach(soundEvent -> e.getRegistry().register((IForgeRegistryEntry)soundEvent));
    }

    @SubscribeEvent
    public void eEnchantment(RegistryEvent.Register<Enchantment> e) {
        this.enchants.forEach(enchantment -> e.getRegistry().register((IForgeRegistryEntry)enchantment));
    }

    @SubscribeEvent
    public void eContainerType(RegistryEvent.Register<ContainerType<?>> e) {
        this.containerTypes.forEach(containerType -> e.getRegistry().register((IForgeRegistryEntry)containerType));
    }

    private void eAddResourceLoaderEvent(AddReloadListenerEvent e) {
        for (IFutureReloadListener l : this.listeners) {
            e.addListener(l);
        }
    }

    @Override
    public void registerBlock(@NotNull Block block) {
        this.blocks.add(block);
    }

    @Override
    public void registerTileType(@NotNull TileEntityType<?> tile) {
        this.tileTypes.add(tile);
    }

    @Override
    public void registerItem(@NotNull Item item) {
        this.items.add(item);
    }

    @Override
    public void registerFluid(@NotNull Fluid fluid) {
        this.fluids.add(fluid);
    }

    @Override
    public void registerEntityType(@NotNull EntityType<?> entity) {
        this.entityTypes.add(entity);
    }

    @Override
    public void registerPotion(@NotNull Potion potion) {
        this.potions.add(potion);
    }

    @Override
    public void registerDimensionType(@NotNull DimensionType dimension) {
        this.dimensionTypes.add(dimension);
    }

    @Override
    public void registerEffect(@NotNull Effect effect) {
        this.effects.add(effect);
    }

    @Override
    public void registerEnchantment(@NotNull Enchantment enchant) {
        this.enchants.add(enchant);
    }

    @Override
    public void registerContainerType(@NotNull ContainerType<?> container) {
        this.containerTypes.add(container);
    }

    @Override
    public void registerRecipeType(@NotNull IRecipeType<?> recipeType) {
        this.recipeTypes.add(recipeType);
    }

    @Override
    public void registerRecipeSerializer(@NotNull IRecipeSerializer<?> recipeSerializer) {
        this.recipeSerializers.add(recipeSerializer);
    }

    @Override
    public void registerReloadListener(@NotNull IFutureReloadListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void registerWorldCarver(@NotNull WorldCarver<?> carver) {
        this.worldCarvers.add(carver);
    }

    @Override
    public void registerSurfaceBuilder(@NotNull SurfaceBuilder<?> surfaceBuilder) {
        this.surfaceBuilders.add(surfaceBuilder);
    }

    @Override
    public void registerFeature(@NotNull Feature<?> feature) {
        this.features.add(feature);
    }

    @Override
    public void registerPlacement(@NotNull Placement<?> decorator) {
        this.placements.add(decorator);
    }

    @Override
    public void registerBiome(@NotNull Biome biome) {
        this.biomes.add(biome);
    }

    @Override
    public void registerBlockStateProviderType(@NotNull BlockStateProviderType<?> blockStateProviderType) {
        this.blockStateProviderTypes.add(blockStateProviderType);
    }

    @Override
    public void registerBlockPlacerType(@NotNull BlockPlacerType<?> blockPlacerType) {
        this.blockPlacerTypes.add(blockPlacerType);
    }

    @Override
    public void registerFoliagePlacerType(@NotNull FoliagePlacerType<?> foliagePlacerType) {
        this.foliagePlacerTypes.add(foliagePlacerType);
    }

    @Override
    public void registerTreeDecoratorType(@NotNull TreeDecoratorType<?> treeDecoratorType) {
        this.treeDecoratorTypes.add(treeDecoratorType);
    }

    @Override
    public void registerParticleType(@NotNull ParticleType<? extends IParticleData> particleType) {
        this.particleTypes.add(particleType);
    }

    @Override
    public void registerBiomeProviderType(@NotNull BiomeProvider biomeProviderType) {
        this.biomeProviderTypes.add(biomeProviderType);
    }

    @Override
    public void registerChunkGeneratorType(@NotNull ChunkGenerator chunkGeneratorType) {
        this.chunkGeneratorTypes.add(chunkGeneratorType);
    }

    @Override
    public void registerPaintingType(@NotNull PaintingType paintingType) {
        this.paintingTypes.add(paintingType);
    }

    @Override
    public void registerCustomStat(@NotNull VLID customStat) {
        this.customStats.add(customStat);
    }

    @Override
    public void registerChunkStatus(@NotNull ChunkStatus chunkStatus) {
        this.chunkStatuses.add(chunkStatus);
    }

    @Override
    public void registerStructure(@NotNull Structure<?> structure) {
        this.structures.add(structure);
    }

    @Override
    public void registerRuleTestType(@NotNull IRuleTestType ruleTestType) {
        this.ruleTestTypes.add(ruleTestType);
    }

    @Override
    public void registerStructureProcessorType(@NotNull IStructureProcessorType structureProcessorType) {
        this.structureProcessorTypes.add(structureProcessorType);
    }

    @Override
    public void registerJigsawDeserializer(@NotNull IJigsawDeserializer jigsawDeserializer) {
        this.jigsawDeserializers.add(jigsawDeserializer);
    }

    @Override
    public void registerStatType(@NotNull StatType<?> stat) {
        this.statTypes.add(stat);
    }

    @Override
    public void registerVillagerType(@NotNull VillagerType villagerType) {
        this.villagerTypes.add(villagerType);
    }

    @Override
    public void registerVillagerProfession(@NotNull VillagerProfession villagerProfession) {
        this.villagerProfessions.add(villagerProfession);
    }

    @Override
    public void registerPointOfInterestType(@NotNull PointOfInterestType pointOfInterestType) {
        this.pointOfInterestTypes.add(pointOfInterestType);
    }

    @Override
    public void registerMemoryModuleType(@NotNull MemoryModuleType<?> memoryModuleType) {
        this.memoryModuleTypes.add(memoryModuleType);
    }

    @Override
    public void registerSensorType(@NotNull SensorType<?> sensorType) {
        this.sensorTypes.add(sensorType);
    }

    @Override
    public void registerSchedule(@NotNull Schedule schedule) {
        this.schedules.add(schedule);
    }

    @Override
    public void registerActivity(@NotNull Activity activity) {
        this.activities.add(activity);
    }
}

