/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.constructor;

import com.google.common.collect.Queues;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.util.WorldUtils;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action1a;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Function2a;
import com.valkyrieofnight.vlib.core.util.math.BlockOffset;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.multiblock.Structure;
import com.valkyrieofnight.vlib.multiblock.component.Component;
import com.valkyrieofnight.vlib.multiblock.component.ComponentLayoutList;
import com.valkyrieofnight.vlib.multiblock.constructor.IConstructor;
import com.valkyrieofnight.vlib.multiblock.constructor.base.Formation;
import com.valkyrieofnight.vlib.multiblock.obj.tile.ISlave;
import com.valkyrieofnight.vlib.multiblock.obj.tile.impl.ControllerTile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ContinuousConstructor
implements IConstructor {
    private State state = State.IDLE;
    private ControllerTile controller;
    private int currentStructureID;
    private Structure structure;
    private boolean structureChanged = false;
    private Queue<Map.Entry<BlockOffset, Component>> queue = Queues.newArrayDeque();
    private int scanRateForming = 12;
    private int scanRateValidation = 4;
    private Formation formation;
    private Queue<XYZOrientation> validOrientations = Queues.newArrayDeque();
    private XYZOrientation lastOrientation;
    private XYZOrientation currentOrientation;
    private Action1a<Queue<XYZOrientation>> populateValid;
    private Action onMultiblockFormed;
    private Action onMultiblockDeform;
    private Action onMultiblockDeformationComplete;

    public ContinuousConstructor(ControllerTile cont, Action1a<Queue<XYZOrientation>> populateValid, int structureID) {
        this.controller = cont;
        this.currentStructureID = structureID;
        this.formation = new Formation(cont);
        this.populateValid = populateValid;
    }

    public ContinuousConstructor(ControllerTile controller, Action1a<Queue<XYZOrientation>> populateValid) {
        this(controller, populateValid, controller.getStructureID());
    }

    public State getState() {
        return this.state;
    }

    @Override
    public ControllerTile getTile() {
        return this.controller;
    }

    @Override
    public XYZOrientation getOrientation() {
        return this.isFormed() ? this.currentOrientation : null;
    }

    @Override
    public Collection<BlockPos> getAllOfType(Component comp) {
        ComponentLayoutList list = this.structure.getLayoutList(comp);
        if (list == null && this.currentOrientation != null) {
            return new ArrayList<BlockPos>();
        }
        return list.getAllRotated(this.controller.func_174877_v(), this.currentOrientation);
    }

    @Override
    public boolean isSlave(BlockPos pos) {
        if (pos == null || !this.isFormed()) {
            return false;
        }
        BlockOffset o2 = BlockOffset.getOffset(pos, this.controller.func_174877_v()).getRotatedOpposite(this.currentOrientation);
        return this.formation.check(o2);
    }

    @Override
    public boolean isFormed() {
        return this.formation.isFormed();
    }

    @Override
    public boolean isDeformed() {
        return !this.formation.isFormed();
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        if (type == SaveDataType.TO_CLIENT) {
            if (this.getOrientation() != null) {
                nbt.func_74768_a("orientation", this.getOrientation().getIndex());
            }
            if (this.formation != null) {
                nbt.func_218657_a("formation", (INBT)this.formation.serializeNBT());
            }
        }
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt, SaveDataType type) {
        if (type == SaveDataType.FROM_SERVER) {
            if (nbt.func_74764_b("orientation")) {
                this.currentOrientation = XYZOrientation.getByIndex(nbt.func_74762_e("orientation"));
            }
            if (nbt.func_74764_b("formation")) {
                this.formation.deserializeNBT(nbt.func_74775_l("formation"));
            }
        }
    }

    public boolean changeStructure(int newStructureID) {
        if (!this.controller.getStructureList().hasStructure(newStructureID)) {
            return false;
        }
        if (this.currentStructureID == newStructureID) {
            return false;
        }
        this.structureChanged = true;
        this.currentStructureID = newStructureID;
        if (this.formation.isFormed() || this.formation.isPartiallyFormed()) {
            this.setDeform();
        } else {
            this.setIdle();
        }
        return true;
    }

    private void setIdle() {
        this.state = State.IDLE;
    }

    private void setForm() {
        this.state = State.FORM;
    }

    private void setActive() {
        if (this.isFormed() && this.onMultiblockFormed != null) {
            this.onMultiblockFormed.execute();
        }
        this.state = State.ACTIVE;
    }

    private void setDeform() {
        this.queue.clear();
        this.formation.populateQueueWithClaimed(this.structure, this.queue);
        if (this.onMultiblockDeform != null) {
            this.onMultiblockDeform.execute();
        }
        this.state = State.DEFORM;
    }

    protected boolean setupNewStructure(int id) {
        if (this.controller.getStructureList() == null) {
            return false;
        }
        if (this.controller.getStructureList().getStructure(id) == null) {
            return false;
        }
        this.structure = this.controller.getStructureList().getStructure(id);
        this.currentStructureID = id;
        return true;
    }

    protected void resetConstructor() {
        this.queue.clear();
        this.formation.setFormed(false);
        this.formation.setup(this.structure);
        this.formation.populateQueueWithAll(this.getStructure(), this.queue);
        this.setIdle();
    }

    private boolean nextOrientation() {
        if (this.queue.isEmpty() || this.structureChanged) {
            return false;
        }
        if (this.validOrientations.isEmpty()) {
            this.validOrientations = Queues.newArrayDeque();
            this.populateValid.execute(this.validOrientations);
        }
        this.currentOrientation = this.validOrientations.poll();
        return true;
    }

    @Override
    public void tick() {
        World world = this.controller.func_145831_w();
        if (world.func_201670_d()) {
            return;
        }
        switch (this.state) {
            case IDLE: {
                if (this.structureChanged || this.structure == null) {
                    if (!this.setupNewStructure(this.currentStructureID)) {
                        return;
                    }
                    this.structureChanged = false;
                }
                this.resetConstructor();
                if (!this.nextOrientation()) break;
                this.setForm();
                break;
            }
            case FORM: {
                this.scan(this.scanRateForming, (ent, te) -> {
                    if (te instanceof ISlave && ((Component)ent.getValue()).isValid((TileEntity)te, this.currentOrientation) && !((ISlave)te).hasController()) {
                        if (((Component)ent.getValue()).shouldUpdateStatePostPlacement()) {
                            int flags = 3;
                            BlockState oldState = te.func_195044_w();
                            BlockState state = WorldUtils.updateBlockPostPlacement((IWorld)world, ((Component)ent.getValue()).validateState(oldState, this.currentOrientation), te.func_174877_v());
                            world.func_175656_a(te.func_174877_v(), state);
                        }
                        this.formation.setClaimed((BlockOffset)ent.getKey(), true);
                        ((ISlave)te).setController(this.controller);
                        return true;
                    }
                    this.setDeform();
                    return false;
                }, null);
                if (this.queue.isEmpty() && (this.formation.isPartiallyFormed() || this.formation.isUnformed())) {
                    this.setDeform();
                    break;
                }
                if (!this.queue.isEmpty() || !this.formation.isFormed()) break;
                this.setActive();
                break;
            }
            case DEFORM: {
                this.scan(this.scanRateForming, (ent, te) -> {
                    if (te instanceof ISlave) {
                        ((ISlave)te).removeController(this.controller.func_174877_v());
                    }
                    this.formation.setClaimed((BlockOffset)ent.getKey(), false);
                    return true;
                }, null);
                if (!this.queue.isEmpty()) break;
                if (!this.formation.isUnformed()) {
                    this.formation.populateQueueWithClaimed(this.structure, this.queue);
                    break;
                }
                if (this.onMultiblockDeformationComplete != null) {
                    this.onMultiblockDeformationComplete.execute();
                }
                this.setIdle();
                break;
            }
            case ACTIVE: {
                this.scan(this.scanRateValidation, (ent, te) -> {
                    if (te instanceof ISlave && ((Component)ent.getValue()).isValid((TileEntity)te, this.currentOrientation)) {
                        if (!this.isSlave(te.func_174877_v()) || !this.controller.func_174877_v().equals((Object)((ISlave)te).getController())) {
                            this.setDeform();
                            return false;
                        }
                    } else {
                        this.setDeform();
                        return false;
                    }
                    return true;
                }, null);
                if (!this.queue.isEmpty() || !this.formation.isFormed()) break;
                this.formation.populateQueueWithAll(this.structure, this.queue);
            }
        }
    }

    private Structure getStructure() {
        return this.structure;
    }

    private void scan(int count, @NotNull Function2a<Map.Entry<BlockOffset, Component>, TileEntity, Boolean> funct, @Nullable Action onEmpty) {
        for (int i = 0; i < count && !this.queue.isEmpty(); ++i) {
            TileEntity te;
            Map.Entry<BlockOffset, Component> ent = this.queue.poll();
            if (ent == null) continue;
            BlockPos p = ent.getKey().getRotatedPosition(this.currentOrientation, this.controller.func_174877_v());
            if (!this.controller.func_145831_w().func_195588_v(p) || !funct.execute(ent, te = this.controller.func_145831_w().func_175625_s(p)).booleanValue()) break;
        }
    }

    public void setOnMultiblockFormed(Action action) {
        this.onMultiblockFormed = action;
    }

    public void setOnMultiblockDeform(Action action) {
        this.onMultiblockDeform = action;
    }

    public void setOnMultiblockDeformationComplete(Action action) {
        this.onMultiblockDeformationComplete = action;
    }

    private static enum State {
        IDLE,
        FORM,
        ACTIVE,
        DEFORM;

    }
}

