/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.ui.client.auto;

import com.valkyrieofnight.vlib.VLib;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizableBGElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.IconButtonElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.FixedContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.text.LabelElement;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.util.client.TextComponentUtil;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.math.RelativeDirection;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.multiblock.autoutil.AutoMode;
import com.valkyrieofnight.vlib.multiblock.obj.tile.IController;
import com.valkyrieofnight.vlib.multiblock.ui.ControllerAutoPacket;
import java.util.Collections;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ControllerDirButton
extends FixedContainerElement {
    protected static final Color4 FORMED_BG_COLOR = new Color4(0.53f, 0.82f, 0.94f);
    protected IController tile;
    protected PlayerEntity player;
    protected XYZOrientation orientation;
    protected IconButtonElement preview;
    protected IconButtonElement buildMB;
    protected IconButtonElement breakMB;
    protected IconButtonElement breakAndBuildMB;

    public ControllerDirButton(String id, IController tile, PlayerEntity pe, XYZOrientation orientation, int width) {
        super(id, width, 48);
        this.tile = tile;
        this.player = pe;
        this.orientation = orientation;
    }

    @Override
    public void addElements() {
        boolean isFormed = this.tile.isFormed();
        boolean isOrientation = this.tile.getOrientation() == this.orientation;
        SizableBGElement bg = new SizableBGElement("bg", StandardThemeAssets.GSB_VLIB_GRAY_INNER_BG);
        if (isFormed && isOrientation) {
            bg.setColor(FORMED_BG_COLOR);
        }
        this.addElement(bg, 0, 0);
        String fDir = "label.valkyrielib.direction." + this.orientation.getDirectionFrom(RelativeDirection.FORWARD).func_176742_j();
        IFormattableTextComponent forward = TextComponentUtil.createTranslated("label.valkyrielib.directiond.forward").func_230529_a_((ITextComponent)TextComponentUtil.createStr(": ")).func_230529_a_((ITextComponent)TextComponentUtil.createTranslated(fDir));
        this.addElement(new LabelElement("f", (ITextComponent)forward, StandardThemeAssets.COL_CONTAINER_TITLE_TEXT), 4, 4);
        String uDir = "label.valkyrielib.direction." + this.orientation.getDirectionFrom(RelativeDirection.UP).func_176742_j();
        IFormattableTextComponent upward = TextComponentUtil.createTranslated("label.valkyrielib.directiond.up").func_230529_a_((ITextComponent)TextComponentUtil.createStr(": ")).func_230529_a_((ITextComponent)TextComponentUtil.createTranslated(uDir));
        this.addElement(new LabelElement("u", (ITextComponent)upward, StandardThemeAssets.COL_CONTAINER_TITLE_TEXT), 4, 16);
        AssetID blde = StandardThemeAssets.TEX_SYM_FLAT_48_HAMMER;
        AssetID brke = StandardThemeAssets.TEX_SYM_FLAT_48_WRENCH;
        AssetID cabe = StandardThemeAssets.TEX_SYM_FLAT_48_CONSTRUCTION;
        this.preview = ControllerDirButton.createButton("preiview", 16, 16, blde, "label.valkyrielib.button.preview");
        this.addElement(this.preview, 4, 28);
        this.buildMB = ControllerDirButton.createButton("build", 16, 16, blde, "label.valkyrielib.button.ddtb");
        this.addElement(this.buildMB, 24, 28);
        this.breakMB = ControllerDirButton.createButton("break", 16, 16, brke, "label.valkyrielib.button.break_multiblock");
        this.addElement(this.breakMB, 44, 28);
        this.breakAndBuildMB = ControllerDirButton.createButton("b_a_b", 16, 16, cabe, "label.valkyrielib.button.ddtb");
        this.addElement(this.breakAndBuildMB, 64, 28);
        this.preview.setEnabled(!isFormed);
        this.buildMB.setEnabled(false);
        this.breakAndBuildMB.setEnabled(false);
    }

    public static IconButtonElement createButton(String id, int w, int h, AssetID icon, String hoverUnlocalized) {
        IconButtonElement btn = new IconButtonElement(id, w, h, icon, icon, icon, icon);
        btn.setToolTipList(Collections.singletonList(new TranslationTextComponent(hoverUnlocalized)));
        return btn;
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        if (element == this.preview) {
            VLib.NETWORK_HANDLER.sendToServer(new ControllerAutoPacket(this.tile.getPosition(), this.player.func_110124_au(), AutoMode.PREVIEW, this.orientation));
        } else if (element == this.buildMB) {
            VLib.NETWORK_HANDLER.sendToServer(new ControllerAutoPacket(this.tile.getPosition(), this.player.func_110124_au(), AutoMode.BUILD, this.orientation));
        } else if (element == this.breakMB) {
            VLib.NETWORK_HANDLER.sendToServer(new ControllerAutoPacket(this.tile.getPosition(), this.player.func_110124_au(), AutoMode.BREAK, this.orientation));
        } else if (element == this.breakAndBuildMB) {
            VLib.NETWORK_HANDLER.sendToServer(new ControllerAutoPacket(this.tile.getPosition(), this.player.func_110124_au(), AutoMode.BREAK_AND_BUILD, this.orientation));
        }
        super.mouseClickedResponse(element, mouseX, mouseY, mouseButton);
    }
}

