/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.conditiondata;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.io.nbt.INBTHandler;
import com.valkyrieofnight.vlib.core.util.logic.operators.RelationalOperator;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import com.valkyrieofnight.vlib.registry.conditiondata.base.ConditionID;
import com.valkyrieofnight.vlib.registry.conditiondata.base.ConditionScope;
import com.valkyrieofnight.vlib.registry.conditiondata.base.ConditionType;
import com.valkyrieofnight.vlib.registry.provider.statement.Comparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;

public abstract class ConditionData<FINAL_TYPE extends ConditionData, VARIABLE_TYPE>
implements INBTHandler<FINAL_TYPE> {
    protected ConditionType type;
    protected Comparator<VARIABLE_TYPE> comparator;
    protected ConditionID id;
    protected List<ConditionScope> scopes = Lists.newArrayList();
    protected VARIABLE_TYPE value;
    protected VARIABLE_TYPE valueDefault;

    public ConditionData(ConditionType type, Comparator<VARIABLE_TYPE> comparator, ConditionID id, List<ConditionScope> scopes, VARIABLE_TYPE valueDefault) {
        this.id = id;
        this.type = type;
        this.comparator = comparator;
        this.valueDefault = valueDefault;
        this.scopes.addAll(scopes);
    }

    protected ConditionScope[] getScopesArray() {
        return this.scopes.toArray(new ConditionScope[this.scopes.size()]);
    }

    public final VARIABLE_TYPE getValue() {
        return this.value;
    }

    public void setValue(VARIABLE_TYPE value) {
        this.value = value;
    }

    public ConditionID getId() {
        return this.id;
    }

    public boolean isValidScope(ConditionScope scope) {
        return scope != null ? this.scopes.contains((Object)scope) : false;
    }

    public boolean testCondition(RelationalOperator operator, VARIABLE_TYPE other) {
        return this.comparator.compare(this.value, operator, other);
    }

    public abstract FINAL_TYPE copy();

    public abstract void applyParameters(FINAL_TYPE var1);

    public static class StringCondition
    extends ConditionData<StringCondition, String> {
        public static StringCondition EMPTY = new StringCondition(ConditionID.fromString("empty:string"), Lists.newArrayList((Object[])ConditionScope.getAll()), "");

        public StringCondition(ConditionID id, List<ConditionScope> scopes, String valueDefault) {
            super(ConditionType.STRING, Comparator.STRING, id, scopes, valueDefault);
        }

        @Override
        public StringCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new StringCondition(this.id, copy, (String)this.valueDefault);
        }

        @Override
        public void applyParameters(StringCondition template) {
            this.valueDefault = template.valueDefault;
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public StringCondition readFromNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b(this.id.toString())) {
                this.value = nbt.func_74779_i(this.id.toString());
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            nbt.func_74778_a(this.id.toString(), (String)this.value);
            return nbt;
        }
    }

    public static class CharCondition
    extends ConditionData<CharCondition, Character> {
        public static CharCondition EMPTY = new CharCondition(ConditionID.fromString("empty:char"), Lists.newArrayList((Object[])ConditionScope.getAll()), ' ');

        public CharCondition(ConditionID id, List<ConditionScope> scopes, char valueDefault) {
            super(ConditionType.CHAR, Comparator.CHAR, id, scopes, Character.valueOf(valueDefault));
        }

        @Override
        public CharCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new CharCondition(this.id, copy, ((Character)this.valueDefault).charValue());
        }

        @Override
        public void applyParameters(CharCondition template) {
            this.valueDefault = template.valueDefault;
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public CharCondition readFromNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b(this.id.toString())) {
                this.value = Character.valueOf(nbt.func_74779_i(this.id.toString()).charAt(0));
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            nbt.func_74778_a(this.id.toString(), "" + this.value);
            return null;
        }
    }

    public static class DoubleCondition
    extends ConditionData<DoubleCondition, Double> {
        public static DoubleCondition EMPTY = new DoubleCondition(ConditionID.fromString("empty:double"), Lists.newArrayList((Object[])ConditionScope.getAll()), 0.0);
        protected double min;
        protected double max;

        public DoubleCondition(ConditionID id, List<ConditionScope> scopes, double valueDefault) {
            this(id, scopes, valueDefault, Double.MIN_VALUE, Double.MAX_VALUE);
        }

        public DoubleCondition(ConditionID id, List<ConditionScope> scopes, double valueDefault, double min, double max) {
            super(ConditionType.DOUBLE, Comparator.DOUBLE, id, scopes, valueDefault);
            this.min = min;
            this.max = max;
        }

        @Override
        public DoubleCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new DoubleCondition(this.id, copy, (Double)this.valueDefault, this.min, this.max);
        }

        @Override
        public void applyParameters(DoubleCondition template) {
            this.valueDefault = template.valueDefault;
            this.min = template.min;
            this.max = template.max;
            this.value = MathUtil.clamp((Double)this.value, this.min, this.max);
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public DoubleCondition readFromNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b(this.id.toString())) {
                this.value = nbt.func_74769_h(this.id.toString());
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            nbt.func_74780_a(this.id.toString(), ((Double)this.value).doubleValue());
            return nbt;
        }
    }

    public static class FloatCondition
    extends ConditionData<FloatCondition, Float> {
        public static FloatCondition EMPTY = new FloatCondition(ConditionID.fromString("empty:float"), Lists.newArrayList((Object[])ConditionScope.getAll()), 0.0f);
        protected float min;
        protected float max;

        public FloatCondition(ConditionID id, List<ConditionScope> scopes, float valueDefault) {
            this(id, scopes, valueDefault, Float.MIN_VALUE, Float.MAX_VALUE);
        }

        public FloatCondition(ConditionID id, List<ConditionScope> scopes, float valueDefault, float min, float max) {
            super(ConditionType.FLOAT, Comparator.FLOAT, id, scopes, Float.valueOf(valueDefault));
            this.min = min;
            this.max = max;
        }

        @Override
        public FloatCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new FloatCondition(this.id, copy, ((Float)this.valueDefault).floatValue(), this.min, this.max);
        }

        @Override
        public void applyParameters(FloatCondition template) {
            this.valueDefault = template.valueDefault;
            this.min = template.min;
            this.max = template.max;
            this.value = Float.valueOf(MathUtil.clamp(((Float)this.value).floatValue(), this.min, this.max));
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public FloatCondition readFromNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b(this.id.toString())) {
                this.value = Float.valueOf(nbt.func_74760_g(this.id.toString()));
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            nbt.func_74776_a(this.id.toString(), ((Float)this.value).floatValue());
            return nbt;
        }
    }

    public static class LongCondition
    extends ConditionData<LongCondition, Long> {
        public static LongCondition EMPTY = new LongCondition(ConditionID.fromString("empty:long"), Lists.newArrayList((Object[])ConditionScope.getAll()), 0L);
        protected long min;
        protected long max;

        public LongCondition(ConditionID id, List<ConditionScope> scopes, long valueDefault) {
            this(id, scopes, valueDefault, Long.MIN_VALUE, Long.MAX_VALUE);
        }

        public LongCondition(ConditionID id, List<ConditionScope> scopes, long valueDefault, long min, long max) {
            super(ConditionType.LONG, Comparator.LONG, id, scopes, valueDefault);
            this.min = min;
            this.max = max;
        }

        @Override
        public LongCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new LongCondition(this.id, copy, (Long)this.valueDefault, this.min, this.max);
        }

        @Override
        public void applyParameters(LongCondition template) {
            this.valueDefault = template.valueDefault;
            this.min = template.min;
            this.max = template.max;
            this.value = MathUtil.clamp((Long)this.value, this.min, this.max);
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public LongCondition readFromNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b(this.id.toString())) {
                this.value = nbt.func_74763_f(this.id.toString());
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            nbt.func_74772_a(this.id.toString(), ((Long)this.value).longValue());
            return nbt;
        }
    }

    public static class IntCondition
    extends ConditionData<IntCondition, Integer> {
        public static IntCondition EMPTY = new IntCondition(ConditionID.fromString("empty:int"), Lists.newArrayList((Object[])ConditionScope.getAll()), 0);
        protected int min;
        protected int max;

        public IntCondition(ConditionID id, List<ConditionScope> scopes, int valueDefault) {
            this(id, scopes, valueDefault, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        public IntCondition(ConditionID id, List<ConditionScope> scopes, int valueDefault, int min, int max) {
            super(ConditionType.INT, Comparator.INT, id, scopes, valueDefault);
            this.min = min;
            this.max = max;
        }

        @Override
        public IntCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new IntCondition(this.id, copy, (Integer)this.valueDefault, this.min, this.max);
        }

        @Override
        public void applyParameters(IntCondition template) {
            this.valueDefault = template.valueDefault;
            this.min = template.min;
            this.max = template.max;
            this.value = MathUtil.clamp((Integer)this.value, this.min, this.max);
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public IntCondition readFromNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b(this.id.toString())) {
                this.value = nbt.func_74762_e(this.id.toString());
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            nbt.func_74768_a(this.id.toString(), ((Integer)this.value).intValue());
            return nbt;
        }
    }

    public static class ShortCondition
    extends ConditionData<ShortCondition, Short> {
        public static ShortCondition EMPTY = new ShortCondition(ConditionID.fromString("empty:short"), Lists.newArrayList((Object[])ConditionScope.getAll()), 0);
        protected short min;
        protected short max;

        public ShortCondition(ConditionID id, List<ConditionScope> scopes, short valueDefault) {
            this(id, scopes, valueDefault, Short.MIN_VALUE, Short.MAX_VALUE);
        }

        public ShortCondition(ConditionID id, List<ConditionScope> scopes, short valueDefault, short min, short max) {
            super(ConditionType.SHORT, Comparator.SHORT, id, scopes, valueDefault);
            this.min = min;
            this.max = max;
        }

        @Override
        public ShortCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new ShortCondition(this.id, copy, (Short)this.valueDefault, this.min, this.max);
        }

        @Override
        public void applyParameters(ShortCondition template) {
            this.valueDefault = template.valueDefault;
            this.min = template.min;
            this.max = template.max;
            this.value = MathUtil.clamp((Short)this.value, this.min, this.max);
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public ShortCondition readFromNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b(this.id.toString())) {
                this.value = nbt.func_74765_d(this.id.toString());
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            nbt.func_74777_a(this.id.toString(), ((Short)this.value).shortValue());
            return nbt;
        }
    }

    public static class ByteCondition
    extends ConditionData<ByteCondition, Byte> {
        public static ByteCondition EMPTY = new ByteCondition(ConditionID.fromString("empty:byte"), Lists.newArrayList((Object[])ConditionScope.getAll()), 0);
        protected byte min;
        protected byte max;

        public ByteCondition(ConditionID id, List<ConditionScope> scopes, byte valueDefault) {
            this(id, scopes, valueDefault, -128, 127);
        }

        public ByteCondition(ConditionID id, List<ConditionScope> scopes, byte valueDefault, byte valueMin, byte valueMax) {
            super(ConditionType.BYTE, Comparator.BYTE, id, scopes, valueDefault);
            this.min = valueMin;
            this.max = valueMax;
        }

        @Override
        public void setValue(Byte value) {
            this.value = MathUtil.clamp(value, this.min, this.max);
        }

        @Override
        public ByteCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new ByteCondition(this.id, copy, (Byte)this.valueDefault, this.min, this.max);
        }

        @Override
        public void applyParameters(ByteCondition template) {
            this.valueDefault = template.valueDefault;
            this.min = template.min;
            this.max = template.max;
            this.value = MathUtil.clamp((Byte)this.value, this.min, this.max);
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public ByteCondition readFromNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b(this.id.toString())) {
                this.value = nbt.func_74771_c(this.id.toString());
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            nbt.func_74774_a(this.id.toString(), ((Byte)this.value).byteValue());
            return nbt;
        }
    }

    public static class BooleanCondition
    extends ConditionData<BooleanCondition, Boolean> {
        public static BooleanCondition EMPTY = new BooleanCondition(ConditionID.fromString("empty:boolean"), Lists.newArrayList((Object[])ConditionScope.getAll()), false);

        public BooleanCondition(ConditionID id, List<ConditionScope> scopes, boolean valueDefault) {
            super(ConditionType.BOOLEAN, Comparator.BOOLEAN, id, scopes, valueDefault);
        }

        @Override
        public BooleanCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new BooleanCondition(this.id, copy, (Boolean)this.valueDefault);
        }

        @Override
        public void applyParameters(BooleanCondition template) {
            this.valueDefault = template.valueDefault;
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public BooleanCondition readFromNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b(this.id.toString())) {
                this.value = nbt.func_74767_n(this.id.toString());
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            nbt.func_74757_a(this.id.toString(), ((Boolean)this.value).booleanValue());
            return nbt;
        }
    }
}

