/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.ingredient.fluid;

import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import java.util.Collections;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;

public class FluidIngredient
extends Ingredient<FluidStack> {
    @NotNull
    private Fluid fluid;
    private int amount;

    public FluidIngredient(@NotNull Fluid fluid, int amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    public FluidIngredient(PacketBuffer packet) {
        super(packet);
    }

    @Override
    public boolean test(@NotNull ConditionContainerProvider provider, FluidStack test) {
        return test != null ? this.fluid.func_207187_a(test.getFluid()) && test.getAmount() > this.amount : false;
    }

    @Override
    public List<FluidStack> request(@NotNull ConditionContainerProvider provider) {
        return Collections.singletonList(new FluidStack(this.fluid, this.requestAmount(provider)));
    }

    @Override
    public int requestAmount(@NotNull ConditionContainerProvider provider) {
        return this.amount;
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        buffer.func_180714_a(FluidIngredient.getFromClass(this.getClass()));
        buffer.writeFluidStack(new FluidStack(this.fluid, this.amount));
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        FluidStack fs = buffer.readFluidStack();
        this.fluid = fs.getFluid();
        this.amount = fs.getAmount();
    }

    @Override
    public boolean isValid() {
        return this.fluid != null;
    }
}

