/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.ingredient.fluid;

import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializer;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializerRegistry;
import java.util.Collections;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;

public class FluidProviderIngredient
extends Ingredient<FluidStack> {
    @NotNull
    private Provider<Fluid> provider;
    private Provider<Integer> amount;

    public FluidProviderIngredient(@NotNull Provider<Fluid> provider, @NotNull Provider<Integer> amount) {
        this.provider = provider;
        this.amount = amount;
    }

    public FluidProviderIngredient(PacketBuffer packet) {
        super(packet);
    }

    @Override
    public boolean test(@NotNull ConditionContainerProvider provider, FluidStack test) {
        return test != null ? this.provider.request(provider).func_207187_a(test.getFluid()) && test.getAmount() > this.amount.request(provider) : false;
    }

    @Override
    public List<FluidStack> request(@NotNull ConditionContainerProvider provider) {
        return Collections.singletonList(new FluidStack(this.provider.request(provider), this.requestAmount(provider)));
    }

    @Override
    public int requestAmount(@NotNull ConditionContainerProvider provider) {
        return this.amount.request(provider);
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        buffer.func_180714_a(FluidProviderIngredient.getFromClass(this.getClass()));
        ProviderDeserializerRegistry PDR = ProviderDeserializerRegistry.getInstance();
        buffer.func_180714_a(PDR.getTypeIdentifier(this.provider.getClass()));
        this.provider.writePacketData(buffer);
        buffer.func_180714_a(PDR.getTypeIdentifier(this.amount.getClass()));
        this.amount.writePacketData(buffer);
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        ProviderDeserializerRegistry PDR = ProviderDeserializerRegistry.getInstance();
        ProviderDeserializer fpd = PDR.getFromType(buffer.func_218666_n());
        this.provider = fpd.createFromPacket(buffer);
        ProviderDeserializer apd = PDR.getFromType(buffer.func_218666_n());
        this.amount = apd.createFromPacket(buffer);
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

