/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.ingredient.item;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.obj.TagUtils;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.ingredient.TagIngredient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;

public class ItemTagIngredient
extends TagIngredient<ItemStack> {
    private VLID tag;
    private int count;

    public ItemTagIngredient(@NotNull VLID tag, int count, Ingredient.TagIngredientType selector) {
        super(selector);
        this.tag = tag;
        this.count = count;
    }

    public ItemTagIngredient(@NotNull VLID tag, int count, Ingredient.TagIngredientType selector, String[] values) {
        super(selector, values);
        this.tag = tag;
        this.count = count;
    }

    private ITag<Item> getTag() {
        return TagUtils.getItemTag(this.tag);
    }

    public ItemTagIngredient(PacketBuffer packet) {
        super(packet);
    }

    @Override
    public int getTotalTagEntries() {
        ITag<Item> tag = this.getTag();
        return tag != null ? tag.func_230236_b_().size() : 0;
    }

    @Override
    public boolean test(@NotNull ConditionContainerProvider provider, ItemStack test) {
        List<ItemStack> options = this.request(provider);
        for (ItemStack is : options) {
            if (!ItemStack.func_179545_c((ItemStack)is, (ItemStack)test)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> request(@NotNull ConditionContainerProvider provider) {
        int count = this.requestAmount(provider);
        ITag<Item> tag = this.getTag();
        if (tag == null) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        switch (this.selector) {
            case ALL_WHITELISTED: {
                if (this.properties.length > 0) {
                    TagUtils.addItemAllWhitelisted(list, tag, count, this.properties);
                    break;
                }
                TagUtils.addItemAll(list, tag, count);
                break;
            }
            case ALL: {
                TagUtils.addItemAll(list, tag, count);
                break;
            }
            case FIRST_WHITELISTED: {
                if (this.properties.length > 0) {
                    TagUtils.addItemFirstWhitelisted(list, tag, count, this.properties);
                } else {
                    TagUtils.addItemFirst(list, tag, count);
                }
            }
            case FIRST: {
                TagUtils.addItemFirst(list, tag, count);
                break;
            }
            case FIRST_PREFERRED: {
                TagUtils.addItemFirstPreferred(list, tag, count, this.properties);
                break;
            }
            case FIRST_WITH_BLACKLIST: {
                TagUtils.addItemFirstWithBlacklist(list, tag, count, this.properties);
                break;
            }
            case ALL_WITH_BLACKLIST: {
                TagUtils.addItemAllWithBlacklist(list, tag, count, this.properties);
            }
        }
        return list;
    }

    @Override
    public int requestAmount(@NotNull ConditionContainerProvider provider) {
        return this.count;
    }

    @Override
    public void writeOtherPacketData(PacketBuffer buffer) {
        buffer.func_180714_a(ItemTagIngredient.getFromClass(this.getClass()));
        buffer.func_192572_a((ResourceLocation)this.tag);
        buffer.writeInt(this.count);
    }

    @Override
    public void readOtherPacketData(PacketBuffer buffer) {
        this.tag = VLID.from(buffer.func_192575_l());
        this.count = buffer.readInt();
    }

    @Override
    public boolean isValid() {
        ITag<Item> tag = this.getTag();
        return tag != null && tag.func_230236_b_().size() > 0;
    }

    public String toString() {
        return "{tag:" + this.tag.toString() + ",count:" + this.count + "}";
    }
}

