/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.provider.deserializers;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializer;
import com.valkyrieofnight.vlib.registry.provider.deserializers.stack.DynamicStackProviderDeserializer;
import com.valkyrieofnight.vlib.registry.provider.deserializers.statement.IfElseProviderDeserializers;
import com.valkyrieofnight.vlib.registry.provider.deserializers.value.RawValueProviderDeserializers;
import com.valkyrieofnight.vlib.registry.provider.deserializers.value.ValueProviderDeserializers;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentMap;

public class ProviderDeserializerRegistry {
    private volatile ConcurrentMap<String, ProviderDeserializer> deserializerMap = Maps.newConcurrentMap();
    private volatile ConcurrentMap<String, Type> idToType = Maps.newConcurrentMap();
    private volatile ConcurrentMap<Type, String> typeToId = Maps.newConcurrentMap();
    private volatile ConcurrentMap<Class, ProviderDeserializer> classToDeserializer = Maps.newConcurrentMap();
    private volatile ConcurrentMap<Class, String> classToID = Maps.newConcurrentMap();
    private static ProviderDeserializerRegistry INSTANCE;

    public static ProviderDeserializerRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProviderDeserializerRegistry();
        }
        return INSTANCE;
    }

    private ProviderDeserializerRegistry() {
        this.registerDeserializer(ValueProviderDeserializers.BOOLEAN);
        this.registerDeserializer(ValueProviderDeserializers.BYTE);
        this.registerDeserializer(ValueProviderDeserializers.SHORT);
        this.registerDeserializer(ValueProviderDeserializers.INT);
        this.registerDeserializer(ValueProviderDeserializers.LONG);
        this.registerDeserializer(ValueProviderDeserializers.FLOAT);
        this.registerDeserializer(ValueProviderDeserializers.DOUBLE);
        this.registerDeserializer(ValueProviderDeserializers.CHAR);
        this.registerDeserializer(ValueProviderDeserializers.STRING);
        this.registerDeserializer(RawValueProviderDeserializers.BOOLEAN);
        this.registerDeserializer(RawValueProviderDeserializers.BYTE);
        this.registerDeserializer(RawValueProviderDeserializers.SHORT);
        this.registerDeserializer(RawValueProviderDeserializers.INT);
        this.registerDeserializer(RawValueProviderDeserializers.LONG);
        this.registerDeserializer(RawValueProviderDeserializers.FLOAT);
        this.registerDeserializer(RawValueProviderDeserializers.DOUBLE);
        this.registerDeserializer(RawValueProviderDeserializers.CHAR);
        this.registerDeserializer(RawValueProviderDeserializers.STRING);
        this.registerDeserializer(RawValueProviderDeserializers.ITEM);
        this.registerDeserializer(RawValueProviderDeserializers.FLUID);
        this.registerDeserializer(RawValueProviderDeserializers.COMPOUND_NBT);
        this.registerDeserializer(RawValueProviderDeserializers.ITEM_TAG);
        this.registerDeserializer(RawValueProviderDeserializers.FLUID_TAG);
        this.registerDeserializer(RawValueProviderDeserializers.ITEMSTACK);
        this.registerDeserializer(RawValueProviderDeserializers.FLUIDSTACK);
        this.registerDeserializer(IfElseProviderDeserializers.BOOLEAN);
        this.registerDeserializer(IfElseProviderDeserializers.BYTE);
        this.registerDeserializer(IfElseProviderDeserializers.SHORT);
        this.registerDeserializer(IfElseProviderDeserializers.INT);
        this.registerDeserializer(IfElseProviderDeserializers.LONG);
        this.registerDeserializer(IfElseProviderDeserializers.FLOAT);
        this.registerDeserializer(IfElseProviderDeserializers.DOUBLE);
        this.registerDeserializer(IfElseProviderDeserializers.CHAR);
        this.registerDeserializer(IfElseProviderDeserializers.STRING);
        this.registerDeserializer(IfElseProviderDeserializers.ITEM);
        this.registerDeserializer(IfElseProviderDeserializers.FLUID);
        this.registerDeserializer(IfElseProviderDeserializers.NBT);
        this.registerDeserializer(IfElseProviderDeserializers.ITEM_TAG);
        this.registerDeserializer(IfElseProviderDeserializers.FLUID_TAG);
        this.registerDeserializer(IfElseProviderDeserializers.ITEMSTACK);
        this.registerDeserializer(IfElseProviderDeserializers.FLUIDSTACK);
        this.registerDeserializer(DynamicStackProviderDeserializer.ITEMSTACK);
        this.registerDeserializer(DynamicStackProviderDeserializer.FLUIDSTACK);
    }

    private void registerDeserializer(ProviderDeserializer deserializer) {
        if (deserializer != null && !this.typeToId.containsKey(deserializer.getType()) && !this.idToType.containsKey(deserializer.getTypeIdentifier())) {
            this.deserializerMap.put(deserializer.getTypeIdentifier(), deserializer);
            this.idToType.put(deserializer.getTypeIdentifier(), deserializer.getType());
            this.typeToId.put(deserializer.getType(), deserializer.getTypeIdentifier());
            this.classToDeserializer.put(deserializer.clazz, deserializer);
            this.classToID.put(deserializer.clazz, deserializer.getTypeIdentifier());
        }
    }

    public Type getType(String typeIdentifier) {
        if (this.idToType.containsKey(typeIdentifier)) {
            return (Type)this.idToType.get(typeIdentifier);
        }
        return null;
    }

    public boolean hasDeserializer(String type) {
        return this.deserializerMap.containsKey(type);
    }

    public ProviderDeserializer[] getAllAsArray() {
        ProviderDeserializer[] arr = new ProviderDeserializer[this.deserializerMap.values().size()];
        return this.deserializerMap.values().toArray(arr);
    }

    public String getDataReturnType(Type type) throws Exception {
        String t = (String)this.typeToId.get(type);
        if (!StringUtils.isNullOrEmpty(t)) {
            return DeserializerUtils.getReturnDataType(t);
        }
        throw new Exception("No data type found for: " + type);
    }

    public ProviderDeserializer getFromType(String typeIdentifier) {
        if (!StringUtils.isNullOrEmpty(typeIdentifier) && this.deserializerMap.containsKey(typeIdentifier)) {
            return (ProviderDeserializer)this.deserializerMap.get(typeIdentifier);
        }
        return null;
    }

    public ProviderDeserializer getFromProviderClass(Class<? extends Provider> providerClass) {
        if (providerClass != null && this.classToDeserializer.containsKey(providerClass)) {
            return (ProviderDeserializer)this.classToDeserializer.get(providerClass);
        }
        return null;
    }

    public String getTypeIdentifier(Class<? extends Provider> providerClass) {
        if (providerClass != null && this.classToID.containsKey(providerClass)) {
            return (String)this.classToID.get(providerClass);
        }
        return null;
    }

    public boolean isCompatibleDeserializer(Type deserializer, String dataType) {
        if (deserializer == null || StringUtils.isNullOrEmpty(dataType)) {
            return false;
        }
        String ddt = null;
        try {
            ddt = DeserializerUtils.getReturnDataType((String)this.typeToId.get(deserializer));
            return ddt.equals(dataType);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

