/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.provider.statement;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.core.util.logic.operators.RelationalOperator;
import java.util.Map;

public abstract class Comparator<DATA_TYPE> {
    private static Map<String, Comparator> ALL = Maps.newConcurrentMap();
    protected final String id;
    public static Comparator<Boolean> BOOLEAN = new Comparator<Boolean>("boolean"){

        @Override
        public boolean compare(Boolean left, RelationalOperator testType, Boolean right) {
            switch (testType) {
                case NOT_EQUAL: {
                    return left != right;
                }
                case EQUAL: {
                    return left == right;
                }
            }
            return false;
        }
    };
    public static Comparator<Byte> BYTE = new Comparator<Byte>("byte"){

        @Override
        public boolean compare(Byte left, RelationalOperator testType, Byte right) {
            switch (testType) {
                case EQUAL: {
                    return left == right;
                }
                case NOT_EQUAL: {
                    return left != right;
                }
                case GREATER_THAN: {
                    return left > right;
                }
                case LESS_THAN: {
                    return left < right;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return left >= right;
                }
                case LESS_THAN_OR_EQUAL: {
                    return left <= right;
                }
            }
            return false;
        }
    };
    public static Comparator<Short> SHORT = new Comparator<Short>("short"){

        @Override
        public boolean compare(Short left, RelationalOperator testType, Short right) {
            switch (testType) {
                case EQUAL: {
                    return left == right;
                }
                case NOT_EQUAL: {
                    return left != right;
                }
                case GREATER_THAN: {
                    return left > right;
                }
                case LESS_THAN: {
                    return left < right;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return left >= right;
                }
                case LESS_THAN_OR_EQUAL: {
                    return left <= right;
                }
            }
            return false;
        }
    };
    public static Comparator<Integer> INT = new Comparator<Integer>("integer"){

        @Override
        public boolean compare(Integer left, RelationalOperator testType, Integer right) {
            switch (testType) {
                case EQUAL: {
                    return left == right;
                }
                case NOT_EQUAL: {
                    return left != right;
                }
                case GREATER_THAN: {
                    return left > right;
                }
                case LESS_THAN: {
                    return left < right;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return left >= right;
                }
                case LESS_THAN_OR_EQUAL: {
                    return left <= right;
                }
            }
            return false;
        }
    };
    public static Comparator<Long> LONG = new Comparator<Long>("long"){

        @Override
        public boolean compare(Long left, RelationalOperator testType, Long right) {
            switch (testType) {
                case EQUAL: {
                    return left == right;
                }
                case NOT_EQUAL: {
                    return left != right;
                }
                case GREATER_THAN: {
                    return left > right;
                }
                case LESS_THAN: {
                    return left < right;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return left >= right;
                }
                case LESS_THAN_OR_EQUAL: {
                    return left <= right;
                }
            }
            return false;
        }
    };
    public static Comparator<Float> FLOAT = new Comparator<Float>("float"){

        @Override
        public boolean compare(Float left, RelationalOperator testType, Float right) {
            switch (testType) {
                case EQUAL: {
                    return left == right;
                }
                case NOT_EQUAL: {
                    return left != right;
                }
                case GREATER_THAN: {
                    return left.floatValue() > right.floatValue();
                }
                case LESS_THAN: {
                    return left.floatValue() < right.floatValue();
                }
                case GREATER_THAN_OR_EQUAL: {
                    return left.floatValue() >= right.floatValue();
                }
                case LESS_THAN_OR_EQUAL: {
                    return left.floatValue() <= right.floatValue();
                }
            }
            return false;
        }
    };
    public static Comparator<Double> DOUBLE = new Comparator<Double>("double"){

        @Override
        public boolean compare(Double left, RelationalOperator testType, Double right) {
            switch (testType) {
                case EQUAL: {
                    return left == right;
                }
                case NOT_EQUAL: {
                    return left != right;
                }
                case GREATER_THAN: {
                    return left > right;
                }
                case LESS_THAN: {
                    return left < right;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return left >= right;
                }
                case LESS_THAN_OR_EQUAL: {
                    return left <= right;
                }
            }
            return false;
        }
    };
    public static Comparator<Character> CHAR = new Comparator<Character>("char"){

        @Override
        public boolean compare(Character left, RelationalOperator testType, Character right) {
            switch (testType) {
                case EQUAL: {
                    return left.equals(right);
                }
                case NOT_EQUAL: {
                    return !left.equals(right);
                }
            }
            return false;
        }
    };
    public static Comparator<String> STRING = new Comparator<String>("string"){

        @Override
        public boolean compare(String left, RelationalOperator testType, String right) {
            switch (testType) {
                case EQUAL: {
                    return left.equals(right);
                }
                case NOT_EQUAL: {
                    return !left.equals(right);
                }
            }
            return false;
        }
    };

    public static Comparator getFromID(String id) {
        if (ALL.containsKey(id)) {
            return ALL.get(id);
        }
        return null;
    }

    public static boolean has(String id) {
        return !StringUtils.isNullOrEmpty(id) && ALL.containsKey(id);
    }

    private Comparator(String id) {
        this.id = id;
        ALL.put(id, this);
    }

    public abstract boolean compare(DATA_TYPE var1, RelationalOperator var2, DATA_TYPE var3);

    public String getID() {
        return this.id;
    }
}

