/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.z_test_environment;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.valkyrieofnight.vlib.core.io.datapack.IDataRegistryReloader;
import com.valkyrieofnight.vlib.core.io.datapack.JsonDataLoader;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import java.util.List;
import java.util.Map;

public class TestDataLoader
extends JsonDataLoader<TestJson, TestRegistry> {
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public TestDataLoader() {
        super("valkyrielib", "tests", TestJson.class, new TestRegistry(), gson);
    }

    @Override
    protected void handleException(VLID id, Exception e) {
        throw new RuntimeException("TestJson Broken and Chocking");
    }

    public static class TestRegistry
    implements IDataRegistryReloader<TestJson> {
        private List<TestJson> tests = Lists.newArrayList();

        @Override
        public void reloadData(Map<VLID, TestJson> loaded) {
            this.tests.clear();
            loaded.values().forEach(testJson -> this.tests.add((TestJson)testJson));
        }

        @Override
        public TestJson merge(TestJson left, TestJson right) {
            return left;
        }
    }

    public static class TestJson {
        String name;
        String value;

        public String toString() {
            return "{" + this.name + ":" + this.value + "}";
        }
    }
}

