/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.debug;

import com.google.common.collect.Queues;
import com.valkyrieofnight.vlib.core.util.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class SimpleDebugger {
    private static DebuggerContainerThread thread;
    private static Queue<SimpleDebugger> debuggers;
    protected boolean enabled = true;
    protected boolean sysOut = true;
    protected File file;
    protected Queue<String> writeQueue;
    protected OutputStream outputStream;

    protected static synchronized void registerDebugger(SimpleDebugger debugger) {
        if (debugger == null) {
            return;
        }
        debuggers.add(debugger);
    }

    private static synchronized DebuggerContainerThread getThread() {
        System.out.println("Get Thread");
        if (thread == null) {
            thread = new DebuggerContainerThread();
        }
        return thread;
    }

    private static void killThread() {
        thread.stop();
    }

    public static void serverStopped() {
        SimpleDebugger.killThread();
    }

    public SimpleDebugger(File file) {
        this(file, true);
    }

    public SimpleDebugger(File file, boolean newFile) {
        System.out.println("Create Debugger");
        this.file = file;
        FileUtils.makeDirectories(file);
        System.out.println("1");
        if (newFile && file.exists()) {
            System.out.println("1.1");
            file.delete();
        }
        System.out.println("2");
        this.writeQueue = new ConcurrentLinkedQueue<String>();
        System.out.println("3");
        try {
            this.outputStream = new FileOutputStream(this.file, true);
            System.out.println("3.1");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Register with Thread");
        SimpleDebugger.registerDebugger(this);
        System.out.println("Setup Debugger Complete");
    }

    public SimpleDebugger(String file) {
        this(new File(file));
    }

    public synchronized void log(String data) {
        if (!this.enabled) {
            return;
        }
        if (this.sysOut) {
            System.out.println(data);
        }
        String str = LocalDateTime.now().toString() + " " + data;
        this.writeQueue.add(str);
    }

    protected synchronized void write() {
        if (!this.enabled) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            String qu = this.writeQueue.poll();
            if (qu == null) continue;
            try {
                this.outputStream.write(qu.getBytes(), 0, qu.length());
                this.outputStream.write(10);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void close() {
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setEnabled(boolean opt) {
        this.enabled = opt;
    }

    static {
        debuggers = Queues.newConcurrentLinkedQueue();
    }

    private static class DebuggerContainerThread
    implements Runnable {
        protected Thread worker;
        private final AtomicBoolean running = new AtomicBoolean(true);

        public DebuggerContainerThread() {
            this.worker = new Thread(this);
            this.worker.start();
        }

        @Override
        public synchronized void run() {
            while (this.running.get()) {
                for (SimpleDebugger sd : debuggers) {
                    sd.write();
                }
            }
        }

        public synchronized void stop() {
            this.running.set(false);
            for (SimpleDebugger sd : debuggers) {
                sd.close();
            }
        }
    }
}

