/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.tileentity.base;

import com.valkyrieofnight.vlib.core.util.lambda.Action1a;
import com.valkyrieofnight.vlib.core.util.lambda.Action2a;
import com.valkyrieofnight.vlib.core.util.lambda.Function1a;

public class TickProgress {
    protected int ticks = 0;
    protected int ticksTotal = 0;
    protected boolean repeat = false;
    protected boolean running = true;
    protected Function1a<TickProgress, Integer> functionTickRate;
    protected Action2a<TickProgress, Integer> actionTick;
    protected Action1a<TickProgress> actionStart;
    protected Action1a<TickProgress> actionPause;
    protected Action1a<TickProgress> actionResume;
    protected Action1a<TickProgress> actionStop;
    protected Action1a<TickProgress> actionReset;
    protected Action1a<TickProgress> actionFinish;

    public TickProgress(boolean repeat) {
        this(repeat, 0);
    }

    public TickProgress(boolean repeat, int ticksTotal) {
        this.repeat = repeat;
        this.ticksTotal = ticksTotal;
        this.functionTickRate = tick -> 1;
        this.actionTick = (tp, tickRate) -> {};
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public TickProgress setTickRateFunction(Function1a<TickProgress, Integer> tickRateFunct) {
        if (tickRateFunct != null) {
            this.functionTickRate = tickRateFunct;
        }
        return this;
    }

    public TickProgress setTickAction(Action2a<TickProgress, Integer> tickAction) {
        if (tickAction != null) {
            this.actionTick = tickAction;
        }
        return this;
    }

    public TickProgress setStartAction(Action1a<TickProgress> startAction) {
        this.actionStart = startAction;
        return this;
    }

    public TickProgress setPauseAction(Action1a<TickProgress> pauseAction) {
        this.actionPause = pauseAction;
        return this;
    }

    public TickProgress setResumeAction(Action1a<TickProgress> resumeAction) {
        this.actionResume = resumeAction;
        return this;
    }

    public TickProgress setStopAction(Action1a<TickProgress> stopAction) {
        this.actionStop = stopAction;
        return this;
    }

    public TickProgress setResetAction(Action1a<TickProgress> resetAction) {
        this.actionReset = resetAction;
        return this;
    }

    public TickProgress setFinishAction(Action1a<TickProgress> finishAction) {
        this.actionFinish = finishAction;
        return this;
    }

    public void tick() {
        if (this.running) {
            if (this.ticks < this.ticksTotal) {
                int ticks = this.functionTickRate.execute(this);
                this.actionTick.execute(this, ticks);
            } else if (this.running && this.actionFinish != null) {
                this.actionFinish.execute(this);
            }
        }
    }

    public void pause() {
        if (this.running && this.actionPause != null) {
            this.actionPause.execute(this);
        }
        this.running = false;
    }

    public void start() {
        if (!this.running) {
            if (this.ticks == 0) {
                if (this.actionStart != null) {
                    this.actionStart.execute(this);
                }
            } else if (this.actionResume != null) {
                this.actionResume.execute(this);
            }
        }
        this.running = true;
    }

    public void stop() {
        if (this.running && this.ticks != 0 && this.actionStop != null) {
            this.actionStop.execute(this);
        }
        this.running = false;
        this.ticks = 0;
    }

    public void reset(int newTickTotal) {
        if (this.actionReset != null) {
            this.actionReset.execute(this);
        }
        this.ticks = 0;
        this.ticksTotal = 0;
        this.running = false;
    }

    public boolean hasStarted() {
        return this.running;
    }

    public int getRemainingTicks() {
        return this.ticksTotal - this.ticks;
    }
}

