/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.util;

import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;

public class GuiSizableBox {
    private final VLID texture;
    private GuiTexture[][] textures;
    private int unitXSize;
    private int unitYSize;
    private boolean middleRepeatable;

    public GuiSizableBox(VLID tex, int unitXSize, int unitYSize) {
        this.texture = tex;
        this.textures = new GuiTexture[3][3];
        this.unitXSize = unitXSize;
        this.unitYSize = unitYSize;
    }

    public GuiSizableBox(VLID tex, int unitXSize, int unitYSize, int texWidth, int texHeight) {
        this.texture = tex;
        this.textures = new GuiTexture[3][3];
        this.unitXSize = unitXSize;
        this.unitYSize = unitYSize;
    }

    public void setGuiTexture(BoxLocation loc, GuiTexture tex) {
        this.textures[loc.y][loc.x] = tex;
    }

    public GuiTexture getGuiTexture(BoxLocation loc) {
        return this.textures[loc.y][loc.x];
    }

    public VLID getResourceLocation() {
        return this.texture;
    }

    public int getUnitX() {
        return this.unitXSize;
    }

    public int getUnitY() {
        return this.unitYSize;
    }

    public boolean getMiddleRepeatable() {
        return this.middleRepeatable;
    }

    public static enum BoxLocation {
        TOP_LEFT(0, 0),
        TOP_MID(0, 1),
        TOP_RIGHT(0, 2),
        MID_LEFT(1, 0),
        MID(1, 1),
        MID_RIGHT(1, 2),
        BOT_LEFT(2, 0),
        BOT_MID(2, 1),
        BOT_RIGHT(2, 2);

        public int x;
        public int y;

        private BoxLocation(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

