/*
 * Decompiled with CFR 0.152.
 */
package roxom.vanilla_degus.common;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import roxom.vanilla_degus.common.DeguEatPlantGoal;
import roxom.vanilla_degus.common.FollowSpecificMobGoal;
import roxom.vanilla_degus.common.ModEntities;
import roxom.vanilla_degus.common.TameableFollowParentGoal;
import roxom.vanilla_degus.common.UnsmoothRandomWalkingGoal;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DeguEntity
extends TameableEntity {
    private static final Ingredient BREEDING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221674_ay, Items.field_221916_fp, Items.field_221599_aA});
    private static final Ingredient OTHER_FAVORITE_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151014_N, Items.field_151015_O, Items.field_151080_bb, Items.field_151172_bF});
    private static final DataParameter<Integer> DATA_TYPE_ID = EntityDataManager.func_187226_a(DeguEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COLLAR_COLOR = EntityDataManager.func_187226_a(DeguEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final SoundEvent DEGU_SOUND_AMBIENT = new SoundEvent(new ResourceLocation("vanilla_degus", "degu_ambient"));
    private static final SoundEvent DEGU_SOUND_HURT = new SoundEvent(new ResourceLocation("vanilla_degus", "degu_angry"));
    private static final SoundEvent DEGU_SOUND_DEATH = new SoundEvent(new ResourceLocation("vanilla_degus", "degu_death"));

    protected DeguEntity(EntityType<? extends DeguEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_TYPE_ID, (Object)0);
        this.field_70180_af.func_187214_a(COLLAR_COLOR, (Object)DyeColor.RED.func_196059_a());
    }

    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("DeguType", this.getDeguType());
        compoundNBT.func_74774_a("CollarColor", (byte)this.getCollarColor().func_196059_a());
    }

    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.setDeguType(compoundNBT.func_74762_e("DeguType"));
        if (compoundNBT.func_150297_b("CollarColor", 99)) {
            this.setCollarColor(DyeColor.func_196056_a((int)compoundNBT.func_74762_e("CollarColor")));
        }
    }

    public int getDeguType() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_TYPE_ID);
    }

    private void setDeguType(int dataType) {
        this.field_70180_af.func_187227_b(DATA_TYPE_ID, (Object)dataType);
    }

    public DyeColor getCollarColor() {
        return DyeColor.func_196056_a((int)((Integer)this.field_70180_af.func_187225_a(COLLAR_COLOR)));
    }

    private void setCollarColor(DyeColor color) {
        this.field_70180_af.func_187227_b(COLLAR_COLOR, (Object)color.func_196059_a());
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 2.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 2.0, OTHER_FAVORITE_ITEMS, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new TemptGoal((CreatureEntity)this, 1.25, BREEDING_ITEMS, false));
        this.field_70714_bg.func_75776_a(6, (Goal)new AvoidEntityGoal((CreatureEntity)this, CatEntity.class, 8.0f, 1.6, 1.4, other -> !((CatEntity)other).func_70909_n()));
        this.field_70714_bg.func_75776_a(6, (Goal)new AvoidEntityGoal((CreatureEntity)this, WolfEntity.class, 8.0f, 1.6, 1.4, other -> !((WolfEntity)other).func_70909_n()));
        this.field_70714_bg.func_75776_a(6, (Goal)new AvoidEntityGoal((CreatureEntity)this, FoxEntity.class, 8.0f, 1.6, 1.4));
        this.field_70714_bg.func_75776_a(6, (Goal)new AvoidEntityGoal((CreatureEntity)this, OcelotEntity.class, 8.0f, 1.6, 1.4));
        this.field_70714_bg.func_75776_a(6, (Goal)new AvoidEntityGoal((CreatureEntity)this, PolarBearEntity.class, 8.0f, 1.6, 1.4));
        this.field_70714_bg.func_75776_a(7, (Goal)new DeguEatPlantGoal((CreatureEntity)this, 1.25, 8, 1));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.25, 10.0f, 3.0f, false));
        this.field_70714_bg.func_75776_a(9, (Goal)new TameableFollowParentGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(10, (Goal)new UnsmoothRandomWalkingGoal((CreatureEntity)this, 1.5, 60));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(13, (Goal)new FollowSpecificMobGoal((MobEntity)this, CowEntity.class, 1.25, 1.0f, 7.0f, 60));
        this.field_70714_bg.func_75776_a(14, (Goal)new FollowSpecificMobGoal((MobEntity)this, RabbitEntity.class, 1.25, 1.0f, 7.0f, 60));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.5f;
    }

    public int func_213396_dB() {
        return 1000;
    }

    public int func_184649_cE() {
        return 750;
    }

    public boolean func_70877_b(ItemStack stack) {
        return BREEDING_ITEMS.test(stack);
    }

    private boolean isHealableItem(ItemStack stack) {
        return BREEDING_ITEMS.test(stack) || OTHER_FAVORITE_ITEMS.test(stack);
    }

    protected SoundEvent func_184639_G() {
        return DEGU_SOUND_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return DEGU_SOUND_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return DEGU_SOUND_DEATH;
    }

    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity partner) {
        DeguEntity childDeguEntity = (DeguEntity)ModEntities.DEGU.func_200721_a((World)world);
        assert (childDeguEntity != null);
        if (partner instanceof DeguEntity) {
            if (this.field_70146_Z.nextBoolean()) {
                childDeguEntity.setDeguType(this.getDeguType());
            } else {
                childDeguEntity.setDeguType(((DeguEntity)partner).getDeguType());
            }
            if (this.func_70909_n()) {
                childDeguEntity.func_184754_b(this.func_184753_b());
                childDeguEntity.func_70903_f(true);
                if (this.field_70146_Z.nextBoolean()) {
                    childDeguEntity.setCollarColor(this.getCollarColor());
                } else {
                    childDeguEntity.setCollarColor(((DeguEntity)partner).getCollarColor());
                }
            }
        }
        return childDeguEntity;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        Item item = itemStack.func_77973_b();
        boolean tamable = this.func_70877_b(itemStack) && !this.func_70909_n();
        boolean healable = this.isHealableItem(itemStack) && this.func_110143_aJ() < this.func_110138_aP();
        boolean dyeable = this.func_152114_e((LivingEntity)player) && item instanceof DyeItem;
        boolean sittable = this.func_152114_e((LivingEntity)player);
        if (tamable) {
            this.func_175505_a(player, itemStack);
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                    this.func_193101_c(player);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (healable) {
            this.func_175505_a(player, itemStack);
            this.func_70691_i(this.func_70877_b(itemStack) ? 5.0f : 2.0f);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (dyeable) {
            DyeColor dyecolor;
            if (!this.field_70170_p.field_72995_K && (dyecolor = ((DyeItem)item).func_195962_g()) != this.getCollarColor()) {
                this.func_175505_a(player, itemStack);
                this.setCollarColor(dyecolor);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (sittable) {
            ActionResultType defaultBreedingResult;
            if (!(this.field_70170_p.field_72995_K || (defaultBreedingResult = super.func_230254_b_(player, hand)).func_226246_a_() && !this.func_70631_g_())) {
                this.func_233687_w_(!this.func_233685_eM_());
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_70615_aA() {
        this.func_70691_i(5.0f);
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld serverWorld, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData entityData, @Nullable CompoundNBT compoundNBT) {
        if (reason == SpawnReason.COMMAND || reason == SpawnReason.SPAWN_EGG) {
            this.setDeguType(this.getRandomDeguType());
        } else {
            this.setDeguType(this.getRandomDeguTypeByBiome((IWorld)serverWorld));
        }
        return super.func_213386_a(serverWorld, difficulty, reason, entityData, compoundNBT);
    }

    private int getRandomDeguType() {
        return this.field_70146_Z.nextInt(4);
    }

    private int getRandomDeguTypeByBiome(IWorld world) {
        Biome biome = world.func_226691_t_(this.func_233580_cy_());
        if (biome.func_201856_r() == Biome.Category.DESERT) {
            return 1;
        }
        int i = this.field_70146_Z.nextInt(100);
        int[] colorTypes = new int[]{2, 3};
        int index = this.field_70146_Z.nextInt(colorTypes.length);
        return i < 60 ? 0 : colorTypes[index];
    }
}

