/*
 * Decompiled with CFR 0.152.
 */
package roxom.vanilla_degus.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import roxom.vanilla_degus.common.DeguEntity;
import roxom.vanilla_degus.common.ModEntities;

@Mod(value="vanilla_degus")
public class DeguMod {
    public static DeguMod instance;
    public static final String MOD_ID = "vanilla_degus";
    public static final Logger LOGGER;

    public DeguMod() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::createEntityAttributes);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("setup method");
    }

    private void setupClient(FMLClientSetupEvent event) {
        ModEntities.clientInit();
        LOGGER.info("Setup Client");
    }

    private void createEntityAttributes(EntityAttributeCreationEvent event) {
        event.put(ModEntities.DEGU, DeguEntity.setCustomAttributes().func_233813_a_());
        LOGGER.info("Created entity attributes");
    }

    @SubscribeEvent
    public void onBiomeLoading(BiomeLoadingEvent event) {
        ArrayList<Biome.Category> deguSpawnBiomes = new ArrayList<Biome.Category>(Arrays.asList(Biome.Category.MESA, Biome.Category.SAVANNA, Biome.Category.DESERT));
        if (deguSpawnBiomes.contains(event.getCategory())) {
            List spawns = event.getSpawns().getSpawner(ModEntities.DEGU.func_220339_d());
            spawns.add(new MobSpawnInfo.Spawners(ModEntities.DEGU, 5, 2, 8));
        }
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

