/*
 * Decompiled with CFR 0.152.
 */
package easton.verticalrepeaters;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2457;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public abstract class VerticalRedstoneGate
extends class_2383 {
    public static final class_2753 POINTING = class_2753.method_11844((String)"pointing", (Predicate)class_2350.class_2353.field_11064);
    public static final class_2746 POWERED = class_2741.field_12484;

    protected VerticalRedstoneGate(class_4970.class_2251 settings) {
        super(settings);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_11177);
        class_2338 blockPos = pos.method_10093(direction.method_10153());
        class_2680 blockState = world.method_8320(blockPos);
        return blockState.method_26206((class_1922)world, blockPos, direction);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, Random random) {
        if (!this.isLocked((class_4538)world, pos, state)) {
            boolean bl = (Boolean)state.method_11654((class_2769)POWERED);
            boolean bl2 = this.hasPower((class_1937)world, pos, state);
            if (bl && !bl2) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)), 2);
            } else if (!bl) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                if (!bl2) {
                    world.method_14196().method_8675(pos, (Object)this, this.getUpdateDelayInternal(state), class_1953.field_9313);
                }
            }
        }
    }

    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return state.method_26195(world, pos, direction);
    }

    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        if (!((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            return 0;
        }
        return state.method_11654((class_2769)POINTING) == direction ? this.getOutputLevel(world, pos, state) : 0;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        if (state.method_26184((class_4538)world, pos)) {
            this.updatePowered(world, pos, state);
        } else {
            class_2586 blockEntity = this.method_26161() ? world.method_8321(pos) : null;
            VerticalRedstoneGate.method_9610((class_2680)state, (class_1936)world, (class_2338)pos, (class_2586)blockEntity);
            world.method_8650(pos, false);
            for (class_2350 direction : class_2350.values()) {
                world.method_8452(pos.method_10093(direction), (class_2248)this);
            }
        }
    }

    protected void updatePowered(class_1937 world, class_2338 pos, class_2680 state) {
        boolean bl2;
        boolean bl;
        if (!this.isLocked((class_4538)world, pos, state) && (bl = ((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) != (bl2 = this.hasPower(world, pos, state)) && !world.method_8397().method_8677(pos, (Object)this)) {
            class_1953 tickPriority = class_1953.field_9310;
            if (this.isTargetNotAligned((class_1922)world, pos, state)) {
                tickPriority = class_1953.field_9315;
            } else if (bl) {
                tickPriority = class_1953.field_9313;
            }
            world.method_8397().method_8675(pos, (Object)this, this.getUpdateDelayInternal(state), tickPriority);
        }
    }

    public boolean isLocked(class_4538 worldView, class_2338 pos, class_2680 state) {
        return false;
    }

    protected boolean hasPower(class_1937 world, class_2338 pos, class_2680 state) {
        return this.getPower(world, pos, state) > 0;
    }

    protected int getPower(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)POINTING);
        class_2338 blockPos = pos.method_10093(direction);
        int i = world.method_8499(blockPos, direction);
        if (i >= 15) {
            return i;
        }
        class_2680 blockState = world.method_8320(blockPos);
        return Math.max(i, blockState.method_27852(class_2246.field_10091) ? (Integer)blockState.method_11654((class_2769)class_2457.field_11432) : 0);
    }

    protected int getMaxInputLevelSides(class_4538 world, class_2338 pos, class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_11177);
        class_2350 direction2 = direction.method_10170();
        class_2350 direction3 = direction.method_10160();
        return Math.max(this.getInputLevel(world, pos.method_10093(direction2), direction2), this.getInputLevel(world, pos.method_10093(direction3), direction3));
    }

    protected int getInputLevel(class_4538 world, class_2338 pos, class_2350 dir) {
        class_2680 blockState = world.method_8320(pos);
        if (this.isValidInput(blockState)) {
            if (blockState.method_27852(class_2246.field_10002)) {
                return 15;
            }
            return blockState.method_27852(class_2246.field_10091) ? ((Integer)blockState.method_11654((class_2769)class_2457.field_11432)).intValue() : world.method_22344(pos, dir);
        }
        return 0;
    }

    public boolean method_9506(class_2680 state) {
        return false;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2338 blockPos = ctx.method_8037();
        class_2680 blockState = ctx.method_8045().method_8320(blockPos);
        class_2350 direction = ctx.method_8038();
        if (direction != class_2350.field_11033 && (direction == class_2350.field_11036 || ctx.method_17698().field_1351 - (double)blockPos.method_10264() <= 0.5)) {
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)ctx.method_8042().method_10153())).method_11657((class_2769)POINTING, (Comparable)class_2350.field_11033);
        }
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)ctx.method_8042().method_10153())).method_11657((class_2769)POINTING, (Comparable)class_2350.field_11036);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        if (this.hasPower(world, pos, state)) {
            world.method_8397().method_8676(pos, (Object)this, 1);
        }
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        this.updateTarget(world, pos, state);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!moved && !state.method_27852(newState.method_26204())) {
            super.method_9536(state, world, pos, newState, moved);
            this.updateTarget(world, pos, state);
        }
    }

    protected void updateTarget(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)POINTING);
        class_2338 blockPos = pos.method_10093(direction.method_10153());
        world.method_8492(blockPos, (class_2248)this, pos);
        world.method_8508(blockPos, (class_2248)this, direction);
    }

    protected boolean isValidInput(class_2680 state) {
        return state.method_26219() || state.method_26204() instanceof VerticalRedstoneGate;
    }

    protected int getOutputLevel(class_1922 world, class_2338 pos, class_2680 state) {
        return 15;
    }

    public static boolean isRedstoneGate(class_2680 state) {
        return state.method_26204() instanceof class_2312 || state.method_26204() instanceof VerticalRedstoneGate;
    }

    public boolean isTargetNotAligned(class_1922 world, class_2338 pos, class_2680 state) {
        class_2350 direction = ((class_2350)state.method_11654((class_2769)POINTING)).method_10153();
        class_2680 blockState = world.method_8320(pos.method_10093(direction));
        return VerticalRedstoneGate.isRedstoneGate(blockState) && blockState.method_11654((class_2769)POINTING) != direction;
    }

    protected abstract int getUpdateDelayInternal(class_2680 var1);
}

