/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import net.blay09.mods.waystones.block.SharestoneBlock;
import net.blay09.mods.waystones.block.entity.SharestoneBlockEntity;
import net.blay09.mods.waystones.client.ModRenderers;
import net.blay09.mods.waystones.client.render.SharestoneModel;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.item.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class SharestoneRenderer
implements BlockEntityRenderer<SharestoneBlockEntity> {
    private static final Material MATERIAL = new Material(Sheets.f_110739_, new ResourceLocation("waystones", "entity/sharestone_color"));
    private static ItemStack warpStoneItem;
    private final SharestoneModel model;

    public SharestoneRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new SharestoneModel(context.m_173582_(ModRenderers.sharestoneModel));
    }

    public void render(SharestoneBlockEntity tileEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Level world = tileEntity.m_58904_();
        BlockState state = tileEntity.m_58900_();
        if (world == null || state.m_61143_((Property)SharestoneBlock.HALF) != DoubleBlockHalf.LOWER) {
            return;
        }
        long gameTime = world.m_46467_();
        DyeColor color = ((SharestoneBlock)state.m_60734_()).getColor();
        if (color != null) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.0, 0.5);
            matrixStack.m_85845_(new Quaternion(-180.0f, 0.0f, 0.0f, true));
            matrixStack.m_85837_(0.0, -2.0, 0.0);
            float scale = 1.01f;
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            matrixStack.m_85841_(scale, scale, scale);
            VertexConsumer vertexBuilder = MATERIAL.m_119194_(buffer, RenderType::m_110452_);
            int light = WaystonesConfig.getActive().disableTextGlow() ? combinedLightIn : 0xF000F0;
            int overlay = WaystonesConfig.getActive().disableTextGlow() ? combinedOverlayIn : OverlayTexture.f_118083_;
            float[] colors = color.m_41068_();
            this.model.m_7695_(matrixStack, vertexBuilder, light, overlay, colors[0], colors[1], colors[2], 1.0f);
            matrixStack.m_85849_();
        }
        if (warpStoneItem == null) {
            warpStoneItem = new ItemStack((ItemLike)ModItems.warpStone);
            warpStoneItem.m_41663_(Enchantments.f_44986_, 1);
        }
        float angle = (float)gameTime / 2.0f % 360.0f;
        float offsetY = (float)Math.sin((float)gameTime / 8.0f) * 0.025f;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, (double)(1.0f + offsetY), 0.5);
        matrixStack.m_85845_(new Quaternion(0.0f, angle, 0.0f, true));
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        Minecraft.m_91087_().m_91291_().m_174269_(warpStoneItem, ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, buffer, 0);
        matrixStack.m_85849_();
    }
}

