/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.event.server.ServerReloadedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.api.world.BiomePredicate;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WorldGenStyle;
import net.blay09.mods.waystones.worldgen.WaystoneDecorator;
import net.blay09.mods.waystones.worldgen.WaystoneFeature;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DecoratorConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HeightmapConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.placement.ConfiguredDecorator;

public class ModWorldGen {
    private static final ResourceLocation villageWaystoneStructure = new ResourceLocation("waystones", "village/common/waystone");
    private static final ResourceLocation desertVillageWaystoneStructure = new ResourceLocation("waystones", "village/desert/waystone");
    private static final ResourceLocation emptyStructure = new ResourceLocation("empty");
    private static DeferredObject<WaystoneFeature> waystoneFeature;
    private static DeferredObject<WaystoneFeature> mossyWaystoneFeature;
    private static DeferredObject<WaystoneFeature> sandyWaystoneFeature;
    private static DeferredObject<ConfiguredFeature<?, ?>> configuredWaystoneFeature;
    private static DeferredObject<ConfiguredFeature<?, ?>> configuredMossyWaystoneFeature;
    private static DeferredObject<ConfiguredFeature<?, ?>> configuredSandyWaystoneFeature;
    private static DeferredObject<WaystoneDecorator> waystoneDecorator;

    public static void initialize(BalmWorldGen worldGen) {
        waystoneFeature = worldGen.registerFeature(() -> new WaystoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, ModBlocks.waystone.m_49966_()), ModWorldGen.id("waystone"));
        mossyWaystoneFeature = worldGen.registerFeature(() -> new WaystoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, ModBlocks.mossyWaystone.m_49966_()), ModWorldGen.id("mossy_waystone"));
        sandyWaystoneFeature = worldGen.registerFeature(() -> new WaystoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, ModBlocks.sandyWaystone.m_49966_()), ModWorldGen.id("sandy_waystone"));
        waystoneDecorator = worldGen.registerDecorator(() -> new WaystoneDecorator((Codec<HeightmapConfiguration>)HeightmapConfiguration.f_160929_), ModWorldGen.id("waystone"));
        Supplier<ConfiguredDecorator> configuredDecorator = () -> ((WaystoneDecorator)((Object)((Object)waystoneDecorator.get()))).m_70720_((DecoratorConfiguration)new HeightmapConfiguration(Heightmap.Types.OCEAN_FLOOR_WG));
        configuredWaystoneFeature = worldGen.registerConfiguredFeature(() -> worldGen.configuredFeature((Feature)waystoneFeature.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_, (ConfiguredDecorator)configuredDecorator.get()), ModWorldGen.id("waystone"));
        configuredMossyWaystoneFeature = worldGen.registerConfiguredFeature(() -> worldGen.configuredFeature((Feature)mossyWaystoneFeature.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_, (ConfiguredDecorator)configuredDecorator.get()), ModWorldGen.id("mossy_waystone"));
        configuredSandyWaystoneFeature = worldGen.registerConfiguredFeature(() -> worldGen.configuredFeature((Feature)sandyWaystoneFeature.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_, (ConfiguredDecorator)configuredDecorator.get()), ModWorldGen.id("sandy_waystone"));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesCategory(Biome.BiomeCategory.DESERT), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.SANDY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesCategory(Biome.BiomeCategory.JUNGLE), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesCategory(Biome.BiomeCategory.SWAMP), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesCategory(Biome.BiomeCategory.MUSHROOM), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesNeitherCategory(Biome.BiomeCategory.SWAMP, Biome.BiomeCategory.DESERT, Biome.BiomeCategory.JUNGLE, Biome.BiomeCategory.MUSHROOM), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.DEFAULT));
        Balm.getEvents().onEvent(ServerStartedEvent.class, event -> ModWorldGen.setupVillageWorldGen(event.getServer().m_129911_()));
        Balm.getEvents().onEvent(ServerReloadedEvent.class, event -> ModWorldGen.setupVillageWorldGen(event.getServer().m_129911_()));
    }

    private static BiomePredicate matchesCategory(Biome.BiomeCategory category) {
        return (resourceLocation, biomeCategory, precipitation, v, v1) -> category == biomeCategory;
    }

    private static BiomePredicate matchesNeitherCategory(Biome.BiomeCategory ... categories) {
        return (resourceLocation, biomeCategory, precipitation, v, v1) -> {
            for (Biome.BiomeCategory category : categories) {
                if (category != biomeCategory) continue;
                return false;
            }
            return true;
        };
    }

    private static ResourceLocation id(String name) {
        return new ResourceLocation("waystones", name);
    }

    private static ResourceLocation getWaystoneFeature(WorldGenStyle biomeWorldGenStyle) {
        WorldGenStyle worldGenStyle = WaystonesConfig.getActive().worldGenStyle();
        return switch (worldGenStyle) {
            case WorldGenStyle.MOSSY -> configuredMossyWaystoneFeature.getIdentifier();
            case WorldGenStyle.SANDY -> configuredSandyWaystoneFeature.getIdentifier();
            case WorldGenStyle.BIOME -> {
                switch (biomeWorldGenStyle) {
                    case SANDY: {
                        yield configuredSandyWaystoneFeature.getIdentifier();
                    }
                    case MOSSY: {
                        yield configuredMossyWaystoneFeature.getIdentifier();
                    }
                }
                yield configuredWaystoneFeature.getIdentifier();
            }
            default -> configuredWaystoneFeature.getIdentifier();
        };
    }

    public static void setupVillageWorldGen(RegistryAccess registryAccess) {
        if (WaystonesConfig.getActive().spawnInVillages() || WaystonesConfig.getActive().forceSpawnInVillages()) {
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/plains/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/snowy/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/savanna/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/desert/houses", desertVillageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/taiga/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/badlands/houses", desertVillageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/birch/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/dark_forest/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/jungle/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/mountains/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/oak/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/swamp/houses", villageWaystoneStructure, 1);
        }
    }

    private static void addWaystoneStructureToVillageConfig(RegistryAccess registryAccess, String villagePiece, ResourceLocation waystoneStructure, int weight) {
        LegacySinglePoolElement piece = (LegacySinglePoolElement)StructurePoolElement.m_69192_((String)waystoneStructure.toString()).apply(StructureTemplatePool.Projection.RIGID);
        StructureTemplatePool pool = registryAccess.m_175515_(Registry.f_122884_).m_6612_(new ResourceLocation(villagePiece)).orElse(null);
        if (pool != null) {
            ArrayList<LegacySinglePoolElement> listOfPieces = new ArrayList<LegacySinglePoolElement>(pool.f_69250_);
            for (int i = 0; i < weight; ++i) {
                listOfPieces.add(piece);
            }
            pool.f_69250_ = listOfPieces;
            ArrayList<Pair> listOfWeightedPieces = new ArrayList<Pair>(pool.f_69249_);
            listOfWeightedPieces.add(new Pair((Object)piece, (Object)weight));
            pool.f_69249_ = listOfWeightedPieces;
        }
    }
}

