/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.HeightmapConfiguration;
import net.minecraft.world.level.levelgen.placement.DecorationContext;
import net.minecraft.world.level.levelgen.placement.HeightmapDecorator;

public class WaystoneDecorator
extends HeightmapDecorator {
    public WaystoneDecorator(Codec<HeightmapConfiguration> codec) {
        super(codec);
    }

    public Stream<BlockPos> m_7887_(DecorationContext context, Random random, HeightmapConfiguration config, BlockPos pos) {
        if (this.isWaystoneChunk(context, pos)) {
            if (context.m_162168_().m_6018_().m_46472_() == Level.f_46429_) {
                BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
                int topMostY = context.m_70590_(config.f_160930_, pos.m_123341_(), pos.m_123343_());
                mutablePos.m_142448_(topMostY);
                BlockState stateAbove = context.m_162168_().m_8055_((BlockPos)mutablePos);
                for (int i = mutablePos.m_123342_(); i >= 1; --i) {
                    mutablePos.m_142448_(mutablePos.m_123342_() - 1);
                    BlockState state = context.m_162168_().m_8055_((BlockPos)mutablePos);
                    if (!state.m_60795_() && state.m_60819_().m_76178_() && stateAbove.m_60795_() && !state.m_60713_(Blocks.f_50752_)) {
                        mutablePos.m_142448_(mutablePos.m_123342_() + 1);
                        break;
                    }
                    stateAbove = state;
                }
                return mutablePos.m_123342_() > 0 ? Stream.of(mutablePos) : Stream.empty();
            }
            return super.m_7887_(context, random, config, pos);
        }
        return Stream.empty();
    }

    private boolean isWaystoneChunk(DecorationContext world, BlockPos pos) {
        int chunkDistance = WaystonesConfig.getActive().worldGenFrequency();
        if (chunkDistance == 0) {
            return false;
        }
        ResourceLocation dimension = world.m_162168_().m_6018_().m_46472_().m_135782_();
        List<String> dimensionAllowList = WaystonesConfig.getActive().worldGenDimensionAllowList();
        List<String> dimensionDenyList = WaystonesConfig.getActive().worldGenDimensionDenyList();
        if (!dimensionAllowList.isEmpty() && !dimensionAllowList.contains(dimension.toString())) {
            return false;
        }
        if (!dimensionDenyList.isEmpty() && dimensionDenyList.contains(dimension.toString())) {
            return false;
        }
        int maxDeviation = (int)Math.ceil((float)chunkDistance / 2.0f);
        int chunkX = pos.m_123341_() / 16;
        int chunkZ = pos.m_123343_() / 16;
        int devGridX = pos.m_123341_() / 16 * maxDeviation;
        int devGridZ = pos.m_123343_() / 16 * maxDeviation;
        long seed = world.m_162168_().m_7328_();
        Random random = new Random(seed * (long)devGridX * (long)devGridZ);
        int chunkOffsetX = random.nextInt(maxDeviation);
        int chunkOffsetZ = random.nextInt(maxDeviation);
        return (chunkX + chunkOffsetX) % chunkDistance == 0 && (chunkZ + chunkOffsetZ) % chunkDistance == 0;
    }
}

