/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.balm.api.block.entity.BalmBlockEntity;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3908;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;

public abstract class WaystoneBlockEntityBase
extends BalmBlockEntity {
    private IWaystone waystone = InvalidWaystone.INSTANCE;
    private UUID waystoneUid;
    private boolean shouldNotInitialize;
    private boolean silkTouched;

    public WaystoneBlockEntityBase(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public class_2487 method_11007(class_2487 compound) {
        super.method_11007(compound);
        if (this.waystone.isValid()) {
            compound.method_10566("UUID", (class_2520)class_2512.method_25929((UUID)this.waystone.getWaystoneUid()));
        } else if (this.waystoneUid != null) {
            compound.method_10566("UUID", (class_2520)class_2512.method_25929((UUID)this.waystoneUid));
        }
        return compound;
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        if (compound.method_10573("UUID", 11)) {
            this.waystoneUid = class_2512.method_25930((class_2520)Objects.requireNonNull(compound.method_10580("UUID")));
        }
    }

    public void balmOnLoad() {
        IWaystone backingWaystone = this.waystone;
        if (this.waystone instanceof WaystoneProxy) {
            backingWaystone = ((WaystoneProxy)this.waystone).getBackingWaystone();
        }
        if (backingWaystone instanceof Waystone && this.field_11863 != null) {
            ((Waystone)backingWaystone).setDimension((class_5321<class_1937>)this.field_11863.method_27983());
            ((Waystone)backingWaystone).setPos(this.field_11867);
        }
        this.balmSync();
    }

    public void balmFromClientTag(class_2487 tag) {
        IWaystone syncedWaystone = Waystone.read(tag);
        WaystoneManager.get(this.field_11863.method_8503()).updateWaystone(syncedWaystone);
        this.waystone = new WaystoneProxy(this.field_11863.method_8503(), syncedWaystone.getWaystoneUid());
    }

    public class_2487 balmToClientTag(class_2487 tag) {
        Waystone.write(this.getWaystone(), tag);
        return tag;
    }

    public class_238 balmGetRenderBoundingBox() {
        return new class_238((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (double)(this.field_11867.method_10263() + 1), (double)(this.field_11867.method_10264() + 2), (double)(this.field_11867.method_10260() + 1));
    }

    public IWaystone getWaystone() {
        if (!(this.waystone.isValid() || this.field_11863 == null || this.field_11863.field_9236 || this.shouldNotInitialize)) {
            class_2680 state;
            if (this.waystoneUid != null) {
                this.waystone = new WaystoneProxy(this.field_11863.method_8503(), this.waystoneUid);
            }
            if (!this.waystone.isValid() && (state = this.method_11010()).method_26204() instanceof WaystoneBlock) {
                class_2586 blockEntity;
                class_2756 half = (class_2756)state.method_11654((class_2769)WaystoneBlock.HALF);
                if (half == class_2756.field_12607) {
                    this.initializeWaystone((class_5425)Objects.requireNonNull(this.field_11863), null, true);
                } else if (half == class_2756.field_12609 && (blockEntity = this.field_11863.method_8321(this.field_11867.method_10074())) instanceof WaystoneBlockEntityBase) {
                    this.initializeFromBase((WaystoneBlockEntityBase)blockEntity);
                }
            }
            if (this.waystone.isValid()) {
                this.waystoneUid = this.waystone.getWaystoneUid();
                this.balmSync();
            }
        }
        return this.waystone;
    }

    protected abstract class_2960 getWaystoneType();

    public void initializeWaystone(class_5425 world, @Nullable class_1309 player, boolean wasGenerated) {
        Waystone waystone = new Waystone(this.getWaystoneType(), UUID.randomUUID(), (class_5321<class_1937>)world.method_8410().method_27983(), this.field_11867, wasGenerated, player != null ? player.method_5667() : null);
        WaystoneManager.get(world.method_8503()).addWaystone(waystone);
        this.waystone = waystone;
        this.method_5431();
        this.balmSync();
    }

    public void initializeFromExisting(class_5425 world, Waystone existingWaystone, class_1799 itemStack) {
        this.waystone = existingWaystone;
        existingWaystone.setDimension((class_5321<class_1937>)world.method_8410().method_27983());
        existingWaystone.setPos(this.field_11867);
        this.method_5431();
        this.balmSync();
    }

    public void initializeFromBase(WaystoneBlockEntityBase tileEntity) {
        this.waystone = tileEntity.getWaystone();
        this.method_5431();
        this.balmSync();
    }

    public void uninitializeWaystone() {
        if (this.waystone.isValid()) {
            WaystoneManager.get(this.field_11863.method_8503()).removeWaystone(this.waystone);
            PlayerWaystoneManager.removeKnownWaystone(this.field_11863.method_8503(), this.waystone);
        }
        this.waystone = InvalidWaystone.INSTANCE;
        this.shouldNotInitialize = true;
        class_2756 half = (class_2756)this.method_11010().method_11654((class_2769)WaystoneBlock.HALF);
        class_2338 otherPos = half == class_2756.field_12609 ? this.field_11867.method_10074() : this.field_11867.method_10084();
        class_2586 blockEntity = Objects.requireNonNull(this.field_11863).method_8321(otherPos);
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneTile = (WaystoneBlockEntityBase)blockEntity;
            waystoneTile.waystone = InvalidWaystone.INSTANCE;
            waystoneTile.shouldNotInitialize = true;
        }
        this.method_5431();
        this.balmSync();
    }

    public void setSilkTouched(boolean silkTouched) {
        this.silkTouched = silkTouched;
    }

    public boolean isSilkTouched() {
        return this.silkTouched;
    }

    public abstract class_3908 getMenuProvider();

    @Nullable
    public abstract class_3908 getSettingsMenuProvider();
}

