/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmEnvironment;
import net.blay09.mods.waystones.api.IMutableWaystone;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneActivatedEvent;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.config.DimensionalWarp;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.IPlayerWaystoneData;
import net.blay09.mods.waystones.core.InMemoryPlayerWaystoneData;
import net.blay09.mods.waystones.core.PersistentPlayerWaystoneData;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneTeleportContext;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.network.message.TeleportEffectMessage;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PlayerWaystoneManager {
    private static final Logger logger = LogManager.getLogger();
    private static final IPlayerWaystoneData persistentPlayerWaystoneData = new PersistentPlayerWaystoneData();
    private static final IPlayerWaystoneData inMemoryPlayerWaystoneData = new InMemoryPlayerWaystoneData();

    public static boolean mayBreakWaystone(class_1657 player, class_1922 world, class_2338 pos) {
        if (WaystonesConfig.getActive().restrictToCreative() && !player.method_31549().field_7477) {
            return false;
        }
        return WaystoneManager.get(player.method_5682()).getWaystoneAt(world, pos).map(waystone -> {
            if (!player.method_31549().field_7477) {
                if (waystone.wasGenerated() && WaystonesConfig.getActive().generatedWaystonesUnbreakable()) {
                    return false;
                }
                boolean isGlobal = waystone.isGlobal();
                boolean mayBreakGlobalWaystones = !WaystonesConfig.getActive().globalWaystoneRequiresCreative();
                return !isGlobal || mayBreakGlobalWaystones;
            }
            return true;
        }).orElse(true);
    }

    public static boolean mayPlaceWaystone(@Nullable class_1657 player) {
        return !WaystonesConfig.getActive().restrictToCreative() || player != null && player.method_31549().field_7477;
    }

    public static WaystoneEditPermissions mayEditWaystone(class_1657 player, class_1937 world, IWaystone waystone) {
        if (WaystonesConfig.getActive().restrictToCreative() && !player.method_31549().field_7477) {
            return WaystoneEditPermissions.NOT_CREATIVE;
        }
        if (WaystonesConfig.getActive().restrictRenameToOwner() && !waystone.isOwner(player)) {
            return WaystoneEditPermissions.NOT_THE_OWNER;
        }
        if (waystone.isGlobal() && !player.method_31549().field_7477 && WaystonesConfig.getActive().globalWaystoneRequiresCreative()) {
            return WaystoneEditPermissions.GET_CREATIVE;
        }
        return WaystoneEditPermissions.ALLOW;
    }

    public static boolean isWaystoneActivated(class_1657 player, IWaystone waystone) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.field_6002).isWaystoneActivated(player, waystone);
    }

    public static void activateWaystone(class_1657 player, IWaystone waystone) {
        if (!waystone.hasName() && waystone instanceof IMutableWaystone && waystone.wasGenerated()) {
            NameGenerationMode nameGenerationMode = WaystonesConfig.getActive().nameGenerationMode();
            String name = NameGenerator.get(player.method_5682()).getName(waystone, player.field_6002.field_9229, nameGenerationMode);
            ((IMutableWaystone)((Object)waystone)).setName(name);
        }
        if (!waystone.hasOwner() && waystone instanceof IMutableWaystone) {
            ((IMutableWaystone)((Object)waystone)).setOwnerUid(player.method_5667());
        }
        if (!PlayerWaystoneManager.isWaystoneActivated(player, waystone) && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            PlayerWaystoneManager.getPlayerWaystoneData(player.field_6002).activateWaystone(player, waystone);
            Balm.getEvents().fireEvent((Object)new WaystoneActivatedEvent(player, waystone));
        }
    }

    public static int getExperienceLevelCost(class_1297 player, IWaystone waystone, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        WaystoneTeleportContext context = new WaystoneTeleportContext();
        context.setLeashedEntities(PlayerWaystoneManager.findLeashedAnimals(player));
        context.setFromWaystone(fromWaystone);
        return PlayerWaystoneManager.getExperienceLevelCost(player, waystone, warpMode, context);
    }

    public static int getExperienceLevelCost(class_1297 entity, IWaystone waystone, WarpMode warpMode, WaystoneTeleportContext context) {
        double xpLevelCost;
        if (!(entity instanceof class_1657)) {
            return 0;
        }
        class_1657 player = (class_1657)entity;
        if (context.getFromWaystone() != null && waystone.getWaystoneUid().equals(context.getFromWaystone().getWaystoneUid())) {
            return 0;
        }
        boolean enableXPCost = !player.method_31549().field_7477;
        int xpForLeashed = WaystonesConfig.getActive().xpCostPerLeashed() * context.getLeashedEntities().size();
        if (waystone.getDimension() != player.field_6002.method_27983()) {
            return enableXPCost ? WaystonesConfig.getActive().dimensionalWarpXpCost() + xpForLeashed : 0;
        }
        double xpCostMultiplier = warpMode.getXpCostMultiplier();
        if (waystone.isGlobal()) {
            xpCostMultiplier *= WaystonesConfig.getActive().globalWaystoneXpCostMultiplier();
        }
        class_2338 pos = waystone.getPos();
        double dist = Math.sqrt(player.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
        double minimumXpCost = WaystonesConfig.getActive().minimumXpCost();
        double maximumXpCost = WaystonesConfig.getActive().maximumXpCost();
        if (WaystonesConfig.getActive().blocksPerXPLevel() > 0) {
            xpLevelCost = class_3532.method_15350((double)(dist / (double)WaystonesConfig.getActive().blocksPerXPLevel()), (double)minimumXpCost, (double)maximumXpCost);
            if (WaystonesConfig.getActive().inverseXpCost()) {
                xpLevelCost = maximumXpCost - xpLevelCost;
            }
        } else {
            xpLevelCost = minimumXpCost;
        }
        return enableXPCost ? (int)Math.round((xpLevelCost + (double)xpForLeashed) * xpCostMultiplier) : 0;
    }

    @Nullable
    public static IWaystone getInventoryButtonWaystone(class_1657 player) {
        InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
        if (inventoryButtonMode.isReturnToNearest()) {
            return PlayerWaystoneManager.getNearestWaystone(player);
        }
        if (inventoryButtonMode.hasNamedTarget()) {
            return WaystoneManager.get(player.method_5682()).findWaystoneByName(inventoryButtonMode.getNamedTarget()).orElse(null);
        }
        return null;
    }

    public static boolean canUseInventoryButton(class_1657 player) {
        IWaystone waystone = PlayerWaystoneManager.getInventoryButtonWaystone(player);
        int xpLevelCost = waystone != null ? PlayerWaystoneManager.getExperienceLevelCost((class_1297)player, waystone, WarpMode.INVENTORY_BUTTON, (IWaystone)null) : 0;
        return PlayerWaystoneManager.getInventoryButtonCooldownLeft(player) <= 0L && (xpLevelCost <= 0 || player.field_7520 >= xpLevelCost);
    }

    public static boolean canUseWarpStone(class_1657 player, class_1799 heldItem) {
        return PlayerWaystoneManager.getWarpStoneCooldownLeft(player) <= 0L;
    }

    public static double getCooldownMultiplier(IWaystone waystone) {
        return waystone.isGlobal() ? WaystonesConfig.getActive().globalWaystoneCooldownMultiplier() : 1.0;
    }

    private static void informPlayer(class_1297 entity, String translationKey) {
        if (entity instanceof class_1657) {
            class_2588 chatComponent = new class_2588(translationKey);
            chatComponent.method_27692(class_124.field_1061);
            ((class_1657)entity).method_7353((class_2561)chatComponent, false);
        }
    }

    public static boolean tryTeleportToWaystone(class_1297 entity, IWaystone waystone, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        boolean isCreativeMode;
        class_2680 state;
        MinecraftServer server;
        boolean isDimensionalWarp;
        if (!waystone.isValid()) {
            logger.info("Rejected teleport to invalid waystone");
            return false;
        }
        class_1799 warpItem = PlayerWaystoneManager.findWarpItem(entity, warpMode);
        if (!PlayerWaystoneManager.canUseWarpMode(entity, warpMode, warpItem, fromWaystone)) {
            logger.info("Rejected teleport using warp mode {}", (Object)warpMode);
            return false;
        }
        if (!warpMode.getAllowTeleportPredicate().test(entity, waystone)) {
            logger.info("Rejected teleport due to predicate");
            return false;
        }
        boolean bl = isDimensionalWarp = waystone.getDimension() != entity.field_6002.method_27983();
        if (isDimensionalWarp && !PlayerWaystoneManager.canDimensionalWarpBetween(entity, waystone)) {
            logger.info("Rejected dimensional teleport");
            PlayerWaystoneManager.informPlayer(entity, "chat.waystones.cannot_dimension_warp");
            return false;
        }
        List<class_1308> leashed = PlayerWaystoneManager.findLeashedAnimals(entity);
        if (!leashed.isEmpty()) {
            if (!WaystonesConfig.getActive().transportLeashed()) {
                logger.info("Rejected teleport with leashed entities");
                PlayerWaystoneManager.informPlayer(entity, "chat.waystones.cannot_transport_leashed");
                return false;
            }
            List forbidden = WaystonesConfig.getActive().leashedDenyList().stream().map(class_2960::new).collect(Collectors.toList());
            if (leashed.stream().anyMatch(e -> forbidden.contains(class_2378.field_11145.method_10221((Object)e.method_5864())))) {
                logger.info("Rejected teleport with denied leashed entity");
                PlayerWaystoneManager.informPlayer(entity, "chat.waystones.cannot_transport_this_leashed");
                return false;
            }
            if (isDimensionalWarp && !WaystonesConfig.getActive().transportLeashedDimensional()) {
                logger.info("Rejected teleport with dimensionally denied leashed entity");
                PlayerWaystoneManager.informPlayer(entity, "chat.waystones.cannot_transport_leashed_dimensional");
                return false;
            }
        }
        if ((server = entity.method_5682()) == null) {
            logger.info("Rejected teleport due to missing server");
            return false;
        }
        class_3218 targetWorld = Objects.requireNonNull(server).method_3847(waystone.getDimension());
        class_2338 pos = waystone.getPos();
        class_2680 class_26802 = state = targetWorld != null ? targetWorld.method_8320(pos) : null;
        if (targetWorld == null || !(state.method_26204() instanceof WaystoneBlockBase)) {
            logger.info("Rejected teleport due to missing waystone");
            PlayerWaystoneManager.informPlayer(entity, "chat.waystones.waystone_missing");
            return false;
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)WaystoneBlock.FACING);
        ArrayList directionCandidates = Lists.newArrayList((Object[])new class_2350[]{direction, class_2350.field_11034, class_2350.field_11039, class_2350.field_11035, class_2350.field_11043});
        for (class_2350 candidate : directionCandidates) {
            class_2338 offsetPos = pos.method_10093(candidate);
            class_2338 offsetPosUp = offsetPos.method_10084();
            if (targetWorld.method_8320(offsetPos).method_26228((class_1922)targetWorld, offsetPos) || targetWorld.method_8320(offsetPosUp).method_26228((class_1922)targetWorld, offsetPosUp)) continue;
            direction = candidate;
            break;
        }
        WaystoneTeleportContext context = new WaystoneTeleportContext();
        context.setLeashedEntities(leashed);
        context.setDirection(direction);
        context.setTargetWorld(targetWorld);
        context.setFromWaystone(fromWaystone);
        int xpLevelCost = PlayerWaystoneManager.getExperienceLevelCost(entity, waystone, warpMode, context);
        if (entity instanceof class_1657 && ((class_1657)entity).field_7520 < xpLevelCost) {
            logger.info("Rejected teleport due to missing xp");
            return false;
        }
        boolean bl2 = isCreativeMode = entity instanceof class_1657 && ((class_1657)entity).method_31549().field_7477;
        if (warpMode.consumesItem() && !isCreativeMode) {
            warpItem.method_7934(1);
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (warpMode == WarpMode.INVENTORY_BUTTON) {
                int cooldown = (int)((double)WaystonesConfig.getActive().inventoryButtonCooldown() * PlayerWaystoneManager.getCooldownMultiplier(waystone));
                PlayerWaystoneManager.getPlayerWaystoneData(entity.field_6002).setInventoryButtonCooldownUntil(player, player.field_6002.method_8510() + (long)cooldown * 20L);
                WaystoneSyncManager.sendWaystoneCooldowns(player);
            } else if (warpMode == WarpMode.WARP_STONE) {
                int cooldown = (int)((double)WaystonesConfig.getActive().warpStoneCooldown() * PlayerWaystoneManager.getCooldownMultiplier(waystone));
                PlayerWaystoneManager.getPlayerWaystoneData(entity.field_6002).setWarpStoneCooldownUntil(player, player.field_6002.method_8510() + (long)cooldown * 20L);
                WaystoneSyncManager.sendWaystoneCooldowns(player);
            }
            if (xpLevelCost > 0) {
                player.method_7316(-xpLevelCost);
            }
        }
        PlayerWaystoneManager.teleportToWaystone(entity, waystone, context);
        return true;
    }

    private static boolean canDimensionalWarpBetween(class_1297 player, IWaystone waystone) {
        class_2960 fromDimension = player.field_6002.method_27983().method_29177();
        class_2960 toDimension = waystone.getDimension().method_29177();
        List<String> dimensionAllowList = WaystonesConfig.getActive().dimensionalWarpAllowList();
        List<String> dimensionDenyList = WaystonesConfig.getActive().dimensionalWarpDenyList();
        if (!(dimensionAllowList.isEmpty() || dimensionAllowList.contains(toDimension.toString()) && dimensionAllowList.contains(fromDimension.toString()))) {
            return false;
        }
        if (!dimensionDenyList.isEmpty() && (dimensionDenyList.contains(toDimension.toString()) || dimensionDenyList.contains(fromDimension.toString()))) {
            return false;
        }
        DimensionalWarp dimensionalWarpMode = WaystonesConfig.getActive().dimensionalWarp();
        return dimensionalWarpMode == DimensionalWarp.ALLOW || dimensionalWarpMode == DimensionalWarp.GLOBAL_ONLY && waystone.isGlobal();
    }

    private static class_1799 findWarpItem(class_1297 entity, WarpMode warpMode) {
        switch (warpMode) {
            case WARP_SCROLL: {
                return PlayerWaystoneManager.findWarpItem(entity, ModItems.warpScroll);
            }
            case WARP_STONE: {
                return PlayerWaystoneManager.findWarpItem(entity, ModItems.warpStone);
            }
            case RETURN_SCROLL: {
                return PlayerWaystoneManager.findWarpItem(entity, ModItems.returnScroll);
            }
            case BOUND_SCROLL: {
                return PlayerWaystoneManager.findWarpItem(entity, ModItems.boundScroll);
            }
        }
        return class_1799.field_8037;
    }

    private static class_1799 findWarpItem(class_1297 entity, class_1792 warpItem) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (livingEntity.method_6047().method_7909() == warpItem) {
                return livingEntity.method_6047();
            }
            if (livingEntity.method_6079().method_7909() == warpItem) {
                return livingEntity.method_6079();
            }
        }
        return class_1799.field_8037;
    }

    private static List<class_1308> findLeashedAnimals(class_1297 player) {
        return player.field_6002.method_8390(class_1308.class, new class_238(player.method_24515()).method_1014(10.0), e -> player.equals((Object)e.method_5933()));
    }

    private static void teleportToWaystone(class_1297 entity, IWaystone waystone, WaystoneTeleportContext context) {
        class_2586 targetTileEntity;
        class_3218 sourceWorld = (class_3218)entity.field_6002;
        class_2338 sourcePos = entity.method_24515();
        class_2338 pos = waystone.getPos();
        class_2350 direction = context.getDirection();
        class_3218 targetWorld = context.getTargetWorld();
        class_2338 targetPos = waystone.getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE) ? pos : pos.method_10093(direction);
        class_243 targetPos3d = new class_243((double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.5, (double)targetPos.method_10260() + 0.5);
        class_1297 mount = entity.method_5854();
        if (mount != null) {
            entity.method_5848();
            mount = PlayerWaystoneManager.teleportEntity(mount, targetWorld, targetPos3d, direction);
        }
        if ((targetTileEntity = context.getTargetWorld().method_8321(waystone.getPos())) instanceof WarpPlateBlockEntity) {
            ((WarpPlateBlockEntity)targetTileEntity).markEntityForCooldown(entity);
            if (mount != null) {
                ((WarpPlateBlockEntity)targetTileEntity).markEntityForCooldown(mount);
            }
            context.getLeashedEntities().forEach(((WarpPlateBlockEntity)targetTileEntity)::markEntityForCooldown);
        }
        entity = PlayerWaystoneManager.teleportEntity(entity, targetWorld, targetPos3d, direction);
        if (mount != null) {
            entity.method_5804(mount);
        }
        sourceWorld.method_8396(null, sourcePos, class_3417.field_14716, class_3419.field_15248, 0.1f, 1.0f);
        targetWorld.method_8396(null, targetPos, class_3417.field_14716, class_3419.field_15248, 0.1f, 1.0f);
        Balm.getNetworking().sendToTracking(sourceWorld, sourcePos, (Object)new TeleportEffectMessage(sourcePos));
        Balm.getNetworking().sendToTracking(targetWorld, targetPos, (Object)new TeleportEffectMessage(targetPos));
        context.getLeashedEntities().forEach(mob -> PlayerWaystoneManager.teleportEntity((class_1297)mob, targetWorld, targetPos3d, direction));
    }

    private static class_1297 teleportEntity(class_1297 entity, class_3218 targetWorld, class_243 targetPos3d, class_2350 direction) {
        float yaw = direction.method_10144();
        double x = targetPos3d.field_1352;
        double y = targetPos3d.field_1351;
        double z = targetPos3d.field_1350;
        if (entity instanceof class_3222) {
            class_1923 chunkPos = new class_1923(new class_2338(x, y, z));
            targetWorld.method_14178().method_17297(class_3230.field_19347, chunkPos, 1, (Object)entity.method_5628());
            entity.method_5848();
            if (((class_3222)entity).method_6113()) {
                ((class_3222)entity).method_7358(true, true);
            }
            if (targetWorld == entity.field_6002) {
                ((class_3222)entity).field_13987.method_14360(x, y, z, yaw, entity.method_36455(), Collections.emptySet());
            } else {
                ((class_3222)entity).method_14251(targetWorld, x, y, z, yaw, entity.method_36455());
            }
            entity.method_5847(yaw);
        } else {
            float pitch = class_3532.method_15363((float)entity.method_36455(), (float)-90.0f, (float)90.0f);
            if (targetWorld == entity.field_6002) {
                entity.method_5808(x, y, z, yaw, pitch);
                entity.method_5847(yaw);
            } else {
                entity.method_18375();
                class_1297 oldEntity = entity;
                entity = entity.method_5864().method_5883((class_1937)targetWorld);
                if (entity == null) {
                    return oldEntity;
                }
                entity.method_5878(oldEntity);
                entity.method_5808(x, y, z, yaw, pitch);
                entity.method_5847(yaw);
                oldEntity.method_31745(class_1297.class_5529.field_27002);
                targetWorld.method_18769(entity);
            }
        }
        if (!(entity instanceof class_1309) || !((class_1309)entity).method_6128()) {
            entity.method_18799(entity.method_18798().method_18805(1.0, 0.0, 1.0));
            entity.method_24830(true);
        }
        if (entity instanceof class_1314) {
            ((class_1314)entity).method_5942().method_6340();
        }
        return entity;
    }

    public static void deactivateWaystone(class_1657 player, IWaystone waystone) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.field_6002).deactivateWaystone(player, waystone);
    }

    private static boolean canUseWarpMode(class_1297 entity, WarpMode warpMode, class_1799 heldItem, @Nullable IWaystone fromWaystone) {
        switch (warpMode) {
            case INVENTORY_BUTTON: {
                return entity instanceof class_1657 && PlayerWaystoneManager.canUseInventoryButton((class_1657)entity);
            }
            case WARP_SCROLL: {
                return !heldItem.method_7960() && heldItem.method_7909() == ModItems.warpScroll;
            }
            case BOUND_SCROLL: {
                return !heldItem.method_7960() && heldItem.method_7909() == ModItems.boundScroll;
            }
            case RETURN_SCROLL: {
                return !heldItem.method_7960() && heldItem.method_7909() == ModItems.returnScroll;
            }
            case WARP_STONE: {
                return !heldItem.method_7960() && heldItem.method_7909() == ModItems.warpStone && entity instanceof class_1657 && PlayerWaystoneManager.canUseWarpStone((class_1657)entity, heldItem);
            }
            case WAYSTONE_TO_WAYSTONE: {
                return WaystonesConfig.getActive().allowWaystoneToWaystoneTeleport() && fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE);
            }
            case SHARESTONE_TO_SHARESTONE: {
                return fromWaystone != null && fromWaystone.isValid() && WaystoneTypes.isSharestone(fromWaystone.getWaystoneType());
            }
            case WARP_PLATE: {
                return fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE);
            }
            case PORTSTONE_TO_WAYSTONE: {
                return fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.PORTSTONE);
            }
        }
        return false;
    }

    public static long getWarpStoneCooldownUntil(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.field_6002).getWarpStoneCooldownUntil(player);
    }

    public static long getWarpStoneCooldownLeft(class_1657 player) {
        long cooldownUntil = PlayerWaystoneManager.getWarpStoneCooldownUntil(player);
        return Math.max(0L, cooldownUntil - player.field_6002.method_8510());
    }

    public static void setWarpStoneCooldownUntil(class_1657 player, long timeStamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.field_6002).setWarpStoneCooldownUntil(player, timeStamp);
    }

    public static long getInventoryButtonCooldownUntil(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.field_6002).getInventoryButtonCooldownUntil(player);
    }

    public static long getInventoryButtonCooldownLeft(class_1657 player) {
        long cooldownUntil = PlayerWaystoneManager.getInventoryButtonCooldownUntil(player);
        return Math.max(0L, cooldownUntil - player.field_6002.method_8510());
    }

    public static void setInventoryButtonCooldownUntil(class_1657 player, long timeStamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.field_6002).setInventoryButtonCooldownUntil(player, timeStamp);
    }

    @Nullable
    public static IWaystone getNearestWaystone(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.field_6002).getWaystones(player).stream().filter(it -> it.getDimension() == player.field_6002.method_27983()).min((first, second) -> {
            double firstDist = first.getPos().method_10268(player.method_23317(), player.method_23318(), player.method_23321(), true);
            double secondDist = second.getPos().method_10268(player.method_23317(), player.method_23318(), player.method_23321(), true);
            return (int)Math.round(firstDist) - (int)Math.round(secondDist);
        }).orElse(null);
    }

    public static List<IWaystone> getWaystones(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.field_6002).getWaystones(player);
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(@Nullable class_1937 world) {
        return world == null || world.field_9236 ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(BalmEnvironment side) {
        return side.isClient() ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static boolean mayTeleportToWaystone(class_1657 player, IWaystone waystone) {
        return true;
    }

    public static void swapWaystoneSorting(class_1657 player, int index, int otherIndex) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.field_6002).swapWaystoneSorting(player, index, otherIndex);
    }

    public static boolean mayEditGlobalWaystones(class_1657 player) {
        return player.method_31549().field_7477 || !WaystonesConfig.getActive().globalWaystoneRequiresCreative();
    }

    public static void activeWaystoneForEveryone(@Nullable MinecraftServer server, IWaystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            if (PlayerWaystoneManager.isWaystoneActivated((class_1657)player, waystone)) continue;
            PlayerWaystoneManager.activateWaystone((class_1657)player, waystone);
        }
    }

    public static void removeKnownWaystone(@Nullable MinecraftServer server, IWaystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            PlayerWaystoneManager.deactivateWaystone((class_1657)player, waystone);
            WaystoneSyncManager.sendActivatedWaystones((class_1657)player);
        }
    }
}

