/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.item.BalmItem;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.IResetUseOnDamage;
import net.blay09.mods.waystones.compat.Compat;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

public class WarpStoneItem
extends BalmItem
implements IResetUseOnDamage {
    private static final BalmMenuProvider containerProvider = new BalmMenuProvider(){

        public class_2561 method_5476() {
            return new class_2588("container.waystones.waystone_selection");
        }

        public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
            return WaystoneSelectionMenu.createWaystoneSelection(i, playerEntity, WarpMode.WARP_STONE, null);
        }

        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            buf.writeByte(WarpMode.WARP_STONE.ordinal());
        }
    };

    public WarpStoneItem(class_1792.class_1793 properties) {
        super(properties.method_7895(100));
    }

    public int method_7881(class_1799 itemStack) {
        return WaystonesConfig.getActive().warpStoneUseTime();
    }

    public class_1839 method_7853(class_1799 itemStack) {
        if (Compat.isVivecraftInstalled) {
            return class_1839.field_8952;
        }
        return class_1839.field_8953;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 entity) {
        if (!world.field_9236 && entity instanceof class_3222) {
            Balm.getNetworking().openGui((class_1657)((class_3222)entity), (class_3908)containerProvider);
        }
        return stack;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (player.method_31549().field_7477) {
            PlayerWaystoneManager.setWarpStoneCooldownUntil(player, 0L);
        }
        if (PlayerWaystoneManager.canUseWarpStone(player, itemStack)) {
            if (!player.method_6115() && !world.field_9236) {
                world.method_8449(null, (class_1297)player, class_3417.field_14669, class_3419.field_15248, 0.1f, 2.0f);
            }
            if (Compat.isVivecraftInstalled) {
                this.method_7861(itemStack, world, (class_1309)player);
            } else {
                player.method_6019(hand);
            }
            return new class_1271(class_1269.field_5812, (Object)itemStack);
        }
        class_2588 chatComponent = new class_2588("chat.waystones.warpstone_not_charged");
        chatComponent.method_27692(class_124.field_1061);
        player.method_7353((class_2561)chatComponent, true);
        return new class_1271(class_1269.field_5814, (Object)itemStack);
    }

    public boolean balmShowDurabilityBar(class_1799 itemStack) {
        return this.balmGetDurabilityForDisplay(itemStack) > 0.0;
    }

    public double balmGetDurabilityForDisplay(class_1799 stack) {
        class_1657 player = BalmClient.getClientPlayer();
        if (player == null) {
            return 0.0;
        }
        long timeLeft = PlayerWaystoneManager.getWarpStoneCooldownLeft(player);
        int maxCooldown = WaystonesConfig.getActive().warpStoneCooldown() * 20;
        if (maxCooldown == 0) {
            return 0.0;
        }
        return class_3532.method_15363((float)((float)timeLeft / (float)maxCooldown), (float)0.0f, (float)1.0f);
    }

    public boolean method_7886(class_1799 itemStack) {
        return PlayerWaystoneManager.canUseWarpStone(BalmClient.getClientPlayer(), itemStack) || super.method_7886(itemStack);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> list, class_1836 flag) {
        class_1657 player = BalmClient.getClientPlayer();
        if (player == null) {
            return;
        }
        long timeLeft = PlayerWaystoneManager.getWarpStoneCooldownLeft(player);
        int secondsLeft = (int)(timeLeft / 20L);
        if (secondsLeft > 0) {
            class_2588 secondsLeftText = new class_2588("tooltip.waystones.cooldown_left", new Object[]{secondsLeft});
            secondsLeftText.method_27692(class_124.field_1065);
            list.add((class_2561)secondsLeftText);
        }
    }
}

