/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.event.server.ServerReloadedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.api.world.BiomePredicate;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WorldGenStyle;
import net.blay09.mods.waystones.worldgen.WaystoneDecorator;
import net.blay09.mods.waystones.worldgen.WaystoneFeature;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_2998;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_3243;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5188;
import net.minecraft.class_5455;
import net.minecraft.class_5925;

public class ModWorldGen {
    private static final class_2960 villageWaystoneStructure = new class_2960("waystones", "village/common/waystone");
    private static final class_2960 desertVillageWaystoneStructure = new class_2960("waystones", "village/desert/waystone");
    private static final class_2960 emptyStructure = new class_2960("empty");
    private static DeferredObject<WaystoneFeature> waystoneFeature;
    private static DeferredObject<WaystoneFeature> mossyWaystoneFeature;
    private static DeferredObject<WaystoneFeature> sandyWaystoneFeature;
    private static DeferredObject<class_2975<?, ?>> configuredWaystoneFeature;
    private static DeferredObject<class_2975<?, ?>> configuredMossyWaystoneFeature;
    private static DeferredObject<class_2975<?, ?>> configuredSandyWaystoneFeature;
    private static DeferredObject<WaystoneDecorator> waystoneDecorator;

    public static void initialize(BalmWorldGen worldGen) {
        waystoneFeature = worldGen.registerFeature(() -> new WaystoneFeature((Codec<class_3111>)class_3111.field_24893, ModBlocks.waystone.method_9564()), ModWorldGen.id("waystone"));
        mossyWaystoneFeature = worldGen.registerFeature(() -> new WaystoneFeature((Codec<class_3111>)class_3111.field_24893, ModBlocks.mossyWaystone.method_9564()), ModWorldGen.id("mossy_waystone"));
        sandyWaystoneFeature = worldGen.registerFeature(() -> new WaystoneFeature((Codec<class_3111>)class_3111.field_24893, ModBlocks.sandyWaystone.method_9564()), ModWorldGen.id("sandy_waystone"));
        waystoneDecorator = worldGen.registerDecorator(() -> new WaystoneDecorator((Codec<class_5925>)class_5925.field_29265), ModWorldGen.id("waystone"));
        Supplier<class_3243> configuredDecorator = () -> ((WaystoneDecorator)((Object)((Object)waystoneDecorator.get()))).method_23475((class_2998)new class_5925(class_2902.class_2903.field_13195));
        configuredWaystoneFeature = worldGen.registerConfiguredFeature(() -> worldGen.configuredFeature((class_3031)waystoneFeature.get(), (class_3037)class_3037.field_13603, (class_3243)configuredDecorator.get()), ModWorldGen.id("waystone"));
        configuredMossyWaystoneFeature = worldGen.registerConfiguredFeature(() -> worldGen.configuredFeature((class_3031)mossyWaystoneFeature.get(), (class_3037)class_3037.field_13603, (class_3243)configuredDecorator.get()), ModWorldGen.id("mossy_waystone"));
        configuredSandyWaystoneFeature = worldGen.registerConfiguredFeature(() -> worldGen.configuredFeature((class_3031)sandyWaystoneFeature.get(), (class_3037)class_3037.field_13603, (class_3243)configuredDecorator.get()), ModWorldGen.id("sandy_waystone"));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesCategory(class_1959.class_1961.field_9368), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.SANDY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesCategory(class_1959.class_1961.field_9358), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesCategory(class_1959.class_1961.field_9364), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesCategory(class_1959.class_1961.field_9365), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesNeitherCategory(class_1959.class_1961.field_9364, class_1959.class_1961.field_9368, class_1959.class_1961.field_9358, class_1959.class_1961.field_9365), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.DEFAULT));
        Balm.getEvents().onEvent(ServerStartedEvent.class, event -> ModWorldGen.setupVillageWorldGen(event.getServer().method_30611()));
        Balm.getEvents().onEvent(ServerReloadedEvent.class, event -> ModWorldGen.setupVillageWorldGen(event.getServer().method_30611()));
    }

    private static BiomePredicate matchesCategory(class_1959.class_1961 category) {
        return (resourceLocation, biomeCategory, precipitation, v, v1) -> category == biomeCategory;
    }

    private static BiomePredicate matchesNeitherCategory(class_1959.class_1961 ... categories) {
        return (resourceLocation, biomeCategory, precipitation, v, v1) -> {
            for (class_1959.class_1961 category : categories) {
                if (category != biomeCategory) continue;
                return false;
            }
            return true;
        };
    }

    private static class_2960 id(String name) {
        return new class_2960("waystones", name);
    }

    private static class_2960 getWaystoneFeature(WorldGenStyle biomeWorldGenStyle) {
        WorldGenStyle worldGenStyle = WaystonesConfig.getActive().worldGenStyle();
        return switch (worldGenStyle) {
            case WorldGenStyle.MOSSY -> configuredMossyWaystoneFeature.getIdentifier();
            case WorldGenStyle.SANDY -> configuredSandyWaystoneFeature.getIdentifier();
            case WorldGenStyle.BIOME -> {
                switch (biomeWorldGenStyle) {
                    case SANDY: {
                        yield configuredSandyWaystoneFeature.getIdentifier();
                    }
                    case MOSSY: {
                        yield configuredMossyWaystoneFeature.getIdentifier();
                    }
                }
                yield configuredWaystoneFeature.getIdentifier();
            }
            default -> configuredWaystoneFeature.getIdentifier();
        };
    }

    public static void setupVillageWorldGen(class_5455 registryAccess) {
        if (WaystonesConfig.getActive().spawnInVillages() || WaystonesConfig.getActive().forceSpawnInVillages()) {
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/plains/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/snowy/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/savanna/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/desert/houses", desertVillageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/taiga/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/badlands/houses", desertVillageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/birch/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/dark_forest/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/giant_taiga/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/jungle/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/mountains/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/mushroom/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/oak/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "repurposed_structures:villages/swamp/houses", villageWaystoneStructure, 1);
        }
    }

    private static void addWaystoneStructureToVillageConfig(class_5455 registryAccess, String villagePiece, class_2960 waystoneStructure, int weight) {
        class_5188 piece = (class_5188)class_3784.method_30425((String)waystoneStructure.toString()).apply(class_3785.class_3786.field_16687);
        class_3785 pool = registryAccess.method_30530(class_2378.field_25917).method_17966(new class_2960(villagePiece)).orElse(null);
        if (pool != null) {
            ArrayList<class_5188> listOfPieces = new ArrayList<class_5188>(pool.field_16680);
            for (int i = 0; i < weight; ++i) {
                listOfPieces.add(piece);
            }
            pool.field_16680 = listOfPieces;
            ArrayList<Pair> listOfWeightedPieces = new ArrayList<Pair>(pool.field_16864);
            listOfWeightedPieces.add(new Pair((Object)piece, (Object)weight));
            pool.field_16864 = listOfWeightedPieces;
        }
    }
}

