/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5438;
import net.minecraft.class_5444;
import net.minecraft.class_5925;

public class WaystoneDecorator
extends class_5438 {
    public WaystoneDecorator(Codec<class_5925> codec) {
        super(codec);
    }

    public Stream<class_2338> method_34384(class_5444 context, Random random, class_5925 config, class_2338 pos) {
        if (this.isWaystoneChunk(context, pos)) {
            if (context.method_34383().method_8410().method_27983() == class_1937.field_25180) {
                class_2338.class_2339 mutablePos = pos.method_25503();
                int topMostY = context.method_30460(config.field_29266, pos.method_10263(), pos.method_10260());
                mutablePos.method_33098(topMostY);
                class_2680 stateAbove = context.method_34383().method_8320((class_2338)mutablePos);
                for (int i = mutablePos.method_10264(); i >= 1; --i) {
                    mutablePos.method_33098(mutablePos.method_10264() - 1);
                    class_2680 state = context.method_34383().method_8320((class_2338)mutablePos);
                    if (!state.method_26215() && state.method_26227().method_15769() && stateAbove.method_26215() && !state.method_27852(class_2246.field_9987)) {
                        mutablePos.method_33098(mutablePos.method_10264() + 1);
                        break;
                    }
                    stateAbove = state;
                }
                return mutablePos.method_10264() > 0 ? Stream.of(mutablePos) : Stream.empty();
            }
            return super.method_34384(context, random, config, pos);
        }
        return Stream.empty();
    }

    private boolean isWaystoneChunk(class_5444 world, class_2338 pos) {
        int chunkDistance = WaystonesConfig.getActive().worldGenFrequency();
        if (chunkDistance == 0) {
            return false;
        }
        class_2960 dimension = world.method_34383().method_8410().method_27983().method_29177();
        List<String> dimensionAllowList = WaystonesConfig.getActive().worldGenDimensionAllowList();
        List<String> dimensionDenyList = WaystonesConfig.getActive().worldGenDimensionDenyList();
        if (!dimensionAllowList.isEmpty() && !dimensionAllowList.contains(dimension.toString())) {
            return false;
        }
        if (!dimensionDenyList.isEmpty() && dimensionDenyList.contains(dimension.toString())) {
            return false;
        }
        int maxDeviation = (int)Math.ceil((float)chunkDistance / 2.0f);
        int chunkX = pos.method_10263() / 16;
        int chunkZ = pos.method_10260() / 16;
        int devGridX = pos.method_10263() / 16 * maxDeviation;
        int devGridZ = pos.method_10260() / 16 * maxDeviation;
        long seed = world.method_34383().method_8412();
        Random random = new Random(seed * (long)devGridX * (long)devGridZ);
        int chunkOffsetX = random.nextInt(maxDeviation);
        int chunkOffsetZ = random.nextInt(maxDeviation);
        return (chunkX + chunkOffsetX) % chunkDistance == 0 && (chunkZ + chunkOffsetZ) % chunkDistance == 0;
    }
}

