/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.List;
import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2426;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;

public abstract class WaystoneBlockBase
extends class_2237
implements class_3737 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;

    public WaystoneBlockBase(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 directionState, class_1936 world, class_2338 pos, class_2338 directionPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (this.isDoubleBlock(state)) {
            class_2756 half = (class_2756)state.method_11654(HALF);
            if ((direction.method_10166() != class_2350.class_2351.field_11052 || half == class_2756.field_12607 != (direction == class_2350.field_11036) || directionState.method_26204() == this && directionState.method_11654(HALF) != half) && (half != class_2756.field_12607 || direction != class_2350.field_11033 || state.method_26184((class_4538)world, pos))) {
                return state;
            }
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 stack) {
        if (this.isDoubleBlock(state)) {
            super.method_9556(world, player, pos, class_2246.field_10124.method_9564(), blockEntity, stack);
        } else {
            super.method_9556(world, player, pos, state, blockEntity, stack);
        }
    }

    private boolean isDoubleBlock(class_2680 state) {
        return state.method_28498(HALF);
    }

    protected boolean canSilkTouch() {
        return false;
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2680 offsetState;
        boolean hasSilkTouch;
        class_2586 blockEntity = world.method_8321(pos);
        boolean isDoubleBlock = this.isDoubleBlock(state);
        class_2756 half = isDoubleBlock ? (class_2756)state.method_11654(HALF) : null;
        class_2338 offset = half == class_2756.field_12607 ? pos.method_10084() : pos.method_10074();
        class_2586 offsetTileEntity = isDoubleBlock ? world.method_8321(offset) : null;
        boolean bl = hasSilkTouch = class_1890.method_8203((class_1887)class_1893.field_9099, (class_1309)player) > 0;
        if (hasSilkTouch && this.canSilkTouch()) {
            if (blockEntity instanceof WaystoneBlockEntityBase) {
                ((WaystoneBlockEntityBase)blockEntity).setSilkTouched(true);
            }
            if (isDoubleBlock && offsetTileEntity instanceof WaystoneBlockEntityBase) {
                ((WaystoneBlockEntityBase)offsetTileEntity).setSilkTouched(true);
            }
        }
        if (isDoubleBlock && (offsetState = world.method_8320(offset)).method_26204() == this && offsetState.method_11654(HALF) != half) {
            world.method_8651(half == class_2756.field_12607 ? pos : offset, false, (class_1297)player);
            if (!world.field_9236 && !player.method_31549().field_7477) {
                WaystoneBlockBase.method_9511((class_2680)state, (class_1937)world, (class_2338)pos, (class_2586)blockEntity, (class_1297)player, (class_1799)player.method_6047());
                WaystoneBlockBase.method_9511((class_2680)offsetState, (class_1937)world, (class_2338)offset, (class_2586)offsetTileEntity, (class_1297)player, (class_1799)player.method_6047());
            }
        }
        super.method_9576(world, pos, state, player);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED});
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        if (!PlayerWaystoneManager.mayBreakWaystone(player, world, pos)) {
            return -1.0f;
        }
        return super.method_9594(state, player, world, pos);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        if (!this.isDoubleBlock(state)) {
            return true;
        }
        if (state.method_11654(HALF) == class_2756.field_12607) {
            return true;
        }
        class_2680 below = world.method_8320(pos.method_10074());
        return below.method_26204() == this && below.method_11654(HALF) == class_2756.field_12607;
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        if (!PlayerWaystoneManager.mayPlaceWaystone(context.method_8036())) {
            return null;
        }
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_3610 fluidState = world.method_8316(pos);
        if (pos.method_10264() < world.method_31605() - 1 && world.method_8320(pos.method_10084()).method_26166(context)) {
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        }
        return null;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_3619 method_9527(class_2680 state) {
        return class_3619.field_15972;
    }

    protected void notifyObserversOfAction(class_1937 world, class_2338 pos) {
        if (!world.field_9236) {
            for (class_2350 direction : class_2350.values()) {
                class_2338 offset = pos.method_10093(direction);
                class_2680 neighbourState = world.method_8320(offset);
                class_2248 neighbourBlock = neighbourState.method_26204();
                if (!(neighbourBlock instanceof class_2426) || neighbourState.method_11654((class_2769)class_2426.field_10927) != direction.method_10153() || world.method_8397().method_8674(offset, (Object)neighbourBlock)) continue;
                world.method_39279(offset, neighbourBlock, 2);
            }
        }
    }

    @Nullable
    protected class_1269 handleEditActions(class_1937 world, class_1657 player, WaystoneBlockEntityBase tileEntity, IWaystone waystone) {
        if (player.method_5715()) {
            class_3908 settingsContainerProvider;
            WaystoneEditPermissions result = PlayerWaystoneManager.mayEditWaystone(player, world, waystone);
            if (result != WaystoneEditPermissions.ALLOW) {
                if (result.getLangKey() != null) {
                    class_2588 chatComponent = new class_2588(result.getLangKey());
                    chatComponent.method_27692(class_124.field_1061);
                    player.method_7353((class_2561)chatComponent, true);
                }
                return class_1269.field_5812;
            }
            if (!world.field_9236 && (settingsContainerProvider = tileEntity.getSettingsMenuProvider()) != null) {
                Balm.getNetworking().openGui(player, settingsContainerProvider);
            }
            return class_1269.field_5812;
        }
        return null;
    }

    @Nullable
    protected class_1269 handleDebugActions(class_1937 world, class_1657 player, class_1268 hand, WaystoneBlockEntityBase tileEntity) {
        if (player.method_31549().field_7477) {
            class_1799 heldItem = player.method_5998(hand);
            if (heldItem.method_7909() == class_1802.field_8648) {
                if (!world.field_9236) {
                    tileEntity.uninitializeWaystone();
                    player.method_7353((class_2561)new class_2585("Waystone was successfully reset - it will re-initialize once it is next loaded."), false);
                }
                return class_1269.field_5812;
            }
            if (heldItem.method_7909() == class_1802.field_8600) {
                if (!world.field_9236) {
                    player.method_7353((class_2561)new class_2585("Server UUID: " + tileEntity.getWaystone().getWaystoneUid()), false);
                }
                if (world.field_9236) {
                    player.method_7353((class_2561)new class_2585("Client UUID: " + tileEntity.getWaystone().getWaystoneUid()), false);
                }
                return class_1269.field_5812;
            }
        }
        return null;
    }

    @Nullable
    protected class_1269 handleActivation(class_1937 world, class_2338 pos, class_1657 player, WaystoneBlockEntityBase tileEntity, IWaystone waystone) {
        return null;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
        class_2586 blockEntity;
        if (!(state.method_27852(newState.method_26204()) || !((blockEntity = world.method_8321(pos)) instanceof WaystoneBlockEntityBase) || this.canSilkTouch() && ((WaystoneBlockEntityBase)blockEntity).isSilkTouched())) {
            IWaystone waystone = ((WaystoneBlockEntityBase)blockEntity).getWaystone();
            WaystoneManager.get(world.method_8503()).removeWaystone(waystone);
            PlayerWaystoneManager.removeKnownWaystone(world.method_8503(), waystone);
        }
        super.method_9536(state, world, pos, newState, isMoving);
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> list, class_1836 flag) {
        WaystoneProxy waystone;
        super.method_9568(stack, world, list, flag);
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("UUID", 11) && (waystone = new WaystoneProxy(null, class_2512.method_25930((class_2520)Objects.requireNonNull(tag.method_10580("UUID"))))).isValid()) {
            this.addWaystoneNameToTooltip(list, waystone);
        }
    }

    protected void addWaystoneNameToTooltip(List<class_2561> tooltip, WaystoneProxy waystone) {
        class_2585 component = new class_2585(waystone.getName());
        component.method_27692(class_124.field_1075);
        tooltip.add((class_2561)component);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 blockHitResult) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneTileEntity = (WaystoneBlockEntityBase)blockEntity;
            class_1269 result = this.handleDebugActions(world, player, hand, waystoneTileEntity);
            if (result != null) {
                return result;
            }
            IWaystone waystone = waystoneTileEntity.getWaystone();
            result = this.handleEditActions(world, player, waystoneTileEntity, waystone);
            if (result != null) {
                return result;
            }
            result = this.handleActivation(world, pos, player, waystoneTileEntity, waystone);
            if (result != null) {
                return result;
            }
        }
        return class_1269.field_5814;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2586 blockEntity = world.method_8321(pos);
        class_2338 posAbove = pos.method_10084();
        boolean isDoubleBlock = this.isDoubleBlock(state);
        if (isDoubleBlock) {
            class_3610 fluidStateAbove = world.method_8316(posAbove);
            world.method_8501(posAbove, (class_2680)((class_2680)state.method_11657(HALF, (Comparable)class_2756.field_12609)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidStateAbove.method_15772() == class_3612.field_15910)));
        }
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            class_3908 settingsContainerProvider;
            WaystoneBlockEntityBase waystoneTileEntity;
            class_3222 player;
            WaystoneEditPermissions result;
            if (!world.field_9236) {
                class_2586 waystoneEntityAbove;
                class_2487 tag = stack.method_7969();
                WaystoneProxy existingWaystone = null;
                if (tag != null && tag.method_10573("UUID", 11)) {
                    existingWaystone = new WaystoneProxy(world.method_8503(), class_2512.method_25930((class_2520)Objects.requireNonNull(tag.method_10580("UUID"))));
                }
                if (existingWaystone != null && existingWaystone.isValid() && existingWaystone.getBackingWaystone() instanceof Waystone) {
                    ((WaystoneBlockEntityBase)blockEntity).initializeFromExisting((class_5425)world, (Waystone)existingWaystone.getBackingWaystone(), stack);
                } else {
                    ((WaystoneBlockEntityBase)blockEntity).initializeWaystone((class_5425)world, placer, false);
                }
                if (isDoubleBlock && (waystoneEntityAbove = world.method_8321(posAbove)) instanceof WaystoneBlockEntityBase) {
                    ((WaystoneBlockEntityBase)waystoneEntityAbove).initializeFromBase((WaystoneBlockEntityBase)blockEntity);
                }
            }
            if (placer instanceof class_1657) {
                IWaystone waystone = ((WaystoneBlockEntityBase)blockEntity).getWaystone();
                PlayerWaystoneManager.activateWaystone((class_1657)placer, waystone);
                if (!world.field_9236) {
                    WaystoneSyncManager.sendActivatedWaystones((class_1657)placer);
                }
            }
            if (!world.field_9236 && placer instanceof class_3222 && (result = PlayerWaystoneManager.mayEditWaystone((class_1657)(player = (class_3222)placer), world, (waystoneTileEntity = (WaystoneBlockEntityBase)blockEntity).getWaystone())) == WaystoneEditPermissions.ALLOW && (settingsContainerProvider = waystoneTileEntity.getSettingsMenuProvider()) != null) {
                Balm.getNetworking().openGui((class_1657)player, settingsContainerProvider);
            }
        }
    }

    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }
}

