/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IFOVOnUse;
import net.blay09.mods.waystones.api.IResetUseOnDamage;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntity;
import net.blay09.mods.waystones.compat.Compat;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.item.ScrollItemBase;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class BoundScrollItem
extends ScrollItemBase
implements IResetUseOnDamage,
IFOVOnUse {
    public BoundScrollItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public int method_7881(class_1799 itemStack) {
        return WaystonesConfig.getActive().scrollUseTime();
    }

    private void setBoundTo(class_1799 itemStack, @Nullable IWaystone entry) {
        class_2487 tagCompound = itemStack.method_7969();
        if (tagCompound == null) {
            tagCompound = new class_2487();
            itemStack.method_7980(tagCompound);
        }
        if (entry != null) {
            tagCompound.method_10566("WaystonesBoundTo", (class_2520)class_2512.method_25929((UUID)entry.getWaystoneUid()));
        } else {
            tagCompound.method_10551("WaystonesBoundTo");
        }
    }

    @Nullable
    protected IWaystone getBoundTo(class_1657 player, class_1799 itemStack) {
        class_2487 tagCompound = itemStack.method_7969();
        if (tagCompound != null && tagCompound.method_10573("WaystonesBoundTo", 11)) {
            return new WaystoneProxy(player.method_5682(), class_2512.method_25930((class_2520)Objects.requireNonNull(tagCompound.method_10580("WaystonesBoundTo"))));
        }
        return null;
    }

    protected WarpMode getWarpMode() {
        return WarpMode.BOUND_SCROLL;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        if (player == null) {
            return class_1269.field_5811;
        }
        class_1799 heldItem = player.method_5998(context.method_20287());
        class_1937 world = context.method_8045();
        class_2586 tileEntity = world.method_8321(context.method_8037());
        if (tileEntity instanceof WaystoneBlockEntity) {
            IWaystone waystone = ((WaystoneBlockEntity)tileEntity).getWaystone();
            if (!PlayerWaystoneManager.isWaystoneActivated(player, waystone)) {
                PlayerWaystoneManager.activateWaystone(player, waystone);
            }
            if (!world.field_9236) {
                class_1799 boundItem = heldItem.method_7947() == 1 ? heldItem : heldItem.method_7971(1);
                this.setBoundTo(boundItem, waystone);
                if (boundItem != heldItem && !player.method_7270(boundItem)) {
                    player.method_7328(boundItem, false);
                }
                class_2588 chatComponent = new class_2588("chat.waystones.scroll_bound", new Object[]{waystone.getName()});
                chatComponent.method_27692(class_124.field_1054);
                player.method_7353((class_2561)chatComponent, true);
                world.method_8396(null, context.method_8037(), class_3417.field_14709, class_3419.field_15245, 0.2f, 2.0f);
            }
            return !world.field_9236 ? class_1269.field_5812 : class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 entity) {
        class_1657 player;
        IWaystone boundTo;
        if (!world.field_9236 && entity instanceof class_3222 && (boundTo = this.getBoundTo(player = (class_1657)entity, stack)) != null) {
            double distance = entity.method_5649((double)boundTo.getPos().method_10263(), (double)boundTo.getPos().method_10264(), (double)boundTo.getPos().method_10260());
            if (distance <= 3.0) {
                return stack;
            }
            PlayerWaystoneManager.tryTeleportToWaystone((class_1297)player, boundTo, this.getWarpMode(), null);
        }
        return stack;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        IWaystone boundTo = this.getBoundTo(player, itemStack);
        if (boundTo != null) {
            if (!player.method_6115() && world.field_9236) {
                world.method_8449(null, (class_1297)player, class_3417.field_14669, class_3419.field_15248, 0.1f, 2.0f);
            }
            if (this.method_7881(itemStack) <= 0 || Compat.isVivecraftInstalled) {
                this.method_7861(itemStack, world, (class_1309)player);
            } else {
                player.method_6019(hand);
            }
            return new class_1271(class_1269.field_5812, (Object)itemStack);
        }
        class_2588 chatComponent = new class_2588("chat.waystones.scroll_not_yet_bound");
        chatComponent.method_27692(class_124.field_1061);
        player.method_7353((class_2561)chatComponent, true);
        return new class_1271(class_1269.field_5814, (Object)itemStack);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> list, class_1836 flag) {
        class_2585 targetText;
        class_1657 player = Balm.getProxy().getClientPlayer();
        if (player == null) {
            return;
        }
        IWaystone boundTo = this.getBoundTo(player, stack);
        Object object = targetText = boundTo != null ? new class_2585(boundTo.getName()) : new class_2588("tooltip.waystones.bound_to_none");
        if (boundTo != null) {
            targetText.method_27692(class_124.field_1075);
        }
        class_2588 boundToText = new class_2588("tooltip.waystones.bound_to", new Object[]{targetText});
        boundToText.method_27692(class_124.field_1080);
        list.add((class_2561)boundToText);
    }
}

