/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.waystones.api.IMutableWaystone;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.TeleportDestination;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.blay09.mods.waystones.tag.ModTags;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class Waystone
implements IWaystone,
IMutableWaystone {
    private final class_2960 waystoneType;
    private final UUID waystoneUid;
    private final boolean wasGenerated;
    private class_5321<class_1937> dimension;
    private class_2338 pos;
    private String name = "";
    private boolean isGlobal;
    private UUID ownerUid;

    public Waystone(class_2960 waystoneType, UUID waystoneUid, class_5321<class_1937> dimension, class_2338 pos, boolean wasGenerated, @Nullable UUID ownerUid) {
        this.waystoneType = waystoneType;
        this.waystoneUid = waystoneUid;
        this.dimension = dimension;
        this.pos = pos;
        this.wasGenerated = wasGenerated;
        this.ownerUid = ownerUid;
    }

    @Override
    public UUID getWaystoneUid() {
        return this.waystoneUid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public class_5321<class_1937> getDimension() {
        return this.dimension;
    }

    @Override
    public boolean wasGenerated() {
        return this.wasGenerated;
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    @Override
    public void setGlobal(boolean global) {
        this.isGlobal = global;
    }

    @Override
    public boolean isOwner(class_1657 player) {
        return this.ownerUid == null || player.method_7334().getId().equals(this.ownerUid) || player.method_31549().field_7477;
    }

    @Override
    public void setOwnerUid(@Nullable UUID ownerUid) {
        this.ownerUid = ownerUid;
    }

    @Override
    public class_2338 getPos() {
        return this.pos;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public UUID getOwnerUid() {
        return this.ownerUid;
    }

    @Override
    public void setDimension(class_5321<class_1937> dimension) {
        this.dimension = dimension;
    }

    @Override
    public void setPos(class_2338 pos) {
        this.pos = pos;
    }

    @Override
    public class_2960 getWaystoneType() {
        return this.waystoneType;
    }

    @Override
    public boolean isValidInLevel(class_3218 level) {
        class_2680 state = level.method_8320(this.pos);
        return state.method_26164(ModTags.IS_TELEPORT_TARGET);
    }

    @Override
    public TeleportDestination resolveDestination(class_3218 level) {
        class_2680 state = level.method_8320(this.pos);
        class_2350 direction = (class_2350)state.method_11654((class_2769)WaystoneBlock.FACING);
        ArrayList directionCandidates = Lists.newArrayList((Object[])new class_2350[]{direction, class_2350.field_11034, class_2350.field_11039, class_2350.field_11035, class_2350.field_11043});
        for (class_2350 candidate : directionCandidates) {
            class_2338 offsetPos = this.pos.method_10093(candidate);
            class_2338 offsetPosUp = offsetPos.method_10084();
            if (level.method_8320(offsetPos).method_26228((class_1922)level, offsetPos) || level.method_8320(offsetPosUp).method_26228((class_1922)level, offsetPosUp)) continue;
            direction = candidate;
            break;
        }
        class_2338 targetPos = this.getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE) ? this.getPos() : this.getPos().method_10093(direction);
        class_243 location = new class_243((double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.5, (double)targetPos.method_10260() + 0.5);
        return new TeleportDestination(level, location, direction);
    }

    public static IWaystone read(class_2540 buf) {
        UUID waystoneUid = buf.method_10790();
        class_2960 waystoneType = buf.method_10810();
        String name = buf.method_19772();
        boolean isGlobal = buf.readBoolean();
        class_5321 dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(buf.method_10800(250)));
        class_2338 pos = buf.method_10811();
        Waystone waystone = new Waystone(waystoneType, waystoneUid, (class_5321<class_1937>)dimension, pos, false, null);
        waystone.setName(name);
        waystone.setGlobal(isGlobal);
        return waystone;
    }

    public static IWaystone read(class_2487 compound) {
        UUID waystoneUid = class_2512.method_25930((class_2520)Objects.requireNonNull(compound.method_10580("WaystoneUid")));
        String name = compound.method_10558("Name");
        class_5321 dimensionType = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(compound.method_10558("World")));
        class_2338 pos = class_2512.method_10691((class_2487)compound.method_10562("BlockPos"));
        boolean wasGenerated = compound.method_10577("WasGenerated");
        UUID ownerUid = compound.method_10545("OwnerUid") ? class_2512.method_25930((class_2520)Objects.requireNonNull(compound.method_10580("OwnerUid"))) : null;
        class_2960 waystoneType = compound.method_10545("Type") ? new class_2960(compound.method_10558("Type")) : WaystoneTypes.WAYSTONE;
        Waystone waystone = new Waystone(waystoneType, waystoneUid, (class_5321<class_1937>)dimensionType, pos, wasGenerated, ownerUid);
        waystone.setName(name);
        waystone.setGlobal(compound.method_10577("IsGlobal"));
        return waystone;
    }

    public static void write(class_2540 buf, IWaystone waystone) {
        buf.method_10797(waystone.getWaystoneUid());
        buf.method_10812(waystone.getWaystoneType());
        buf.method_10814(waystone.getName());
        buf.writeBoolean(waystone.isGlobal());
        buf.method_10812(waystone.getDimension().method_29177());
        buf.method_10807(waystone.getPos());
    }

    public static class_2487 write(IWaystone waystone, class_2487 compound) {
        compound.method_10566("WaystoneUid", (class_2520)class_2512.method_25929((UUID)waystone.getWaystoneUid()));
        compound.method_10582("Type", waystone.getWaystoneType().toString());
        compound.method_10582("Name", waystone.getName());
        compound.method_10582("World", waystone.getDimension().method_29177().toString());
        compound.method_10566("BlockPos", (class_2520)class_2512.method_10692((class_2338)waystone.getPos()));
        compound.method_10556("WasGenerated", waystone.wasGenerated());
        if (waystone.getOwnerUid() != null) {
            compound.method_10566("OwnerUid", (class_2520)class_2512.method_25929((UUID)waystone.getOwnerUid()));
        }
        compound.method_10556("IsGlobal", waystone.isGlobal());
        return compound;
    }
}

