/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.UUID;
import net.blay09.mods.waystones.api.IMutableWaystone;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.TeleportDestination;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class WaystoneProxy
implements IWaystone,
IMutableWaystone {
    private final MinecraftServer server;
    private final UUID waystoneUid;
    private IWaystone backingWaystone;

    public WaystoneProxy(@Nullable MinecraftServer server, UUID waystoneUid) {
        this.server = server;
        this.waystoneUid = waystoneUid;
    }

    @Override
    public boolean isValidInLevel(class_3218 level) {
        return this.getBackingWaystone().isValidInLevel(level);
    }

    @Override
    public TeleportDestination resolveDestination(class_3218 level) {
        return this.getBackingWaystone().resolveDestination(level);
    }

    @Override
    public boolean isValid() {
        return WaystoneManager.get(this.server).getWaystoneById(this.waystoneUid).isPresent();
    }

    public IWaystone getBackingWaystone() {
        if (this.backingWaystone == null) {
            this.backingWaystone = WaystoneManager.get(this.server).getWaystoneById(this.waystoneUid).orElse(InvalidWaystone.INSTANCE);
        }
        return this.backingWaystone;
    }

    @Override
    public UUID getOwnerUid() {
        return this.getBackingWaystone().getOwnerUid();
    }

    @Override
    public UUID getWaystoneUid() {
        return this.waystoneUid;
    }

    @Override
    public String getName() {
        return this.getBackingWaystone().getName();
    }

    @Override
    public class_5321<class_1937> getDimension() {
        return this.getBackingWaystone().getDimension();
    }

    @Override
    public boolean wasGenerated() {
        return this.getBackingWaystone().wasGenerated();
    }

    @Override
    public boolean isGlobal() {
        return this.getBackingWaystone().isGlobal();
    }

    @Override
    public boolean isOwner(class_1657 player) {
        return this.getBackingWaystone().isOwner(player);
    }

    @Override
    public class_2338 getPos() {
        return this.getBackingWaystone().getPos();
    }

    @Override
    public class_2960 getWaystoneType() {
        return this.getBackingWaystone().getWaystoneType();
    }

    @Override
    public void setName(String name) {
        IWaystone backingWaystone = this.getBackingWaystone();
        if (backingWaystone instanceof IMutableWaystone) {
            ((IMutableWaystone)((Object)backingWaystone)).setName(name);
        }
    }

    @Override
    public void setGlobal(boolean global) {
        IWaystone backingWaystone = this.getBackingWaystone();
        if (backingWaystone instanceof IMutableWaystone) {
            ((IMutableWaystone)((Object)backingWaystone)).setGlobal(global);
        }
    }

    @Override
    public void setDimension(class_5321<class_1937> dimension) {
        IWaystone backingWaystone = this.getBackingWaystone();
        if (backingWaystone instanceof IMutableWaystone) {
            ((IMutableWaystone)((Object)backingWaystone)).setDimension(dimension);
        }
    }

    @Override
    public void setPos(class_2338 pos) {
        IWaystone backingWaystone = this.getBackingWaystone();
        if (backingWaystone instanceof IMutableWaystone) {
            ((IMutableWaystone)((Object)backingWaystone)).setPos(pos);
        }
    }

    @Override
    public void setOwnerUid(UUID ownerUid) {
        IWaystone backingWaystone = this.getBackingWaystone();
        if (backingWaystone instanceof IMutableWaystone) {
            ((IMutableWaystone)((Object)backingWaystone)).setOwnerUid(ownerUid);
        }
    }
}

