/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.event.server.ServerReloadedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.api.world.BiomePredicate;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WorldGenStyle;
import net.blay09.mods.waystones.mixin.StructureTemplatePoolAccessor;
import net.blay09.mods.waystones.worldgen.WaystoneFeature;
import net.blay09.mods.waystones.worldgen.WaystonePlacement;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5188;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5497;
import net.minecraft.class_6798;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7924;

public class ModWorldGen {
    private static final class_2960 waystone = new class_2960("waystones", "waystone");
    private static final class_2960 mossyWaystone = new class_2960("waystones", "mossy_waystone");
    private static final class_2960 sandyWaystone = new class_2960("waystones", "sandy_waystone");
    private static final class_2960 villageWaystoneStructure = new class_2960("waystones", "village/common/waystone");
    private static final class_2960 desertVillageWaystoneStructure = new class_2960("waystones", "village/desert/waystone");
    private static final class_5321<class_5497> EMPTY_PROCESSOR_LIST_KEY = class_5321.method_29179((class_5321)class_7924.field_41247, (class_2960)new class_2960("minecraft", "empty"));
    public static DeferredObject<class_6798<WaystonePlacement>> waystonePlacement;

    public static void initialize(BalmWorldGen worldGen) {
        worldGen.registerFeature(waystone, () -> new WaystoneFeature((Codec<class_3111>)class_3111.field_24893, ModBlocks.waystone.method_9564()));
        worldGen.registerFeature(mossyWaystone, () -> new WaystoneFeature((Codec<class_3111>)class_3111.field_24893, ModBlocks.mossyWaystone.method_9564()));
        worldGen.registerFeature(sandyWaystone, () -> new WaystoneFeature((Codec<class_3111>)class_3111.field_24893, ModBlocks.sandyWaystone.method_9564()));
        waystonePlacement = worldGen.registerPlacementModifier(ModWorldGen.id("waystone"), () -> () -> WaystonePlacement.CODEC);
        class_6862 IS_DESERT = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("waystones", "is_desert"));
        class_6862 IS_SWAMP = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("waystones", "is_swamp"));
        class_6862 IS_MUSHROOM = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("waystones", "is_mushroom"));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((class_6862<class_1959>)IS_DESERT), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.SANDY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((class_6862<class_1959>)class_6908.field_36516), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((class_6862<class_1959>)IS_SWAMP), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((class_6862<class_1959>)IS_MUSHROOM), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesNeitherTag(List.of(IS_SWAMP, IS_DESERT, class_6908.field_36516, IS_MUSHROOM)), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.DEFAULT));
        Balm.getEvents().onEvent(ServerStartedEvent.class, event -> ModWorldGen.setupDynamicRegistries((class_5455)event.getServer().method_30611()));
        Balm.getEvents().onEvent(ServerReloadedEvent.class, event -> ModWorldGen.setupDynamicRegistries((class_5455)event.getServer().method_30611()));
    }

    private static BiomePredicate matchesTag(class_6862<class_1959> tag) {
        return (resourceLocation, biome) -> biome.method_40220(tag);
    }

    private static BiomePredicate matchesNeitherTag(List<class_6862<class_1959>> tags) {
        return (resourceLocation, biome) -> {
            for (class_6862 tag : tags) {
                if (!biome.method_40220(tag)) continue;
                return false;
            }
            return true;
        };
    }

    private static class_2960 id(String name) {
        return new class_2960("waystones", name);
    }

    private static class_2960 getWaystoneFeature(WorldGenStyle biomeWorldGenStyle) {
        WorldGenStyle worldGenStyle = WaystonesConfig.getActive().worldGenStyle();
        return switch (worldGenStyle) {
            case WorldGenStyle.MOSSY -> mossyWaystone;
            case WorldGenStyle.SANDY -> sandyWaystone;
            case WorldGenStyle.BIOME -> {
                switch (biomeWorldGenStyle) {
                    case SANDY: {
                        yield sandyWaystone;
                    }
                    case MOSSY: {
                        yield mossyWaystone;
                    }
                }
                yield waystone;
            }
            default -> waystone;
        };
    }

    public static void setupDynamicRegistries(class_5455 registryAccess) {
        if (WaystonesConfig.getActive().spawnInVillages() || WaystonesConfig.getActive().forceSpawnInVillages()) {
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/plains/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/snowy/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/savanna/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/desert/houses", desertVillageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/taiga/houses", villageWaystoneStructure, 1);
        }
    }

    private static void addWaystoneStructureToVillageConfig(class_5455 registryAccess, String villagePiece, class_2960 waystoneStructure, int weight) {
        class_6880.class_6883 emptyProcessorList = registryAccess.method_30530(class_7924.field_41247).method_40290(EMPTY_PROCESSOR_LIST_KEY);
        class_5188 piece = (class_5188)class_3784.method_30426((String)waystoneStructure.toString(), (class_6880)emptyProcessorList).apply(class_3785.class_3786.field_16687);
        class_3785 pool = registryAccess.method_30530(class_7924.field_41249).method_17966(new class_2960(villagePiece)).orElse(null);
        if (pool != null) {
            StructureTemplatePoolAccessor poolAccessor = (StructureTemplatePoolAccessor)pool;
            ObjectArrayList listOfPieces = new ObjectArrayList(poolAccessor.getTemplates());
            for (int i = 0; i < weight; ++i) {
                listOfPieces.add((Object)piece);
            }
            poolAccessor.setTemplates((ObjectArrayList<class_3784>)listOfPieces);
            ArrayList<Pair<class_3784, Integer>> listOfWeightedPieces = new ArrayList<Pair<class_3784, Integer>>(poolAccessor.getRawTemplates());
            listOfWeightedPieces.add((Pair<class_3784, Integer>)new Pair((Object)piece, (Object)weight));
            poolAccessor.setRawTemplates(listOfWeightedPieces);
        }
    }
}

