/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IAttunementItem;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.IWaystoneTeleportContext;
import net.blay09.mods.waystones.api.InternalMethods;
import net.blay09.mods.waystones.api.WaystoneStyle;
import net.blay09.mods.waystones.api.WaystoneTeleportError;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WaystonesConfigData;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneTeleportContext;
import net.blay09.mods.waystones.core.WaystoneTeleportManager;
import net.blay09.mods.waystones.item.ModItems;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class InternalMethodsImpl
implements InternalMethods {
    @Override
    public Either<IWaystoneTeleportContext, WaystoneTeleportError> createDefaultTeleportContext(class_1297 entity, IWaystone waystone, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        return WaystonesAPI.createCustomTeleportContext(entity, waystone).ifLeft(context -> {
            context.setWarpMode(warpMode);
            WaystonesConfigData.TransportPets shouldTransportPets = WaystonesConfig.getActive().restrictions.transportPets;
            if (shouldTransportPets == WaystonesConfigData.TransportPets.ENABLED || shouldTransportPets == WaystonesConfigData.TransportPets.SAME_DIMENSION && !context.isDimensionalTeleport()) {
                context.getAdditionalEntities().addAll(WaystoneTeleportManager.findPets(entity));
            }
            context.getLeashedEntities().addAll(WaystoneTeleportManager.findLeashedAnimals(entity));
            context.setFromWaystone(fromWaystone);
            context.setWarpItem(PlayerWaystoneManager.findWarpItem(entity, warpMode));
            context.setCooldown(PlayerWaystoneManager.getCooldownPeriod(warpMode, waystone));
            context.setExperienceCost(WaystoneTeleportManager.getExperienceLevelCost(context));
        });
    }

    @Override
    public Either<IWaystoneTeleportContext, WaystoneTeleportError> createCustomTeleportContext(class_1297 entity, IWaystone waystone) {
        if (!waystone.isValid()) {
            return Either.right((Object)new WaystoneTeleportError.InvalidWaystone(waystone));
        }
        MinecraftServer server = entity.method_5682();
        if (server == null) {
            return Either.right((Object)new WaystoneTeleportError.NotOnServer());
        }
        class_3218 targetLevel = server.method_3847(waystone.getDimension());
        if (targetLevel == null) {
            return Either.right((Object)new WaystoneTeleportError.InvalidDimension(waystone.getDimension()));
        }
        if (!waystone.isValidInLevel(targetLevel)) {
            return Either.right((Object)new WaystoneTeleportError.MissingWaystone(waystone));
        }
        return Either.left((Object)new WaystoneTeleportContext(entity, waystone, waystone.resolveDestination(targetLevel)));
    }

    @Override
    public Either<List<class_1297>, WaystoneTeleportError> tryTeleportToWaystone(class_1297 entity, IWaystone waystone, WarpMode warpMode, IWaystone fromWaystone) {
        return WaystoneTeleportManager.tryTeleportToWaystone(entity, waystone, warpMode, fromWaystone);
    }

    @Override
    public Either<List<class_1297>, WaystoneTeleportError> tryTeleport(IWaystoneTeleportContext context) {
        return WaystoneTeleportManager.tryTeleport(context);
    }

    @Override
    public Either<List<class_1297>, WaystoneTeleportError> forceTeleportToWaystone(class_1297 entity, IWaystone waystone) {
        return this.createDefaultTeleportContext(entity, waystone, WarpMode.CUSTOM, null).mapLeft(this::forceTeleport);
    }

    @Override
    public List<class_1297> forceTeleport(IWaystoneTeleportContext context) {
        return WaystoneTeleportManager.doTeleport(context);
    }

    @Override
    public Optional<IWaystone> getWaystoneAt(class_1937 level, class_2338 pos) {
        return WaystoneManager.get(level.method_8503()).getWaystoneAt((class_1922)level, pos);
    }

    @Override
    public Optional<IWaystone> getWaystone(class_1937 level, UUID uuid) {
        return WaystoneManager.get(level.method_8503()).getWaystoneById(uuid);
    }

    @Override
    public class_1799 createAttunedShard(IWaystone warpPlate) {
        class_1799 itemStack = new class_1799((class_1935)ModItems.attunedShard);
        this.setBoundWaystone(itemStack, warpPlate);
        return itemStack;
    }

    @Override
    public class_1799 createBoundScroll(IWaystone waystone) {
        class_1799 itemStack = new class_1799((class_1935)ModItems.boundScroll);
        this.setBoundWaystone(itemStack, waystone);
        return itemStack;
    }

    @Override
    public Optional<IWaystone> placeWaystone(class_1937 level, class_2338 pos, WaystoneStyle style) {
        class_2248 block = Balm.getRegistries().getBlock(style.getBlockRegistryName());
        level.method_8652(pos, (class_2680)block.method_9564().method_11657((class_2769)WaystoneBlock.HALF, (Comparable)class_2756.field_12607), 3);
        level.method_8652(pos.method_10084(), (class_2680)block.method_9564().method_11657((class_2769)WaystoneBlock.HALF, (Comparable)class_2756.field_12609), 3);
        return this.getWaystoneAt(level, pos);
    }

    @Override
    public Optional<IWaystone> placeSharestone(class_1937 level, class_2338 pos, @Nullable class_1767 color) {
        class_2248 sharestone = color != null ? ModBlocks.scopedSharestones[color.ordinal()] : ModBlocks.sharestone;
        level.method_8652(pos, (class_2680)sharestone.method_9564().method_11657((class_2769)WaystoneBlock.HALF, (Comparable)class_2756.field_12607), 3);
        level.method_8652(pos.method_10084(), (class_2680)sharestone.method_9564().method_11657((class_2769)WaystoneBlock.HALF, (Comparable)class_2756.field_12609), 3);
        return this.getWaystoneAt(level, pos);
    }

    @Override
    public Optional<IWaystone> placeWarpPlate(class_1937 level, class_2338 pos) {
        level.method_8652(pos, ModBlocks.warpPlate.method_9564(), 3);
        return this.getWaystoneAt(level, pos);
    }

    @Override
    public Optional<IWaystone> getBoundWaystone(class_1799 itemStack) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof IAttunementItem) {
            IAttunementItem attunementItem = (IAttunementItem)class_17922;
            return Optional.ofNullable(attunementItem.getWaystoneAttunedTo(Balm.getHooks().getServer(), itemStack));
        }
        return Optional.empty();
    }

    @Override
    public void setBoundWaystone(class_1799 itemStack, @Nullable IWaystone waystone) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof IAttunementItem) {
            IAttunementItem attunementItem = (IAttunementItem)class_17922;
            attunementItem.setWaystoneAttunedTo(itemStack, waystone);
        }
    }
}

