/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.tag.ModItemTags;
import net.minecraft.class_10;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class WaystoneBlock
extends WaystoneBlockBase {
    private static final class_265 LOWER_SHAPE = class_259.method_17786((class_265)WaystoneBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (class_265[])new class_265[]{WaystoneBlock.method_9541((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), WaystoneBlock.method_9541((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), WaystoneBlock.method_9541((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)}).method_1097();
    private static final class_265 UPPER_SHAPE = class_259.method_17786((class_265)WaystoneBlock.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), (class_265[])new class_265[]{WaystoneBlock.method_9541((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), WaystoneBlock.method_9541((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0), WaystoneBlock.method_9541((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), WaystoneBlock.method_9541((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)}).method_1097();

    public WaystoneBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)HALF, (Comparable)class_2756.field_12607)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean canSilkTouch() {
        return true;
    }

    public class_265 method_9530(class_2680 state, class_1922 blockGetter, class_2338 pos, class_3726 context) {
        return state.method_11654((class_2769)HALF) == class_2756.field_12609 ? UPPER_SHAPE : LOWER_SHAPE;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new WaystoneBlockEntity(pos, state);
    }

    @Override
    protected class_1269 handleActivation(class_1937 world, class_2338 pos, class_1657 player, WaystoneBlockEntityBase tileEntity, IWaystone waystone) {
        if (player.method_6047().method_31573(ModItemTags.BOUND_SCROLLS)) {
            return class_1269.field_5811;
        }
        boolean isActivated = PlayerWaystoneManager.isWaystoneActivated(player, waystone);
        if (isActivated) {
            if (!world.field_9236) {
                if (WaystonesConfig.getActive().restrictions.allowWaystoneToWaystoneTeleport) {
                    Balm.getNetworking().openGui(player, tileEntity.getMenuProvider());
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"chat.waystones.waystone_to_waystone_disabled"), true);
                }
            }
        } else {
            PlayerWaystoneManager.activateWaystone(player, waystone);
            if (!world.field_9236) {
                class_5250 nameComponent = class_2561.method_43470((String)waystone.getName());
                nameComponent.method_27692(class_124.field_1068);
                class_5250 chatComponent = class_2561.method_43469((String)"chat.waystones.waystone_activated", (Object[])new Object[]{nameComponent});
                chatComponent.method_27692(class_124.field_1054);
                player.method_43496((class_2561)chatComponent);
                WaystoneSyncManager.sendActivatedWaystones(player);
                world.method_8396(null, pos, class_3417.field_14709, class_3419.field_15245, 0.2f, 1.0f);
            }
            this.notifyObserversOfAction(world, pos);
            if (world.field_9236) {
                for (int i = 0; i < 32; ++i) {
                    world.method_8406((class_2394)class_2398.field_11215, (double)pos.method_10263() + 0.5 + (world.field_9229.method_43058() - 0.5) * 2.0, (double)(pos.method_10264() + 3), (double)pos.method_10260() + 0.5 + (world.field_9229.method_43058() - 0.5) * 2.0, 0.0, -5.0, 0.0);
                    world.method_8406((class_2394)class_2398.field_11215, (double)pos.method_10263() + 0.5 + (world.field_9229.method_43058() - 0.5) * 2.0, (double)(pos.method_10264() + 4), (double)pos.method_10260() + 0.5 + (world.field_9229.method_43058() - 0.5) * 2.0, 0.0, -5.0, 0.0);
                }
            }
        }
        return class_1269.field_5812;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (random.method_43057() < 0.75f) {
            class_2586 blockEntity = world.method_8321(pos);
            class_746 player = class_310.method_1551().field_1724;
            if (blockEntity instanceof WaystoneBlockEntity && PlayerWaystoneManager.isWaystoneActivated((class_1657)Objects.requireNonNull(player), ((WaystoneBlockEntity)blockEntity).getWaystone())) {
                world.method_8406((class_2394)class_2398.field_11214, (double)pos.method_10263() + 0.5 + (random.method_43058() - 0.5) * 1.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5 + (random.method_43058() - 0.5) * 1.5, 0.0, 0.0, 0.0);
                world.method_8406((class_2394)class_2398.field_11215, (double)pos.method_10263() + 0.5 + (random.method_43058() - 0.5) * 1.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5 + (random.method_43058() - 0.5) * 1.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{HALF});
    }

    public boolean method_9516(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_10 pathComputationType) {
        return false;
    }

    @Override
    public class_2591<? extends WaystoneBlockEntityBase> getTickingBlockEntityType() {
        return (class_2591)ModBlockEntities.waystone.get();
    }
}

