/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.client.screen.ScreenDrawEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent;
import net.blay09.mods.waystones.api.ExperienceCost;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.client.gui.screen.InventoryButtonReturnConfirmScreen;
import net.blay09.mods.waystones.client.gui.widget.WaystoneInventoryButton;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneTeleportManager;
import net.blay09.mods.waystones.network.message.InventoryButtonMessage;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_746;

public class InventoryButtonGuiHandler {
    private static WaystoneInventoryButton warpButton;

    public static void initialize() {
        Balm.getEvents().onEvent(ScreenInitEvent.Post.class, event -> {
            class_437 screen = event.getScreen();
            if (!(screen instanceof class_490) && !(screen instanceof class_481)) {
                return;
            }
            class_310 mc = class_310.method_1551();
            if (screen != mc.field_1755) {
                return;
            }
            InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
            if (!inventoryButtonMode.isEnabled()) {
                return;
            }
            Supplier<Integer> xPosition = screen instanceof class_481 ? () -> WaystonesConfig.getActive().inventoryButton.creativeWarpButtonX : () -> WaystonesConfig.getActive().inventoryButton.warpButtonX;
            Supplier<Integer> yPosition = screen instanceof class_481 ? () -> WaystonesConfig.getActive().inventoryButton.creativeWarpButtonY : () -> WaystonesConfig.getActive().inventoryButton.warpButtonY;
            warpButton = new WaystoneInventoryButton((class_465)screen, button -> {
                class_746 player = mc.field_1724;
                if (player.method_31549().field_7477) {
                    PlayerWaystoneManager.setInventoryButtonCooldownUntil((class_1657)player, 0L);
                }
                if (PlayerWaystoneManager.canUseInventoryButton((class_1657)player)) {
                    if (inventoryButtonMode.hasNamedTarget()) {
                        mc.method_1507((class_437)new InventoryButtonReturnConfirmScreen(inventoryButtonMode.getNamedTarget()));
                    } else if (inventoryButtonMode.isReturnToNearest()) {
                        if (PlayerWaystoneManager.getNearestWaystone((class_1657)player) != null) {
                            mc.method_1507((class_437)new InventoryButtonReturnConfirmScreen());
                        }
                    } else if (inventoryButtonMode.isReturnToAny()) {
                        Balm.getNetworking().sendToServer((Object)new InventoryButtonMessage());
                    }
                } else {
                    mc.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)0.5f));
                }
            }, () -> {
                if (screen instanceof class_481) {
                    class_481 creativeModeInventoryScreen = (class_481)screen;
                    return creativeModeInventoryScreen.method_47424();
                }
                return true;
            }, xPosition, yPosition);
            BalmClient.getScreens().addRenderableWidget(screen, (class_339)warpButton);
        });
        Balm.getEvents().onEvent(ScreenDrawEvent.Post.class, event -> {
            class_437 screen = event.getScreen();
            class_332 guiGraphics = event.getGuiGraphics();
            int mouseX = event.getMouseX();
            int mouseY = event.getMouseY();
            if ((screen instanceof class_490 || screen instanceof class_481) && warpButton != null && warpButton.method_25367()) {
                InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
                ArrayList<Object> tooltip = new ArrayList<Object>();
                class_746 player = class_310.method_1551().field_1724;
                if (player == null) {
                    return;
                }
                long timeLeft = PlayerWaystoneManager.getInventoryButtonCooldownLeft((class_1657)player);
                IWaystone waystone = PlayerWaystoneManager.getInventoryButtonTarget((class_1657)player);
                ExperienceCost xpCost = waystone != null ? WaystoneTeleportManager.predictExperienceLevelCost((class_1297)player, waystone, WarpMode.INVENTORY_BUTTON, null) : ExperienceCost.NoExperienceCost.INSTANCE;
                int secondsLeft = (int)(timeLeft / 1000L);
                if (inventoryButtonMode.hasNamedTarget()) {
                    tooltip.add(InventoryButtonGuiHandler.formatTranslation(class_124.field_1054, "gui.waystones.inventory.return_to_waystone", new Object[0]));
                    tooltip.add(InventoryButtonGuiHandler.formatTranslation(class_124.field_1080, "tooltip.waystones.bound_to", class_124.field_1062 + inventoryButtonMode.getNamedTarget()));
                    if (secondsLeft > 0) {
                        tooltip.add(class_2561.method_43473());
                    }
                } else if (inventoryButtonMode.isReturnToNearest()) {
                    tooltip.add(InventoryButtonGuiHandler.formatTranslation(class_124.field_1054, "gui.waystones.inventory.return_to_nearest_waystone", new Object[0]));
                    IWaystone nearestWaystone = PlayerWaystoneManager.getNearestWaystone((class_1657)player);
                    if (nearestWaystone != null) {
                        tooltip.add(InventoryButtonGuiHandler.formatTranslation(class_124.field_1080, "tooltip.waystones.bound_to", class_124.field_1062 + nearestWaystone.getName()));
                    } else {
                        tooltip.add(InventoryButtonGuiHandler.formatTranslation(class_124.field_1061, "gui.waystones.inventory.no_waystones_activated", new Object[0]));
                    }
                    if (secondsLeft > 0) {
                        tooltip.add(class_2561.method_43473());
                    }
                } else if (inventoryButtonMode.isReturnToAny()) {
                    tooltip.add(InventoryButtonGuiHandler.formatTranslation(class_124.field_1054, "gui.waystones.inventory.return_to_waystone", new Object[0]));
                    if (PlayerWaystoneManager.getActivatedWaystones((class_1657)player).isEmpty()) {
                        tooltip.add(InventoryButtonGuiHandler.formatTranslation(class_124.field_1061, "gui.waystones.inventory.no_waystones_activated", new Object[0]));
                    }
                }
                if (!xpCost.canAfford((class_1657)player)) {
                    tooltip.add(InventoryButtonGuiHandler.formatTranslation(class_124.field_1061, "tooltip.waystones.not_enough_xp", xpCost));
                }
                if (secondsLeft > 0) {
                    tooltip.add(InventoryButtonGuiHandler.formatTranslation(class_124.field_1065, "tooltip.waystones.cooldown_left", secondsLeft));
                }
                guiGraphics.method_51437(class_310.method_1551().field_1772, tooltip, Optional.empty(), mouseX, mouseY);
            }
        });
    }

    private static class_2561 formatTranslation(class_124 formatting, String key, Object ... args) {
        class_5250 result = class_2561.method_43469((String)key, (Object[])args);
        result.method_27692(formatting);
        return result;
    }
}

