/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.mixin.ScreenAccessor;
import net.blay09.mods.waystones.api.ExperienceCost;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.client.gui.widget.ITooltipProvider;
import net.blay09.mods.waystones.client.gui.widget.RemoveWaystoneButton;
import net.blay09.mods.waystones.client.gui.widget.SortWaystoneButton;
import net.blay09.mods.waystones.client.gui.widget.WaystoneButton;
import net.blay09.mods.waystones.comparator.UserSortingComparator;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneTeleportManager;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.blay09.mods.waystones.network.message.RemoveWaystoneMessage;
import net.blay09.mods.waystones.network.message.RequestEditWaystoneMessage;
import net.blay09.mods.waystones.network.message.SelectWaystoneMessage;
import net.blay09.mods.waystones.network.message.SortWaystoneMessage;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_746;

public abstract class WaystoneSelectionScreenBase
extends class_465<WaystoneSelectionMenu> {
    private final Collection<IWaystone> waystones;
    private List<IWaystone> filteredWaystones;
    private final List<ITooltipProvider> tooltipProviders = new ArrayList<ITooltipProvider>();
    private String searchText = "";
    private class_4185 btnPrevPage;
    private class_4185 btnNextPage;
    private class_342 searchBox;
    private int pageOffset;
    private int headerY;
    private boolean isLocationHeaderHovered;
    private int buttonsPerPage;
    private static final int headerHeight = 64;
    private static final int footerHeight = 25;
    private static final int entryHeight = 25;

    public WaystoneSelectionScreenBase(WaystoneSelectionMenu container, class_1661 playerInventory, class_2561 title) {
        super((class_1703)container, playerInventory, title);
        this.waystones = container.getWaystones();
        PlayerWaystoneManager.ensureSortingIndex((class_1657)class_310.method_1551().field_1724, this.waystones);
        this.filteredWaystones = new ArrayList<IWaystone>(this.waystones);
        Comparator<IWaystone> sorting = this.getSorting();
        if (sorting != null) {
            this.filteredWaystones.sort(this.getSorting());
        }
        this.field_2792 = 270;
        this.field_2779 = 200;
    }

    public void method_25426() {
        int maxContentHeight = (int)((float)this.field_22790 * 0.6f);
        int maxButtonsPerPage = (maxContentHeight - 64 - 25) / 25;
        this.buttonsPerPage = Math.max(4, Math.min(maxButtonsPerPage, this.waystones.size()));
        int contentHeight = 64 + this.buttonsPerPage * 25 + 25;
        this.field_2792 = this.field_22789;
        this.field_2779 = contentHeight;
        super.method_25426();
        this.tooltipProviders.clear();
        this.btnPrevPage = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.waystones.waystone_selection.previous_page"), button -> {
            this.pageOffset = class_437.method_25442() ? 0 : this.pageOffset - 1;
            this.updateList();
        }).method_46433(this.field_22789 / 2 - 100, this.field_22790 / 2 + 40).method_46437(95, 20).method_46431();
        this.method_37063(this.btnPrevPage);
        this.btnNextPage = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.waystones.waystone_selection.next_page"), button -> {
            this.pageOffset = class_437.method_25442() ? (this.waystones.size() - 1) / this.buttonsPerPage : this.pageOffset + 1;
            this.updateList();
        }).method_46433(this.field_22789 / 2 + 5, this.field_22790 / 2 + 40).method_46437(95, 20).method_46431();
        this.method_37063(this.btnNextPage);
        this.updateList();
        this.searchBox = new class_342(this.field_22793, this.field_22789 / 2 - 99, this.field_2800 + 64 - 24, 198, 20, (class_2561)class_2561.method_43473());
        this.searchBox.method_1863(text -> {
            this.pageOffset = 0;
            this.searchText = text;
            this.updateList();
        });
        this.method_37063(this.searchBox);
    }

    protected <T extends class_364 & class_4068> T method_37063(T widget) {
        if (widget instanceof ITooltipProvider) {
            this.tooltipProviders.add((ITooltipProvider)widget);
        }
        return (T)super.method_37063(widget);
    }

    private void updateList() {
        ArrayList<IWaystone> list = new ArrayList<IWaystone>();
        for (IWaystone iWaystone : this.waystones) {
            if (!iWaystone.getName().toLowerCase().contains(this.searchText.toLowerCase())) continue;
            list.add(iWaystone);
        }
        Comparator<IWaystone> sorting = this.getSorting();
        if (sorting != null) {
            list.sort(sorting);
        }
        this.filteredWaystones = list;
        this.headerY = 0;
        this.btnPrevPage.field_22763 = this.pageOffset > 0;
        this.btnNextPage.field_22763 = this.pageOffset < (this.filteredWaystones.size() - 1) / this.buttonsPerPage;
        this.tooltipProviders.clear();
        Predicate<Object> removePredicate = button -> button instanceof WaystoneButton || button instanceof SortWaystoneButton || button instanceof RemoveWaystoneButton;
        ((ScreenAccessor)this).balm_getChildren().removeIf(removePredicate);
        ((ScreenAccessor)this).balm_getNarratables().removeIf(removePredicate);
        ((ScreenAccessor)this).balm_getRenderables().removeIf(removePredicate);
        int y = this.field_2800 + 64 + this.headerY;
        for (int i = 0; i < this.buttonsPerPage; ++i) {
            int entryIndex = this.pageOffset * this.buttonsPerPage + i;
            if (entryIndex < 0 || entryIndex >= this.filteredWaystones.size()) continue;
            IWaystone waystone = this.filteredWaystones.get(entryIndex);
            this.method_37063(this.createWaystoneButton(y, waystone));
            if (this.allowSorting()) {
                SortWaystoneButton sortUpButton = new SortWaystoneButton(this.field_22789 / 2 + 108, y + 2, -1, y, 20, it -> this.sortWaystone(waystone, -1));
                if (entryIndex == 0) {
                    sortUpButton.field_22763 = false;
                }
                this.method_37063(sortUpButton);
                SortWaystoneButton sortDownButton = new SortWaystoneButton(this.field_22789 / 2 + 108, y + 13, 1, y, 20, it -> this.sortWaystone(waystone, 1));
                if (entryIndex == this.filteredWaystones.size() - 1) {
                    sortDownButton.field_22763 = false;
                }
                this.method_37063(sortDownButton);
            }
            if (this.allowDeletion(waystone)) {
                RemoveWaystoneButton removeButton = new RemoveWaystoneButton(this.field_22789 / 2 + 122, y + 4, y, 20, waystone, button -> {
                    class_746 player = class_310.method_1551().field_1724;
                    PlayerWaystoneManager.deactivateWaystone((class_1657)Objects.requireNonNull(player), waystone);
                    this.waystones.remove(waystone);
                    Balm.getNetworking().sendToServer((Object)new RemoveWaystoneMessage(waystone.getWaystoneUid()));
                    this.updateList();
                });
                this.method_37063(removeButton);
            }
            y += 22;
        }
        this.btnPrevPage.method_46419(this.field_2800 + this.headerY + 64 + this.buttonsPerPage * 22 + (this.filteredWaystones.size() > 0 ? 10 : 0));
        this.btnNextPage.method_46419(this.field_2800 + this.headerY + 64 + this.buttonsPerPage * 22 + (this.filteredWaystones.size() > 0 ? 10 : 0));
    }

    private boolean allowDeletion(IWaystone waystone) {
        if (waystone.getVisibility() == WaystoneVisibility.GLOBAL && !class_310.method_1551().field_1724.method_31549().field_7477) {
            return false;
        }
        if (!waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            return false;
        }
        return this.allowDeletion();
    }

    private WaystoneButton createWaystoneButton(int y, IWaystone waystone) {
        IWaystone waystoneFrom = ((WaystoneSelectionMenu)this.field_2797).getWaystoneFrom();
        class_746 player = class_310.method_1551().field_1724;
        ExperienceCost xpCost = WaystoneTeleportManager.predictExperienceLevelCost((class_1297)Objects.requireNonNull(player), waystone, ((WaystoneSelectionMenu)this.field_2797).getWarpMode(), waystoneFrom);
        WaystoneButton btnWaystone = new WaystoneButton(this.field_22789 / 2 - 100, y, waystone, xpCost, button -> this.onWaystoneSelected(waystone));
        if (waystoneFrom != null && waystone.getWaystoneUid().equals(waystoneFrom.getWaystoneUid())) {
            btnWaystone.field_22763 = false;
        }
        return btnWaystone;
    }

    protected void onWaystoneSelected(IWaystone waystone) {
        Balm.getNetworking().sendToServer((Object)new SelectWaystoneMessage(waystone.getWaystoneUid()));
    }

    private void sortWaystone(IWaystone waystone, int sortDir) {
        UUID waystoneUid = waystone.getWaystoneUid();
        if (class_437.method_25442()) {
            if (sortDir == -1) {
                PlayerWaystoneManager.sortWaystoneAsFirst((class_1657)class_310.method_1551().field_1724, waystoneUid);
                Balm.getNetworking().sendToServer((Object)new SortWaystoneMessage(waystoneUid, SortWaystoneMessage.SORT_FIRST));
            } else if (sortDir == 1) {
                PlayerWaystoneManager.sortWaystoneAsLast((class_1657)class_310.method_1551().field_1724, waystoneUid);
                Balm.getNetworking().sendToServer((Object)new SortWaystoneMessage(waystoneUid, SortWaystoneMessage.SORT_LAST));
            }
        } else {
            int index = this.filteredWaystones.indexOf(waystone);
            int otherIndex = index + sortDir;
            if (index == -1 || otherIndex < 0 || otherIndex >= this.waystones.size()) {
                return;
            }
            IWaystone otherWaystone = this.filteredWaystones.get(otherIndex);
            UUID otherWaystoneUid = otherWaystone.getWaystoneUid();
            PlayerWaystoneManager.sortWaystoneSwap((class_1657)class_310.method_1551().field_1724, waystoneUid, otherWaystoneUid);
            Balm.getNetworking().sendToServer((Object)new SortWaystoneMessage(waystoneUid, otherWaystoneUid));
        }
        this.updateList();
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.isLocationHeaderHovered && ((WaystoneSelectionMenu)this.field_2797).getWaystoneFrom() != null) {
            Balm.getNetworking().sendToServer((Object)new RequestEditWaystoneMessage(((WaystoneSelectionMenu)this.field_2797).getWaystoneFrom().getPos()));
            return true;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.method_2380(guiGraphics, mouseX, mouseY);
        for (ITooltipProvider tooltipProvider : this.tooltipProviders) {
            if (!tooltipProvider.shouldShowTooltip()) continue;
            guiGraphics.method_51437(class_310.method_1551().field_1772, tooltipProvider.getTooltipComponents(), Optional.empty(), mouseX, mouseY);
        }
    }

    protected void method_2389(class_332 guiGraphics, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        class_327 font = class_310.method_1551().field_1772;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IWaystone fromWaystone = ((WaystoneSelectionMenu)this.field_2797).getWaystoneFrom();
        guiGraphics.method_27534(font, this.method_25440(), this.field_2792 / 2, this.headerY + (fromWaystone != null ? 20 : 0), 0xFFFFFF);
        if (fromWaystone != null) {
            this.drawLocationHeader(guiGraphics, fromWaystone, mouseX, mouseY, this.field_2792 / 2, this.headerY);
        }
        if (this.waystones.size() == 0) {
            guiGraphics.method_25300(font, class_124.field_1061 + class_1074.method_4662((String)"gui.waystones.waystone_selection.no_waystones_activated", (Object[])new Object[0]), this.field_2792 / 2, this.field_2779 / 2 - 20, 0xFFFFFF);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawLocationHeader(class_332 guiGraphics, IWaystone waystone, int mouseX, int mouseY, int x, int y) {
        font = class_310.method_1551().field_1772;
        locationPrefix = class_124.field_1054 + class_1074.method_4662((String)"gui.waystones.waystone_selection.current_location", (Object[])new Object[0]) + " ";
        locationPrefixWidth = font.method_1727(locationPrefix);
        effectiveName = waystone.getName();
        if (effectiveName.isEmpty()) {
            effectiveName = class_1074.method_4662((String)"gui.waystones.waystone_selection.unnamed_waystone", (Object[])new Object[0]);
        }
        locationWidth = font.method_1727(effectiveName);
        fullWidth = locationPrefixWidth + locationWidth;
        startX = x - fullWidth / 2 + locationPrefixWidth;
        startY = y + this.field_2800;
        if (mouseX < startX || mouseX >= startX + locationWidth + 16 || mouseY < startY) ** GOTO lbl-1000
        Objects.requireNonNull(font);
        if (mouseY < startY + 9) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.isLocationHeaderHovered = v0;
        player = class_310.method_1551().field_1724;
        waystoneEditPermissions = WaystonePermissionManager.mayEditWaystone((class_1657)player, player.method_37908(), waystone);
        fullText = locationPrefix + class_124.field_1068;
        if (this.isLocationHeaderHovered && waystoneEditPermissions == WaystoneEditPermissions.ALLOW) {
            fullText = fullText + class_124.field_1073;
        }
        fullText = fullText + effectiveName;
        guiGraphics.method_25303(font, fullText, x - fullWidth / 2, y, 0xFFFFFF);
        if (this.isLocationHeaderHovered && waystoneEditPermissions == WaystoneEditPermissions.ALLOW) {
            poseStack = guiGraphics.method_51448();
            poseStack.method_22903();
            scale = 0.5f;
            poseStack.method_46416((float)x + (float)fullWidth / 2.0f + 4.0f, (float)y, 0.0f);
            poseStack.method_22905(scale, scale, scale);
            guiGraphics.method_51427(new class_1799((class_1935)class_1802.field_8674), 0, 0);
            poseStack.method_22909();
        }
    }

    protected boolean allowSorting() {
        return true;
    }

    protected boolean allowDeletion() {
        return true;
    }

    public boolean method_25404(int key, int scanCode, int modifiers) {
        if (!this.searchBox.method_25370() || key == 256 && this.method_25422()) {
            return super.method_25404(key, scanCode, modifiers);
        }
        return this.searchBox.method_25404(key, scanCode, modifiers);
    }

    public Comparator<IWaystone> getSorting() {
        class_746 player = class_310.method_1551().field_1724;
        List<UUID> sortingIndex = PlayerWaystoneManager.getSortingIndex((class_1657)player);
        return new UserSortingComparator(sortingIndex);
    }
}

