/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.waystones.api.ExperienceCost;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;

public class WaystoneButton
extends class_4185 {
    private static final class_2960[] ENABLED_LEVEL_SPRITES = new class_2960[]{new class_2960("container/enchanting_table/level_1"), new class_2960("container/enchanting_table/level_2"), new class_2960("container/enchanting_table/level_3")};
    private static final class_2960[] DISABLED_LEVEL_SPRITES = new class_2960[]{new class_2960("container/enchanting_table/level_1_disabled"), new class_2960("container/enchanting_table/level_2_disabled"), new class_2960("container/enchanting_table/level_3_disabled")};
    private final ExperienceCost xpCost;
    private final IWaystone waystone;

    public WaystoneButton(int x, int y, IWaystone waystone, ExperienceCost xpCost, class_4185.class_4241 pressable) {
        super(x, y, 200, 20, WaystoneButton.getWaystoneNameComponent(waystone), pressable, class_4185.field_40754);
        class_746 player = class_310.method_1551().field_1724;
        this.xpCost = xpCost;
        this.waystone = waystone;
        if (player == null || !PlayerWaystoneManager.mayTeleportToWaystone((class_1657)player, waystone)) {
            this.field_22763 = false;
        } else if (!xpCost.canAfford((class_1657)player) && !player.method_31549().field_7477) {
            this.field_22763 = false;
        }
    }

    private static class_2561 getWaystoneNameComponent(IWaystone waystone) {
        String effectiveName = waystone.getName();
        if (effectiveName.isEmpty()) {
            effectiveName = class_1074.method_4662((String)"gui.waystones.waystone_selection.unnamed_waystone", (Object[])new Object[0]);
        }
        class_5250 textComponent = class_2561.method_43470((String)effectiveName);
        if (waystone.getVisibility() == WaystoneVisibility.GLOBAL && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            textComponent.method_27692(class_124.field_1054);
        }
        return textComponent;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_310 mc = class_310.method_1551();
        if (this.waystone.getDimension() == mc.field_1724.method_37908().method_27983() && this.method_37303()) {
            int distance = (int)mc.field_1724.method_19538().method_1022(this.waystone.getPos().method_46558());
            String distanceStr = distance < 10000 && (mc.field_1772.method_27525((class_5348)this.method_25369()) < 120 || distance < 1000) ? distance + "m" : String.format("%.1f", Float.valueOf((float)distance / 1000.0f)).replace(",0", "").replace(".0", "") + "km";
            int xOffset = this.method_25368() - mc.field_1772.method_1727(distanceStr);
            guiGraphics.method_25303(mc.field_1772, distanceStr, this.method_46426() + xOffset - 4, this.method_46427() + 6, 0xFFFFFF);
        }
        if (!this.xpCost.isEmpty()) {
            boolean canAfford = this.xpCost.canAfford((class_1657)mc.field_1724);
            int xpCostAsLevels = this.xpCost.getCostAsLevels((class_1657)mc.field_1724);
            int spriteIndex = Math.max(0, Math.min(xpCostAsLevels, 3) - 1);
            guiGraphics.method_52706(canAfford ? ENABLED_LEVEL_SPRITES[spriteIndex] : DISABLED_LEVEL_SPRITES[spriteIndex], this.method_46426() + 2, this.method_46427() + 2, 16, 16);
            if (xpCostAsLevels > 3) {
                guiGraphics.method_25303(mc.field_1772, "+", this.method_46426() + 17, this.method_46427() + 6, 0xC8FF8F);
            }
            if (this.field_22762 && mouseX <= this.method_46426() + 16) {
                ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
                class_2561 xpCostText = this.xpCost.getCostAsTooltip((class_1657)mc.field_1724);
                if (xpCostText instanceof class_5250) {
                    class_5250 mutableComponent = (class_5250)xpCostText;
                    mutableComponent.method_27692(canAfford ? class_124.field_1060 : class_124.field_1061);
                }
                tooltip.add(xpCostText);
                class_327 class_3272 = mc.field_1772;
                Optional optional = Optional.empty();
                Objects.requireNonNull(mc.field_1772);
                guiGraphics.method_51437(class_3272, tooltip, optional, mouseX, mouseY + 9);
            }
        }
    }
}

