/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.IPlayerWaystoneData;
import net.minecraft.class_1657;

public class InMemoryPlayerWaystoneData
implements IPlayerWaystoneData {
    private final List<UUID> sortingIndex = new ArrayList<UUID>();
    private final Map<UUID, IWaystone> waystones = new HashMap<UUID, IWaystone>();
    private long warpStoneCooldownUntil;
    private long inventoryButtonCooldownUntil;

    @Override
    public void activateWaystone(class_1657 player, IWaystone waystone) {
        this.waystones.put(waystone.getWaystoneUid(), waystone);
        this.sortingIndex.add(waystone.getWaystoneUid());
    }

    @Override
    public boolean isWaystoneActivated(class_1657 player, IWaystone waystone) {
        return this.waystones.containsKey(waystone.getWaystoneUid());
    }

    @Override
    public void deactivateWaystone(class_1657 player, IWaystone waystone) {
        this.waystones.remove(waystone.getWaystoneUid());
        this.sortingIndex.remove(waystone.getWaystoneUid());
    }

    @Override
    public long getWarpStoneCooldownUntil(class_1657 player) {
        return this.warpStoneCooldownUntil;
    }

    @Override
    public void setWarpStoneCooldownUntil(class_1657 player, long timeStamp) {
        this.warpStoneCooldownUntil = timeStamp;
    }

    @Override
    public long getInventoryButtonCooldownUntil(class_1657 player) {
        return this.inventoryButtonCooldownUntil;
    }

    @Override
    public void setInventoryButtonCooldownUntil(class_1657 player, long timeStamp) {
        this.inventoryButtonCooldownUntil = timeStamp;
    }

    @Override
    public Collection<IWaystone> getWaystones(class_1657 player) {
        return this.waystones.values();
    }

    @Override
    public void sortWaystoneAsFirst(class_1657 player, UUID waystoneUid) {
        this.sortingIndex.remove(waystoneUid);
        this.sortingIndex.add(0, waystoneUid);
    }

    @Override
    public void sortWaystoneAsLast(class_1657 player, UUID waystoneUid) {
        this.sortingIndex.remove(waystoneUid);
        this.sortingIndex.add(waystoneUid);
    }

    @Override
    public void sortWaystoneSwap(class_1657 player, UUID waystoneUid, UUID otherWaystoneUid) {
        int waystoneIndex = this.sortingIndex.indexOf(waystoneUid);
        int otherWaystoneIndex = this.sortingIndex.indexOf(otherWaystoneUid);
        if (waystoneIndex != -1 && otherWaystoneIndex != -1) {
            Collections.swap(this.sortingIndex, waystoneIndex, otherWaystoneIndex);
        }
    }

    @Override
    public List<UUID> getSortingIndex(class_1657 player) {
        return this.sortingIndex;
    }

    @Override
    public List<UUID> ensureSortingIndex(class_1657 player, Collection<IWaystone> waystones) {
        HashSet<UUID> existing = new HashSet<UUID>(this.sortingIndex);
        for (IWaystone waystone : waystones) {
            UUID waystoneUid = waystone.getWaystoneUid();
            if (existing.contains(waystoneUid)) continue;
            this.sortingIndex.add(waystoneUid);
        }
        return this.sortingIndex;
    }

    @Override
    public void setSortingIndex(class_1657 player, List<UUID> sortingIndex) {
        this.sortingIndex.clear();
        this.sortingIndex.addAll(sortingIndex);
    }

    public void setWaystones(Collection<IWaystone> waystones) {
        this.waystones.clear();
        for (IWaystone waystone : waystones) {
            this.waystones.put(waystone.getWaystoneUid(), waystone);
        }
    }
}

