/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmEnvironment;
import net.blay09.mods.waystones.api.ExperienceCost;
import net.blay09.mods.waystones.api.IMutableWaystone;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneActivatedEvent;
import net.blay09.mods.waystones.api.WaystoneTeleportError;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.config.DimensionalWarp;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.IPlayerWaystoneData;
import net.blay09.mods.waystones.core.InMemoryPlayerWaystoneData;
import net.blay09.mods.waystones.core.PersistentPlayerWaystoneData;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneTeleportManager;
import net.blay09.mods.waystones.tag.ModItemTags;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PlayerWaystoneManager {
    private static final Logger logger = LogManager.getLogger();
    private static final IPlayerWaystoneData persistentPlayerWaystoneData = new PersistentPlayerWaystoneData();
    private static final IPlayerWaystoneData inMemoryPlayerWaystoneData = new InMemoryPlayerWaystoneData();

    public static boolean isWaystoneActivated(class_1657 player, IWaystone waystone) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).isWaystoneActivated(player, waystone);
    }

    public static void activateWaystone(class_1657 player, IWaystone waystone) {
        if (!waystone.hasName() && waystone instanceof IMutableWaystone && waystone.wasGenerated()) {
            NameGenerationMode nameGenerationMode = WaystonesConfig.getActive().worldGen.nameGenerationMode;
            String name = NameGenerator.get(player.method_5682()).getName((class_1936)player.method_37908(), waystone, player.method_37908().field_9229, nameGenerationMode);
            ((IMutableWaystone)((Object)waystone)).setName(name);
        }
        if (!waystone.hasOwner() && waystone instanceof IMutableWaystone) {
            ((IMutableWaystone)((Object)waystone)).setOwnerUid(player.method_5667());
        }
        if (player.method_5682() != null) {
            WaystoneManager.get(player.method_5682()).method_80();
        }
        if (!PlayerWaystoneManager.isWaystoneActivated(player, waystone) && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).activateWaystone(player, waystone);
            Balm.getEvents().fireEvent((Object)new WaystoneActivatedEvent(player, waystone));
        }
    }

    @Nullable
    public static IWaystone getInventoryButtonTarget(class_1657 player) {
        InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
        if (inventoryButtonMode.isReturnToNearest()) {
            return PlayerWaystoneManager.getNearestWaystone(player);
        }
        if (inventoryButtonMode.hasNamedTarget()) {
            return WaystoneManager.get(player.method_5682()).findWaystoneByName(inventoryButtonMode.getNamedTarget()).orElse(null);
        }
        return null;
    }

    public static boolean canUseInventoryButton(class_1657 player) {
        IWaystone waystone = PlayerWaystoneManager.getInventoryButtonTarget(player);
        ExperienceCost xpCost = waystone != null ? WaystoneTeleportManager.predictExperienceLevelCost((class_1297)player, waystone, WarpMode.INVENTORY_BUTTON, null) : ExperienceCost.NoExperienceCost.INSTANCE;
        return PlayerWaystoneManager.getInventoryButtonCooldownLeft(player) <= 0L && xpCost.canAfford(player);
    }

    public static boolean canUseWarpStone(class_1657 player, class_1799 heldItem) {
        return PlayerWaystoneManager.getWarpStoneCooldownLeft(player) <= 0L;
    }

    public static double getCooldownMultiplier(IWaystone waystone) {
        return waystone.getVisibility() == WaystoneVisibility.GLOBAL ? WaystonesConfig.getActive().cooldowns.globalWaystoneCooldownMultiplier : 1.0;
    }

    private static void informPlayer(class_1297 entity, String translationKey) {
        if (entity instanceof class_1657) {
            class_5250 chatComponent = class_2561.method_43471((String)translationKey);
            chatComponent.method_27692(class_124.field_1061);
            ((class_1657)entity).method_7353((class_2561)chatComponent, false);
        }
    }

    public static Consumer<WaystoneTeleportError> informRejectedTeleport(class_1297 entityToInform) {
        return error -> {
            logger.info("Rejected teleport: " + error.getClass().getSimpleName());
            if (error.getTranslationKey() != null) {
                PlayerWaystoneManager.informPlayer(entityToInform, error.getTranslationKey());
            }
        };
    }

    public static void applyCooldown(WarpMode warpMode, class_1657 player, int cooldown) {
        if (cooldown > 0) {
            class_1937 level = player.method_37908();
            switch (warpMode) {
                case INVENTORY_BUTTON: {
                    PlayerWaystoneManager.getPlayerWaystoneData(level).setInventoryButtonCooldownUntil(player, System.currentTimeMillis() + (long)cooldown * 1000L);
                    break;
                }
                case WARP_STONE: {
                    PlayerWaystoneManager.getPlayerWaystoneData(level).setWarpStoneCooldownUntil(player, System.currentTimeMillis() + (long)cooldown * 1000L);
                }
            }
            WaystoneSyncManager.sendWaystoneCooldowns(player);
        }
    }

    public static int getCooldownPeriod(WarpMode warpMode, IWaystone waystone) {
        return (int)((double)PlayerWaystoneManager.getCooldownPeriod(warpMode) * PlayerWaystoneManager.getCooldownMultiplier(waystone));
    }

    private static int getCooldownPeriod(WarpMode warpMode) {
        return switch (warpMode) {
            case WarpMode.INVENTORY_BUTTON -> WaystonesConfig.getActive().cooldowns.inventoryButtonCooldown;
            case WarpMode.WARP_STONE -> WaystonesConfig.getActive().cooldowns.warpStoneCooldown;
            default -> 0;
        };
    }

    public static boolean canDimensionalWarpBetween(class_1297 player, IWaystone waystone) {
        class_2960 fromDimension = player.method_37908().method_27983().method_29177();
        class_2960 toDimension = waystone.getDimension().method_29177();
        List<String> dimensionAllowList = WaystonesConfig.getActive().restrictions.dimensionalWarpAllowList;
        List<String> dimensionDenyList = WaystonesConfig.getActive().restrictions.dimensionalWarpDenyList;
        if (!(dimensionAllowList.isEmpty() || dimensionAllowList.contains(toDimension.toString()) && dimensionAllowList.contains(fromDimension.toString()))) {
            return false;
        }
        if (!dimensionDenyList.isEmpty() && (dimensionDenyList.contains(toDimension.toString()) || dimensionDenyList.contains(fromDimension.toString()))) {
            return false;
        }
        DimensionalWarp dimensionalWarpMode = WaystonesConfig.getActive().restrictions.dimensionalWarp;
        return dimensionalWarpMode == DimensionalWarp.ALLOW || dimensionalWarpMode == DimensionalWarp.GLOBAL_ONLY && waystone.getVisibility() == WaystoneVisibility.GLOBAL;
    }

    public static class_1799 findWarpItem(class_1297 entity, WarpMode warpMode) {
        return switch (warpMode) {
            case WarpMode.WARP_SCROLL -> PlayerWaystoneManager.findWarpItem(entity, ModItemTags.WARP_SCROLLS);
            case WarpMode.WARP_STONE -> PlayerWaystoneManager.findWarpItem(entity, ModItemTags.WARP_STONES);
            case WarpMode.RETURN_SCROLL -> PlayerWaystoneManager.findWarpItem(entity, ModItemTags.RETURN_SCROLLS);
            case WarpMode.BOUND_SCROLL -> PlayerWaystoneManager.findWarpItem(entity, ModItemTags.BOUND_SCROLLS);
            default -> class_1799.field_8037;
        };
    }

    private static class_1799 findWarpItem(class_1297 entity, class_6862<class_1792> warpItemTag) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (livingEntity.method_6047().method_31573(warpItemTag)) {
                return livingEntity.method_6047();
            }
            if (livingEntity.method_6079().method_31573(warpItemTag)) {
                return livingEntity.method_6079();
            }
        }
        return class_1799.field_8037;
    }

    public static void deactivateWaystone(class_1657 player, IWaystone waystone) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).deactivateWaystone(player, waystone);
    }

    public static boolean canUseWarpMode(class_1297 entity, WarpMode warpMode, class_1799 heldItem, @Nullable IWaystone fromWaystone) {
        return switch (warpMode) {
            default -> throw new IncompatibleClassChangeError();
            case WarpMode.INVENTORY_BUTTON -> {
                if (entity instanceof class_1657 && PlayerWaystoneManager.canUseInventoryButton((class_1657)entity)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.WARP_SCROLL -> {
                if (!heldItem.method_7960() && heldItem.method_31573(ModItemTags.WARP_SCROLLS)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.BOUND_SCROLL -> {
                if (!heldItem.method_7960() && heldItem.method_31573(ModItemTags.BOUND_SCROLLS)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.RETURN_SCROLL -> {
                if (!heldItem.method_7960() && heldItem.method_31573(ModItemTags.RETURN_SCROLLS)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.WARP_STONE -> {
                if (!heldItem.method_7960() && heldItem.method_31573(ModItemTags.WARP_STONES) && entity instanceof class_1657 && PlayerWaystoneManager.canUseWarpStone((class_1657)entity, heldItem)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.WAYSTONE_TO_WAYSTONE -> {
                if (WaystonesConfig.getActive().restrictions.allowWaystoneToWaystoneTeleport && fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.SHARESTONE_TO_SHARESTONE -> {
                if (fromWaystone != null && fromWaystone.isValid() && WaystoneTypes.isSharestone(fromWaystone.getWaystoneType())) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.WARP_PLATE -> {
                if (fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.PORTSTONE_TO_WAYSTONE -> {
                if (fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.PORTSTONE)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.CUSTOM -> true;
        };
    }

    public static long getWarpStoneCooldownUntil(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).getWarpStoneCooldownUntil(player);
    }

    public static long getWarpStoneCooldownLeft(class_1657 player) {
        long cooldownUntil = PlayerWaystoneManager.getWarpStoneCooldownUntil(player);
        return Math.max(0L, cooldownUntil - System.currentTimeMillis());
    }

    public static void setWarpStoneCooldownUntil(class_1657 player, long timeStamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).setWarpStoneCooldownUntil(player, timeStamp);
    }

    public static long getInventoryButtonCooldownUntil(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).getInventoryButtonCooldownUntil(player);
    }

    public static long getInventoryButtonCooldownLeft(class_1657 player) {
        long cooldownUntil = PlayerWaystoneManager.getInventoryButtonCooldownUntil(player);
        return Math.max(0L, cooldownUntil - System.currentTimeMillis());
    }

    public static void setInventoryButtonCooldownUntil(class_1657 player, long timeStamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).setInventoryButtonCooldownUntil(player, timeStamp);
    }

    @Nullable
    public static IWaystone getNearestWaystone(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).getWaystones(player).stream().filter(it -> it.getDimension() == player.method_37908().method_27983()).min((first, second) -> {
            double firstDist = first.getPos().method_10268(player.method_23317(), player.method_23318(), player.method_23321());
            double secondDist = second.getPos().method_10268(player.method_23317(), player.method_23318(), player.method_23321());
            return (int)Math.round(firstDist) - (int)Math.round(secondDist);
        }).orElse(null);
    }

    public static Collection<IWaystone> getActivatedWaystones(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).getWaystones(player);
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(@Nullable class_1937 world) {
        return world == null || world.field_9236 ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(BalmEnvironment side) {
        return side.isClient() ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static boolean mayTeleportToWaystone(class_1657 player, IWaystone waystone) {
        return true;
    }

    public static List<UUID> getSortingIndex(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).getSortingIndex(player);
    }

    public static List<UUID> ensureSortingIndex(class_1657 player, Collection<IWaystone> waystones) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).ensureSortingIndex(player, waystones);
    }

    public static void sortWaystoneAsFirst(class_1657 player, UUID waystoneUid) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).sortWaystoneAsFirst(player, waystoneUid);
    }

    public static void sortWaystoneAsLast(class_1657 player, UUID waystoneUid) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).sortWaystoneAsLast(player, waystoneUid);
    }

    public static void sortWaystoneSwap(class_1657 player, UUID waystoneUid, UUID otherWaystoneUid) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).sortWaystoneSwap(player, waystoneUid, otherWaystoneUid);
    }

    public static boolean mayEditGlobalWaystones(class_1657 player) {
        return player.method_31549().field_7477 || !WaystonesConfig.getActive().restrictions.globalWaystoneSetupRequiresCreativeMode;
    }

    public static void activeWaystoneForEveryone(@Nullable MinecraftServer server, IWaystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            if (PlayerWaystoneManager.isWaystoneActivated((class_1657)player, waystone)) continue;
            PlayerWaystoneManager.activateWaystone((class_1657)player, waystone);
        }
    }

    public static void removeKnownWaystone(@Nullable MinecraftServer server, IWaystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            PlayerWaystoneManager.deactivateWaystone((class_1657)player, waystone);
            WaystoneSyncManager.sendActivatedWaystones((class_1657)player);
        }
    }

    public static Collection<IWaystone> getTargetsForPlayer(class_1657 player) {
        return PlayerWaystoneManager.getActivatedWaystones(player);
    }

    public static Collection<IWaystone> getTargetsForItem(class_1657 player, class_1799 itemStack) {
        return PlayerWaystoneManager.getActivatedWaystones(player);
    }

    public static Collection<IWaystone> getTargetsForWaystone(class_1657 player, IWaystone waystone) {
        class_2960 waystoneType = waystone.getWaystoneType();
        ArrayList<IWaystone> result = new ArrayList<IWaystone>();
        if (WaystoneTypes.isSharestone(waystoneType)) {
            result.addAll(WaystoneManager.get(player.method_5682()).getWaystonesByType(waystoneType).toList());
        } else {
            result.addAll(PlayerWaystoneManager.getActivatedWaystones(player));
        }
        class_2586 blockEntity = player.method_37908().method_8321(waystone.getPos());
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)blockEntity;
            result.addAll(waystoneBlockEntity.getAuxiliaryTargets());
        }
        return result;
    }

    public static Collection<IWaystone> getTargetsForInventoryButton(class_3222 player) {
        return PlayerWaystoneManager.getActivatedWaystones((class_1657)player);
    }
}

