/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.IWaystoneManager;
import net.blay09.mods.waystones.api.WaystoneInitializedEvent;
import net.blay09.mods.waystones.api.WaystoneRemovedEvent;
import net.blay09.mods.waystones.api.WaystoneUpdatedEvent;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.WaystonesLoadedEvent;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.Waystone;
import net.minecraft.class_18;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class WaystoneManager
extends class_18
implements IWaystoneManager {
    private static final String DATA_NAME = "waystones";
    private static final String TAG_WAYSTONES = "Waystones";
    private static final WaystoneManager clientStorageCopy = new WaystoneManager();
    private final Map<UUID, IWaystone> waystones = new HashMap<UUID, IWaystone>();

    public void addWaystone(IWaystone waystone) {
        this.waystones.put(waystone.getWaystoneUid(), waystone);
        this.method_80();
        Balm.getEvents().fireEvent((Object)new WaystoneInitializedEvent(waystone));
    }

    public void updateWaystone(IWaystone waystone) {
        Waystone mutableWaystone = (Waystone)this.waystones.getOrDefault(waystone.getWaystoneUid(), waystone);
        mutableWaystone.setName(waystone.getName());
        mutableWaystone.setVisibility(waystone.getVisibility());
        this.waystones.put(waystone.getWaystoneUid(), mutableWaystone);
        this.method_80();
        Balm.getEvents().fireEvent((Object)new WaystoneUpdatedEvent(waystone));
    }

    public void removeWaystone(IWaystone waystone) {
        this.waystones.remove(waystone.getWaystoneUid());
        this.method_80();
        Balm.getEvents().fireEvent((Object)new WaystoneRemovedEvent(waystone));
    }

    @Override
    public Optional<IWaystone> getWaystoneAt(class_1922 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            return Optional.of(((WaystoneBlockEntityBase)blockEntity).getWaystone());
        }
        return Optional.empty();
    }

    @Override
    public Optional<IWaystone> getWaystoneById(UUID waystoneUid) {
        return Optional.ofNullable(this.waystones.get(waystoneUid));
    }

    @Override
    public Optional<IWaystone> findWaystoneByName(String name) {
        return this.waystones.values().stream().filter(it -> it.getName().equals(name)).findFirst();
    }

    @Override
    public Stream<IWaystone> getWaystones() {
        return this.waystones.values().stream();
    }

    @Override
    public Stream<IWaystone> getWaystonesByType(class_2960 type) {
        return this.waystones.values().stream().filter(it -> it.getWaystoneType().equals((Object)type)).sorted(Comparator.comparing(IWaystone::getName));
    }

    @Override
    public List<IWaystone> getGlobalWaystones() {
        return this.waystones.values().stream().filter(it -> it.getVisibility() == WaystoneVisibility.GLOBAL).collect(Collectors.toList());
    }

    public static WaystoneManager read(class_2487 tagCompound) {
        WaystoneManager waystoneManager = new WaystoneManager();
        class_2499 tagList = tagCompound.method_10554(TAG_WAYSTONES, 10);
        for (class_2520 tag : tagList) {
            class_2487 compound = (class_2487)tag;
            IWaystone waystone = Waystone.read(compound);
            waystoneManager.waystones.put(waystone.getWaystoneUid(), waystone);
        }
        Balm.getEvents().fireEvent((Object)new WaystonesLoadedEvent(waystoneManager));
        return waystoneManager;
    }

    public class_2487 method_75(class_2487 tagCompound) {
        class_2499 tagList = new class_2499();
        for (IWaystone waystone : this.waystones.values()) {
            tagList.add((Object)Waystone.write(waystone, new class_2487()));
        }
        tagCompound.method_10566(TAG_WAYSTONES, (class_2520)tagList);
        return tagCompound;
    }

    public static WaystoneManager get(@Nullable MinecraftServer server) {
        if (server != null) {
            class_3218 overworld = server.method_3847(class_1937.field_25179);
            return (WaystoneManager)Objects.requireNonNull(overworld).method_17983().method_17924(new class_18.class_8645(WaystoneManager::new, WaystoneManager::read, class_4284.field_45079), DATA_NAME);
        }
        return clientStorageCopy;
    }
}

