/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;

public class WaystonePermissionManager {
    public static boolean mayBreakWaystone(class_1657 player, class_1922 world, class_2338 pos) {
        if (WaystonesConfig.getActive().restrictions.restrictToCreative && !player.method_31549().field_7477) {
            return false;
        }
        return WaystoneManager.get(player.method_5682()).getWaystoneAt(world, pos).map(waystone -> {
            if (!player.method_31549().field_7477) {
                if (waystone.wasGenerated() && WaystonesConfig.getActive().restrictions.generatedWaystonesUnbreakable) {
                    return false;
                }
                boolean isGlobal = waystone.getVisibility() == WaystoneVisibility.GLOBAL;
                boolean mayBreakGlobalWaystones = !WaystonesConfig.getActive().restrictions.globalWaystoneSetupRequiresCreativeMode;
                return !isGlobal || mayBreakGlobalWaystones;
            }
            return true;
        }).orElse(true);
    }

    public static boolean mayPlaceWaystone(@Nullable class_1657 player) {
        return !WaystonesConfig.getActive().restrictions.restrictToCreative || player != null && player.method_31549().field_7477;
    }

    public static WaystoneEditPermissions mayEditWaystone(class_1657 player, class_1937 world, IWaystone waystone) {
        if (WaystonesConfig.getActive().restrictions.restrictToCreative && !player.method_31549().field_7477) {
            return WaystoneEditPermissions.NOT_CREATIVE;
        }
        if (WaystonesConfig.getActive().restrictions.restrictRenameToOwner && !waystone.isOwner(player)) {
            return WaystoneEditPermissions.NOT_THE_OWNER;
        }
        if (waystone.getVisibility() == WaystoneVisibility.GLOBAL && !player.method_31549().field_7477 && WaystonesConfig.getActive().restrictions.globalWaystoneSetupRequiresCreativeMode) {
            return WaystoneEditPermissions.GET_CREATIVE;
        }
        return WaystoneEditPermissions.ALLOW;
    }
}

