/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.ExperienceCost;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.IWaystoneTeleportContext;
import net.blay09.mods.waystones.api.TeleportDestination;
import net.blay09.mods.waystones.api.WaystoneTeleportError;
import net.blay09.mods.waystones.api.WaystoneTeleportEvent;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneTeleportContext;
import net.blay09.mods.waystones.network.message.TeleportEffectMessage;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2748;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class WaystoneTeleportManager {
    public static Collection<? extends class_1297> findPets(class_1297 entity) {
        return entity.method_37908().method_8390(class_1321.class, new class_238(entity.method_24515()).method_1014(10.0), pet -> entity.method_5667().equals(pet.method_6139()) && !pet.method_24345());
    }

    public static List<class_1308> findLeashedAnimals(class_1297 player) {
        return player.method_37908().method_8390(class_1308.class, new class_238(player.method_24515()).method_1014(10.0), e -> player.equals((Object)e.method_5933()));
    }

    public static ExperienceCost predictExperienceLevelCost(class_1297 player, IWaystone waystone, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        WaystoneTeleportContext context = new WaystoneTeleportContext(player, waystone, null);
        context.getLeashedEntities().addAll(WaystoneTeleportManager.findLeashedAnimals(player));
        context.setFromWaystone(fromWaystone);
        context.setWarpMode(warpMode);
        return WaystoneTeleportManager.getExperienceLevelCost(context);
    }

    public static ExperienceCost getExperienceLevelCost(IWaystoneTeleportContext context) {
        int xpCost = WaystoneTeleportManager.getExperienceLevelCost(context.getEntity(), context.getTargetWaystone(), context.getWarpMode(), context);
        if (WaystonesConfig.getActive().xpCost.xpCostsFullLevels) {
            return ExperienceCost.fromLevels(xpCost);
        }
        return ExperienceCost.fromExperience(xpCost);
    }

    @Deprecated
    public static int getExperienceLevelCost(class_1297 entity, IWaystone waystone, WarpMode warpMode, IWaystoneTeleportContext context) {
        double xpLevelCost;
        if (!(entity instanceof class_1657)) {
            return 0;
        }
        class_1657 player = (class_1657)entity;
        if (context.getFromWaystone() != null && waystone.getWaystoneUid().equals(context.getFromWaystone().getWaystoneUid())) {
            return 0;
        }
        boolean enableXPCost = !player.method_31549().field_7477;
        int xpForLeashed = WaystonesConfig.getActive().xpCost.xpCostPerLeashed * context.getLeashedEntities().size();
        double xpCostMultiplier = warpMode.getXpCostMultiplier();
        if (waystone.getVisibility() == WaystoneVisibility.GLOBAL) {
            xpCostMultiplier *= WaystonesConfig.getActive().xpCost.globalWaystoneXpCostMultiplier;
        }
        class_2338 pos = waystone.getPos();
        double dist = Math.sqrt(player.method_5649((double)pos.method_10263(), player.method_23318(), (double)pos.method_10260()));
        double minimumXpCost = WaystonesConfig.getActive().xpCost.minimumBaseXpCost;
        double maximumXpCost = WaystonesConfig.getActive().xpCost.maximumBaseXpCost;
        if (waystone.getDimension() != player.method_37908().method_27983()) {
            int dimensionalWarpXpCost = WaystonesConfig.getActive().xpCost.dimensionalWarpXpCost;
            xpLevelCost = class_3532.method_15350((double)dimensionalWarpXpCost, (double)minimumXpCost, (double)dimensionalWarpXpCost);
        } else if (WaystonesConfig.getActive().xpCost.blocksPerXpLevel > 0) {
            xpLevelCost = class_3532.method_15350((double)Math.floor(dist / (double)WaystonesConfig.getActive().xpCost.blocksPerXpLevel), (double)minimumXpCost, (double)maximumXpCost);
            if (WaystonesConfig.getActive().xpCost.inverseXpCost) {
                xpLevelCost = maximumXpCost - xpLevelCost;
            }
        } else {
            xpLevelCost = minimumXpCost;
        }
        return enableXPCost ? (int)Math.round((xpLevelCost + (double)xpForLeashed) * xpCostMultiplier) : 0;
    }

    public static List<class_1297> doTeleport(IWaystoneTeleportContext context) {
        List<class_1297> teleportedEntities = WaystoneTeleportManager.teleportEntityAndAttached(context.getEntity(), context);
        context.getAdditionalEntities().forEach(additionalEntity -> teleportedEntities.addAll(WaystoneTeleportManager.teleportEntityAndAttached(additionalEntity, context)));
        class_3218 sourceWorld = (class_3218)context.getEntity().method_37908();
        class_2338 sourcePos = context.getEntity().method_24515();
        TeleportDestination destination = context.getDestination();
        class_3218 targetLevel = destination.getLevel();
        class_2338 targetPos = class_2338.method_49638((class_2374)destination.getLocation());
        class_2586 targetTileEntity = targetLevel.method_8321(targetPos);
        if (targetTileEntity instanceof WarpPlateBlockEntity) {
            WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)targetTileEntity;
            teleportedEntities.forEach(warpPlate::markEntityForCooldown);
        }
        if (context.playsSound()) {
            sourceWorld.method_45445(context.getEntity(), sourcePos, class_3417.field_14716, class_3419.field_15248, 0.01f, 1.0f);
            targetLevel.method_8396(null, targetPos, class_3417.field_14716, class_3419.field_15248, 0.05f, 1.0f);
        }
        if (context.playsEffect()) {
            teleportedEntities.forEach(additionalEntity -> Balm.getNetworking().sendToTracking(sourceWorld, sourcePos, (Object)new TeleportEffectMessage(sourcePos)));
            Balm.getNetworking().sendToTracking(targetLevel, targetPos, (Object)new TeleportEffectMessage(targetPos));
        }
        return teleportedEntities;
    }

    private static List<class_1297> teleportEntityAndAttached(class_1297 entity, IWaystoneTeleportContext context) {
        ArrayList<class_1297> teleportedEntities = new ArrayList<class_1297>();
        TeleportDestination destination = context.getDestination();
        class_3218 targetLevel = destination.getLevel();
        class_243 targetLocation = destination.getLocation();
        class_2350 targetDirection = destination.getDirection();
        class_1297 mount = entity.method_5854();
        class_1297 teleportedMount = null;
        if (mount != null) {
            teleportedMount = WaystoneTeleportManager.teleportEntity(mount, targetLevel, targetLocation, targetDirection);
            teleportedEntities.add(teleportedMount);
        }
        List<class_1308> leashedEntities = context.getLeashedEntities();
        ArrayList teleportedLeashedEntities = new ArrayList();
        leashedEntities.forEach(leashedEntity -> {
            class_1297 teleportedLeashedEntity = WaystoneTeleportManager.teleportEntity((class_1297)leashedEntity, targetLevel, targetLocation, targetDirection);
            teleportedEntities.add(teleportedLeashedEntity);
            teleportedLeashedEntities.add(teleportedLeashedEntity);
        });
        class_1297 teleportedEntity = WaystoneTeleportManager.teleportEntity(entity, targetLevel, targetLocation, targetDirection);
        teleportedEntities.add(teleportedEntity);
        teleportedLeashedEntities.forEach(teleportedLeashedEntity -> {
            if (teleportedLeashedEntity instanceof class_1308) {
                class_1308 teleportedLeashedMob = (class_1308)teleportedLeashedEntity;
                teleportedLeashedMob.method_5954(teleportedEntity, true);
            }
        });
        if (teleportedMount != null) {
            // empty if block
        }
        return teleportedEntities;
    }

    private static class_1297 teleportEntity(class_1297 entity, class_3218 targetWorld, class_243 targetPos3d, class_2350 direction) {
        float yaw = direction.method_10144();
        double x = targetPos3d.field_1352;
        double y = targetPos3d.field_1351;
        double z = targetPos3d.field_1350;
        if (entity instanceof class_3222) {
            class_1923 chunkPos = new class_1923(class_2338.method_49637((double)x, (double)y, (double)z));
            targetWorld.method_14178().method_17297(class_3230.field_19347, chunkPos, 1, (Object)entity.method_5628());
            entity.method_5848();
            if (((class_3222)entity).method_6113()) {
                ((class_3222)entity).method_7358(true, true);
            }
            if (targetWorld == entity.method_37908()) {
                ((class_3222)entity).field_13987.method_14360(x, y, z, yaw, entity.method_36455(), Collections.emptySet());
            } else {
                ((class_3222)entity).method_14251(targetWorld, x, y, z, yaw, entity.method_36455());
            }
            entity.method_5847(yaw);
        } else {
            float pitch = class_3532.method_15363((float)entity.method_36455(), (float)-90.0f, (float)90.0f);
            if (targetWorld == entity.method_37908()) {
                entity.method_5808(x, y, z, yaw, pitch);
                entity.method_5847(yaw);
            } else {
                entity.method_18375();
                class_1297 oldEntity = entity;
                entity = entity.method_5864().method_5883((class_1937)targetWorld);
                if (entity == null) {
                    return oldEntity;
                }
                entity.method_5878(oldEntity);
                entity.method_5808(x, y, z, yaw, pitch);
                entity.method_5847(yaw);
                oldEntity.method_31745(class_1297.class_5529.field_27002);
                targetWorld.method_18769(entity);
            }
        }
        if (!(entity instanceof class_1309) || !((class_1309)entity).method_6128()) {
            entity.method_18799(entity.method_18798().method_18805(1.0, 0.0, 1.0));
            entity.method_24830(true);
        }
        if (entity instanceof class_1314) {
            ((class_1314)entity).method_5942().method_6340();
        }
        WaystoneTeleportManager.sendHackySyncPacketsAfterTeleport(entity);
        return entity;
    }

    private static void sendHackySyncPacketsAfterTeleport(class_1297 entity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            player.field_13987.method_14364((class_2596)new class_2748(player.field_7510, player.field_7495, player.field_7520));
        }
    }

    public static Either<List<class_1297>, WaystoneTeleportError> tryTeleportToWaystone(class_1297 entity, IWaystone waystone, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        return WaystonesAPI.createDefaultTeleportContext(entity, waystone, warpMode, fromWaystone).flatMap(WaystoneTeleportManager::tryTeleport).ifRight(PlayerWaystoneManager.informRejectedTeleport(entity));
    }

    public static Either<List<class_1297>, WaystoneTeleportError> tryTeleport(IWaystoneTeleportContext context) {
        boolean isCreativeMode;
        WarpMode warpMode;
        WaystoneTeleportEvent.Pre event = new WaystoneTeleportEvent.Pre(context);
        Balm.getEvents().fireEvent((Object)event);
        if (event.isCanceled()) {
            return Either.right((Object)new WaystoneTeleportError.CancelledByEvent());
        }
        IWaystone waystone = context.getTargetWaystone();
        class_1297 entity = context.getEntity();
        if (!PlayerWaystoneManager.canUseWarpMode(entity, warpMode = context.getWarpMode(), context.getWarpItem(), context.getFromWaystone())) {
            return Either.right((Object)new WaystoneTeleportError.WarpModeRejected());
        }
        if (context.isDimensionalTeleport() && !event.getDimensionalTeleportResult().withDefault(() -> PlayerWaystoneManager.canDimensionalWarpBetween(entity, waystone))) {
            return Either.right((Object)new WaystoneTeleportError.DimensionalWarpDenied());
        }
        if (!context.getLeashedEntities().isEmpty()) {
            if (!WaystonesConfig.getActive().restrictions.transportLeashed) {
                return Either.right((Object)new WaystoneTeleportError.LeashedWarpDenied());
            }
            List<class_2960> forbidden = WaystonesConfig.getActive().restrictions.leashedDenyList.stream().map(class_2960::new).toList();
            if (context.getLeashedEntities().stream().anyMatch(e -> forbidden.contains(class_7923.field_41177.method_10221((Object)e.method_5864())))) {
                return Either.right((Object)new WaystoneTeleportError.SpecificLeashedWarpDenied());
            }
            if (context.isDimensionalTeleport() && !WaystonesConfig.getActive().restrictions.transportLeashedDimensional) {
                return Either.right((Object)new WaystoneTeleportError.LeashedDimensionalWarpDenied());
            }
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (!context.getExperienceCost().canAfford(player)) {
                return Either.right((Object)new WaystoneTeleportError.NotEnoughXp());
            }
        }
        boolean bl = isCreativeMode = entity instanceof class_1657 && ((class_1657)entity).method_31549().field_7477;
        if (!context.getWarpItem().method_7960() && event.getConsumeItemResult().withDefault(() -> !isCreativeMode && context.consumesWarpItem())) {
            context.getWarpItem().method_7934(1);
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            PlayerWaystoneManager.applyCooldown(warpMode, player, context.getCooldown());
            context.getExperienceCost().consume(player);
        }
        List<class_1297> teleportedEntities = WaystoneTeleportManager.doTeleport(context);
        Balm.getEvents().fireEvent((Object)new WaystoneTeleportEvent.Post(context, teleportedEntities));
        return Either.left(teleportedEntities);
    }
}

