/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.UUID;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.menu.WaystoneSettingsMenu;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class EditWaystoneMessage {
    private final UUID waystoneUid;
    private final String name;
    private final WaystoneVisibility visibility;

    public EditWaystoneMessage(UUID waystoneUid, String name, WaystoneVisibility visibility) {
        this.waystoneUid = waystoneUid;
        this.name = name;
        this.visibility = visibility;
    }

    public static void encode(EditWaystoneMessage message, class_2540 buf) {
        buf.method_10797(message.waystoneUid);
        buf.method_10814(message.name);
        buf.method_10817((Enum)message.visibility);
    }

    public static EditWaystoneMessage decode(class_2540 buf) {
        UUID waystoneUid = buf.method_10790();
        String name = buf.method_10800(255);
        WaystoneVisibility visibility = (WaystoneVisibility)buf.method_10818(WaystoneVisibility.class);
        return new EditWaystoneMessage(waystoneUid, name, visibility);
    }

    public static void handle(class_3222 player, EditWaystoneMessage message) {
        WaystoneProxy waystone = new WaystoneProxy(player.field_13995, message.waystoneUid);
        WaystoneEditPermissions permissions = WaystonePermissionManager.mayEditWaystone((class_1657)player, player.method_37908(), waystone);
        if (permissions != WaystoneEditPermissions.ALLOW) {
            return;
        }
        class_1703 class_17032 = player.field_7512;
        if (!(class_17032 instanceof WaystoneSettingsMenu)) {
            return;
        }
        WaystoneSettingsMenu settingsMenu = (WaystoneSettingsMenu)class_17032;
        WaystoneVisibility visibility = message.visibility;
        if (!settingsMenu.getVisibilityOptions().contains((Object)message.visibility)) {
            Waystones.logger.warn("{} tried to edit a waystone with an invalid visibility {}", (Object)player.method_5477().getString(), (Object)message.visibility);
            visibility = settingsMenu.getVisibilityOptions().get(0);
        }
        if (visibility == WaystoneVisibility.GLOBAL && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) && !PlayerWaystoneManager.mayEditGlobalWaystones((class_1657)player)) {
            Waystones.logger.warn("{} tried to edit a global waystone without permission", (Object)player.method_5477().getString());
            return;
        }
        class_2338 pos = waystone.getPos();
        if (player.method_5649((double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f)) > 64.0) {
            return;
        }
        Waystone backingWaystone = (Waystone)waystone.getBackingWaystone();
        String legalName = EditWaystoneMessage.makeNameLegal(player.field_13995, message.name);
        backingWaystone.setName(legalName);
        if (PlayerWaystoneManager.mayEditGlobalWaystones((class_1657)player) && backingWaystone.getVisibility() != WaystoneVisibility.GLOBAL && visibility == WaystoneVisibility.GLOBAL) {
            PlayerWaystoneManager.activeWaystoneForEveryone(player.field_13995, backingWaystone);
        }
        backingWaystone.setVisibility(visibility);
        WaystoneManager.get(player.field_13995).method_80();
        WaystoneSyncManager.sendWaystoneUpdateToAll(player.field_13995, backingWaystone);
        player.method_7346();
    }

    private static String makeNameLegal(MinecraftServer server, String name) {
        String inventoryButtonMode;
        if (name.trim().isEmpty()) {
            name = class_2561.method_43471((String)"waystones.untitled_waystone").getString();
        }
        if ((inventoryButtonMode = WaystonesConfig.getActive().inventoryButton.inventoryButton).equals(name) && WaystoneManager.get(server).findWaystoneByName(name).isPresent()) {
            return name + "*";
        }
        return name;
    }
}

