/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Locale;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class WarpPlateBlock
extends WaystoneBlockBase {
    public static final MapCodec<WarpPlateBlock> CODEC = WarpPlateBlock.method_54094(WarpPlateBlock::new);
    private static final class_2583 GALACTIC_STYLE = class_2583.field_24360.method_27704(new class_2960("minecraft", "alt"));
    private static final class_265 SHAPE = class_259.method_1084((class_265)WarpPlateBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (class_265)WarpPlateBlock.method_9541((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0)).method_1097();
    public static final class_2754<WarpPlateStatus> STATUS = class_2754.method_11850((String)"status", WarpPlateStatus.class);

    public WarpPlateBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(STATUS, (Comparable)((Object)WarpPlateStatus.IDLE)));
    }

    @Override
    protected boolean canSilkTouch() {
        return true;
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2586 tileEntity;
        super.method_9567(world, pos, state, placer, stack);
        if (stack.method_7938() && (tileEntity = world.method_8321(pos)) instanceof WarpPlateBlockEntity) {
            WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)tileEntity;
            warpPlate.setCustomName(stack.method_7964());
        }
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return SHAPE;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{STATUS});
    }

    public void method_9548(class_2680 blockState, class_1937 world, class_2338 pos, class_1297 entity) {
        class_2586 tileEntity;
        if (entity.method_23317() >= (double)pos.method_10263() && entity.method_23317() < (double)(pos.method_10263() + 1) && entity.method_23318() >= (double)pos.method_10264() && entity.method_23318() < (double)(pos.method_10264() + 1) && entity.method_23321() >= (double)pos.method_10260() && entity.method_23321() < (double)(pos.method_10260() + 1) && !world.field_9236 && (tileEntity = world.method_8321(pos)) instanceof WarpPlateBlockEntity) {
            ((WarpPlateBlockEntity)tileEntity).onEntityCollision(entity);
        }
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        block3: {
            block2: {
                if (state.method_11654(STATUS) != WarpPlateStatus.ACTIVE) break block2;
                for (int i = 0; i < 50; ++i) {
                    world.method_8406((class_2394)class_2398.field_22248, (double)pos.method_10263() + Math.random(), (double)pos.method_10264() + Math.random() * 2.0, (double)pos.method_10260() + Math.random(), 0.0, 0.0, 0.0);
                    world.method_8406((class_2394)class_2398.field_11214, (double)pos.method_10263() + Math.random(), (double)pos.method_10264() + Math.random() * 2.0, (double)pos.method_10260() + Math.random(), 0.0, 0.0, 0.0);
                }
                break block3;
            }
            if (state.method_11654(STATUS) != WarpPlateStatus.INVALID) break block3;
            for (int i = 0; i < 10; ++i) {
                world.method_8406((class_2394)class_2398.field_11251, (double)pos.method_10263() + Math.random(), (double)pos.method_10264(), (double)pos.method_10260() + Math.random(), 0.0, (double)0.01f, 0.0);
            }
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new WarpPlateBlockEntity(pos, state);
    }

    @Override
    protected class_1269 handleActivation(class_1937 world, class_2338 pos, class_1657 player, WaystoneBlockEntityBase tileEntity, Waystone waystone) {
        if (!world.field_9236) {
            Balm.getNetworking().openGui(player, tileEntity.getMenuProvider());
            return class_1269.field_5812;
        }
        return class_1269.field_5812;
    }

    @Override
    protected void addWaystoneNameToTooltip(List<class_2561> tooltip, WaystoneProxy waystone) {
        tooltip.add(WarpPlateBlock.getGalacticName(waystone));
    }

    public static class_124 getColorForName(String name) {
        int colorIndex = Math.abs(name.hashCode()) % 15;
        class_124 textFormatting = class_124.method_534((int)colorIndex);
        if (textFormatting == class_124.field_1080) {
            return class_124.field_1076;
        }
        if (textFormatting == class_124.field_1063) {
            return class_124.field_1064;
        }
        if (textFormatting == class_124.field_1074) {
            return class_124.field_1065;
        }
        return textFormatting != null ? textFormatting : class_124.field_1080;
    }

    public static class_2561 getGalacticName(Waystone waystone) {
        String name = StringUtils.substringBeforeLast((String)waystone.getName().getString(), (String)" ");
        return class_2561.method_43470((String)name).method_27692(WarpPlateBlock.getColorForName(name)).method_27696(GALACTIC_STYLE);
    }

    @Override
    protected boolean shouldOpenMenuWhenPlaced() {
        return false;
    }

    @Override
    public class_2591<? extends WaystoneBlockEntityBase> getTickingBlockEntityType() {
        return (class_2591)ModBlockEntities.warpPlate.get();
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public static enum WarpPlateStatus implements class_3542
    {
        IDLE,
        ACTIVE,
        INVALID;


        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

