/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.block.entity.OnLoadHandler;
import net.blay09.mods.balm.api.container.ImplementedContainer;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.recipe.ModRecipes;
import net.blay09.mods.waystones.recipe.WaystoneRecipe;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public abstract class WaystoneBlockEntityBase
extends BalmBlockEntity
implements OnLoadHandler,
CustomRenderBoundingBox,
ImplementedContainer {
    protected final class_3913 dataAccess = new class_3913(){

        public int method_17390(int i) {
            return WaystoneBlockEntityBase.this.attunementTicks;
        }

        public void method_17391(int i, int j) {
            WaystoneBlockEntityBase.this.attunementTicks = j;
        }

        public int method_17389() {
            return 1;
        }
    };
    private final class_2371<class_1799> items = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    private boolean readyForAttunement;
    private boolean completedFirstAttunement;
    protected int attunementTicks;
    private Waystone waystone = InvalidWaystone.INSTANCE;
    private UUID waystoneUid;
    private boolean shouldNotInitialize;
    private boolean silkTouched;

    public WaystoneBlockEntityBase(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.items);
        if (this.waystone.isValid()) {
            tag.method_10566("UUID", (class_2520)class_2512.method_25929((UUID)this.waystone.getWaystoneUid()));
        } else if (this.waystoneUid != null) {
            tag.method_10566("UUID", (class_2520)class_2512.method_25929((UUID)this.waystoneUid));
        }
        tag.method_10556("ReadyForAttunement", this.readyForAttunement);
        tag.method_10556("CompletedFirstAttunement", this.completedFirstAttunement);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        class_1262.method_5429((class_2487)compound, this.items);
        if (compound.method_10573("UUID", 11)) {
            this.waystoneUid = class_2512.method_25930((class_2520)Objects.requireNonNull(compound.method_10580("UUID")));
        }
        if (compound.method_10573("Waystone", 10)) {
            Waystone syncedWaystone = WaystoneImpl.read(compound.method_10562("Waystone"));
            WaystoneManagerImpl.get(null).updateWaystone(syncedWaystone);
            this.waystone = new WaystoneProxy(null, syncedWaystone.getWaystoneUid());
        }
        this.readyForAttunement = compound.method_10577("ReadyForAttunement");
        this.completedFirstAttunement = compound.method_10577("CompletedFirstAttunement");
    }

    public void writeUpdateTag(class_2487 tag) {
        tag.method_10566("Waystone", (class_2520)WaystoneImpl.write(this.getWaystone(), new class_2487()));
    }

    public void onLoad() {
        Waystone backingWaystone = this.waystone;
        if (this.waystone instanceof WaystoneProxy) {
            backingWaystone = ((WaystoneProxy)this.waystone).getBackingWaystone();
        }
        if (backingWaystone instanceof WaystoneImpl && this.field_11863 != null) {
            ((WaystoneImpl)backingWaystone).setDimension((class_5321<class_1937>)this.field_11863.method_27983());
            ((WaystoneImpl)backingWaystone).setPos(this.field_11867);
        }
        this.sync();
    }

    public class_238 getRenderBoundingBox() {
        return new class_238((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (double)(this.field_11867.method_10263() + 1), (double)(this.field_11867.method_10264() + 2), (double)(this.field_11867.method_10260() + 1));
    }

    public Waystone getWaystone() {
        if (!(this.waystone.isValid() || this.field_11863 == null || this.field_11863.field_9236 || this.shouldNotInitialize)) {
            class_2680 state;
            if (this.waystoneUid != null) {
                this.waystone = new WaystoneProxy(this.field_11863.method_8503(), this.waystoneUid);
            }
            if (!this.waystone.isValid() && (state = this.method_11010()).method_26204() instanceof WaystoneBlockBase) {
                class_2586 blockEntity;
                WaystoneOrigin origin;
                class_2756 half = state.method_28498(WaystoneBlockBase.HALF) ? (class_2756)state.method_11654(WaystoneBlockBase.HALF) : class_2756.field_12607;
                WaystoneOrigin waystoneOrigin = origin = state.method_28498(WaystoneBlockBase.ORIGIN) ? (WaystoneOrigin)((Object)state.method_11654(WaystoneBlockBase.ORIGIN)) : WaystoneOrigin.UNKNOWN;
                if (half == class_2756.field_12607) {
                    this.initializeWaystone((class_5425)Objects.requireNonNull(this.field_11863), null, origin);
                } else if (half == class_2756.field_12609 && (blockEntity = this.field_11863.method_8321(this.field_11867.method_10074())) instanceof WaystoneBlockEntityBase) {
                    this.initializeFromBase((WaystoneBlockEntityBase)blockEntity);
                }
            }
            if (this.waystone.isValid()) {
                this.waystoneUid = this.waystone.getWaystoneUid();
                this.sync();
            }
        }
        return this.waystone;
    }

    protected abstract class_2960 getWaystoneType();

    public void initializeWaystone(class_5425 world, @Nullable class_1309 player, WaystoneOrigin origin) {
        WaystoneImpl waystone = new WaystoneImpl(this.getWaystoneType(), UUID.randomUUID(), (class_5321<class_1937>)world.method_8410().method_27983(), this.field_11867, origin, player != null ? player.method_5667() : null);
        WaystoneManagerImpl.get(world.method_8503()).addWaystone(waystone);
        this.waystone = waystone;
        this.method_5431();
        this.sync();
        if (!this.isCompletedFirstAttunement()) {
            this.initializeInventory(world);
        }
    }

    public class_1799 method_5434(int slot, int count) {
        if (!this.isCompletedFirstAttunement()) {
            return class_1799.field_8037;
        }
        return super.method_5434(slot, count);
    }

    public class_1799 method_5441(int slot) {
        if (!this.isCompletedFirstAttunement()) {
            return class_1799.field_8037;
        }
        return super.method_5441(slot);
    }

    public void initializeFromExisting(class_5425 world, WaystoneImpl existingWaystone, class_1799 itemStack) {
        this.waystone = existingWaystone;
        existingWaystone.setDimension((class_5321<class_1937>)world.method_8410().method_27983());
        existingWaystone.setPos(this.field_11867);
        this.method_5431();
        this.sync();
        class_2487 tag = itemStack.method_7969();
        boolean bl = this.completedFirstAttunement = tag != null && tag.method_10577("CompletedFirstAttunement");
        if (!this.isCompletedFirstAttunement()) {
            this.initializeInventory(world);
        }
    }

    public void initializeFromBase(WaystoneBlockEntityBase tileEntity) {
        this.waystone = tileEntity.getWaystone();
        this.method_5431();
        this.sync();
    }

    public void uninitializeWaystone() {
        if (this.waystone.isValid()) {
            WaystoneManagerImpl.get(this.field_11863.method_8503()).removeWaystone(this.waystone);
            PlayerWaystoneManager.removeKnownWaystone(this.field_11863.method_8503(), this.waystone);
            WaystoneSyncManager.sendWaystoneRemovalToAll(this.field_11863.method_8503(), this.waystone, true);
        }
        this.waystone = InvalidWaystone.INSTANCE;
        this.shouldNotInitialize = true;
        class_2756 half = (class_2756)this.method_11010().method_11654((class_2769)WaystoneBlock.HALF);
        class_2338 otherPos = half == class_2756.field_12609 ? this.field_11867.method_10074() : this.field_11867.method_10084();
        class_2586 blockEntity = Objects.requireNonNull(this.field_11863).method_8321(otherPos);
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneTile = (WaystoneBlockEntityBase)blockEntity;
            waystoneTile.waystone = InvalidWaystone.INSTANCE;
            waystoneTile.shouldNotInitialize = true;
        }
        this.method_5431();
        this.sync();
    }

    public void setSilkTouched(boolean silkTouched) {
        this.silkTouched = silkTouched;
    }

    public boolean isSilkTouched() {
        return this.silkTouched;
    }

    public abstract class_3908 getMenuProvider();

    @Nullable
    public abstract class_3908 getSettingsMenuProvider();

    public int getMaxAttunementTicks() {
        return 30;
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public class_3913 getContainerData() {
        return this.dataAccess;
    }

    @Nullable
    protected WaystoneRecipe trySelectRecipe() {
        if (!this.readyForAttunement) {
            return null;
        }
        if (this.field_11863 == null) {
            return null;
        }
        if (this.method_5438(0).method_7947() > 1) {
            return null;
        }
        return this.field_11863.method_8433().method_8132(ModRecipes.waystoneRecipeType, (class_1263)this, this.field_11863).map(class_8786::comp_1933).orElse(null);
    }

    public void serverTick() {
        WaystoneRecipe recipe = this.trySelectRecipe();
        if (recipe != null) {
            ++this.attunementTicks;
            if (this.attunementTicks >= this.getMaxAttunementTicks()) {
                this.attunementTicks = 0;
                this.craft(recipe);
            }
        } else {
            this.attunementTicks = 0;
        }
    }

    protected void craft(WaystoneRecipe recipe) {
        class_1799 attunedShard = recipe.method_8116((class_1263)this, (class_5455)class_5455.field_40585);
        WaystonesAPI.setBoundWaystone(attunedShard, this.getWaystone());
        class_1799 centerStack = this.method_5438(0);
        if (centerStack.method_7947() > 1) {
            centerStack = centerStack.method_46651(centerStack.method_7947() - 1);
            if (!class_310.method_1551().field_1724.method_31548().method_7394(centerStack)) {
                class_310.method_1551().field_1724.method_7328(centerStack, false);
            }
        }
        this.method_5447(0, attunedShard);
        for (int i = 1; i <= 4; ++i) {
            this.method_5438(i).method_7934(1);
        }
        this.completedFirstAttunement = true;
    }

    public Collection<? extends Waystone> getAuxiliaryTargets() {
        ArrayList result = new ArrayList();
        for (class_1799 item : this.getItems()) {
            WaystonesAPI.getBoundWaystone(null, item).ifPresent(result::add);
        }
        return result;
    }

    public boolean shouldPerformInitialAttunement() {
        return false;
    }

    public boolean isCompletedFirstAttunement() {
        return !this.shouldPerformInitialAttunement() || this.completedFirstAttunement;
    }

    public void markReadyForAttunement() {
        this.readyForAttunement = true;
    }

    private void initializeInventory(class_5425 levelAccessor) {
        WaystoneRecipe initializingRecipe = levelAccessor.method_8410().method_8433().method_30027(ModRecipes.waystoneRecipeType).stream().filter(holder -> holder.comp_1932().method_12836().equals("waystones") && holder.comp_1932().method_12832().equals("attuned_shard")).map(class_8786::comp_1933).findFirst().orElse(null);
        if (initializingRecipe == null) {
            Waystones.logger.error("Failed to find Attunement recipe for initial attunement");
            this.completedFirstAttunement = true;
            return;
        }
        for (int i = 0; i < 5; ++i) {
            class_1856 ingredient = (class_1856)initializingRecipe.method_8117().get(i);
            class_1799[] ingredientItems = ingredient.method_8105();
            class_1799 ingredientItem = ingredientItems.length > 0 ? ingredientItems[0] : class_1799.field_8037;
            this.method_5447(i, ingredientItem.method_7972());
        }
    }
}

