/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.Optional;
import java.util.Set;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.error.WaystoneEditError;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WaystonesConfigData;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class WaystonePermissionManager {
    private static final Set<WaystoneVisibility> DEFAULT_VISIBILITIES = Set.of(WaystoneVisibility.SHARD_ONLY, WaystoneVisibility.ACTIVATION);

    public static Optional<WaystoneEditError> mayEditWaystone(class_1657 player, class_1937 world, Waystone waystone) {
        if (WaystonePermissionManager.skipsPermissions(player)) {
            return Optional.empty();
        }
        WaystonesConfigData config = WaystonesConfig.getActive();
        if (waystone.hasOwner() && config.general.restrictedWaystones.contains((Object)WaystoneOrigin.PLAYER) && !waystone.isOwner(player)) {
            return Optional.of(new WaystoneEditError.NotOwner());
        }
        if (waystone.getOrigin() != WaystoneOrigin.PLAYER && config.general.restrictedWaystones.contains((Object)waystone.getOrigin())) {
            return Optional.of(new WaystoneEditError.NotOwner());
        }
        if (!WaystonePermissionManager.isAllowedVisibility(waystone.getVisibility())) {
            return Optional.of(new WaystoneEditError.RequiresCreative());
        }
        return Optional.empty();
    }

    public static boolean isAllowedVisibility(WaystoneVisibility visibility) {
        WaystonesConfigData config = WaystonesConfig.getActive();
        return DEFAULT_VISIBILITIES.contains((Object)visibility) || config.general.allowedVisibilities.contains((Object)visibility);
    }

    public static boolean skipsPermissions(class_1657 player) {
        return player.method_31549().field_7477;
    }

    public static boolean isEntityDeniedTeleports(class_1297 entity) {
        Set<class_2960> deniedEntities = WaystonesConfig.getActive().teleports.entityDenyList;
        return deniedEntities.contains(class_7923.field_41177.method_10221((Object)entity.method_5864()));
    }
}

