/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.error.WaystoneEditError;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.menu.WaystoneMenu;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class EditWaystoneMessage {
    private final UUID waystoneUid;
    private final String name;
    private final WaystoneVisibility visibility;

    public EditWaystoneMessage(UUID waystoneUid, String name, WaystoneVisibility visibility) {
        this.waystoneUid = waystoneUid;
        this.name = name;
        this.visibility = visibility;
    }

    public static void encode(EditWaystoneMessage message, class_2540 buf) {
        buf.method_10797(message.waystoneUid);
        buf.method_10814(message.name);
        buf.method_10817((Enum)message.visibility);
    }

    public static EditWaystoneMessage decode(class_2540 buf) {
        UUID waystoneUid = buf.method_10790();
        String name = buf.method_10800(255);
        WaystoneVisibility visibility = (WaystoneVisibility)buf.method_10818(WaystoneVisibility.class);
        return new EditWaystoneMessage(waystoneUid, name, visibility);
    }

    public static void handle(class_3222 player, EditWaystoneMessage message) {
        WaystoneProxy waystone = new WaystoneProxy(player.field_13995, message.waystoneUid);
        Optional<WaystoneEditError> error = WaystonePermissionManager.mayEditWaystone((class_1657)player, player.method_37908(), waystone);
        if (error.isPresent()) {
            return;
        }
        class_1703 class_17032 = player.field_7512;
        if (!(class_17032 instanceof WaystoneMenu)) {
            return;
        }
        WaystoneMenu settingsMenu = (WaystoneMenu)class_17032;
        WaystoneVisibility visibility = message.visibility;
        if (!settingsMenu.getVisibilityOptions().contains((Object)message.visibility)) {
            Waystones.logger.warn("{} tried to edit a waystone with an invalid visibility {}", (Object)player.method_5477().getString(), (Object)message.visibility);
            visibility = settingsMenu.getVisibilityOptions().get(0);
        }
        if (!WaystonePermissionManager.isAllowedVisibility(visibility) && !WaystonePermissionManager.skipsPermissions((class_1657)player)) {
            Waystones.logger.warn("{} tried to edit a restricted waystone without permission", (Object)player.method_5477().getString());
            return;
        }
        class_2338 pos = waystone.getPos();
        if (player.method_5649((double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f)) > 64.0) {
            return;
        }
        WaystoneImpl backingWaystone = (WaystoneImpl)waystone.getBackingWaystone();
        class_2561 legalName = EditWaystoneMessage.makeNameLegal(player.field_13995, message.name);
        backingWaystone.setName(legalName);
        if (visibility == WaystoneVisibility.GLOBAL && (WaystonePermissionManager.isAllowedVisibility(visibility) || WaystonePermissionManager.skipsPermissions((class_1657)player)) && backingWaystone.getVisibility() != WaystoneVisibility.GLOBAL) {
            PlayerWaystoneManager.activeWaystoneForEveryone(player.field_13995, backingWaystone);
        }
        backingWaystone.setVisibility(visibility);
        WaystoneManagerImpl.get(player.field_13995).method_80();
        WaystoneSyncManager.sendWaystoneUpdateToAll(player.field_13995, backingWaystone);
        player.method_7346();
    }

    private static class_2561 makeNameLegal(MinecraftServer server, String input) {
        if (input.trim().isEmpty()) {
            return class_2561.method_43471((String)"waystones.untitled_waystone");
        }
        String inventoryButtonMode = WaystonesConfig.getActive().inventoryButton.inventoryButton;
        if (inventoryButtonMode.equals(input) && WaystoneManagerImpl.get(server).findWaystoneByName(input).isPresent()) {
            return class_2561.method_43470((String)(input + "*"));
        }
        return class_2561.method_43470((String)input);
    }
}

