/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.recipe.ModRecipes;
import net.minecraft.class_1263;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class WaystoneRecipe
implements class_1860<class_1263> {
    private final class_1799 resultItem;
    private final class_1856 primaryIngredient;
    private final class_2371<class_1856> secondaryIngredients;
    private final class_2371<class_1856> combinedIngredients;

    public WaystoneRecipe(class_1799 resultItem, class_1856 primaryIngredient, class_2371<class_1856> secondaryIngredients) {
        this.resultItem = resultItem;
        this.primaryIngredient = primaryIngredient;
        this.secondaryIngredients = secondaryIngredients;
        this.combinedIngredients = class_2371.method_37434((int)5);
        this.combinedIngredients.add((Object)primaryIngredient);
        this.combinedIngredients.addAll(secondaryIngredients);
    }

    public boolean method_8115(class_1263 inventory, class_1937 level) {
        if (!this.primaryIngredient.method_8093(inventory.method_5438(0))) {
            return false;
        }
        class_1662 stackedContents = new class_1662();
        int foundInputs = 0;
        for (int i = 0; i < this.combinedIngredients.size(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            ++foundInputs;
            stackedContents.method_20478(itemStack, 1);
        }
        return foundInputs == this.combinedIngredients.size() && stackedContents.method_7402((class_1860)this, null);
    }

    public class_1799 method_8116(class_1263 inventory, class_5455 registryAccess) {
        return this.resultItem.method_7972();
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.resultItem;
    }

    public class_1799 getOutputItem() {
        return this.resultItem;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_2371<class_1856> method_8117() {
        return this.combinedIngredients;
    }

    public boolean method_8118() {
        return true;
    }

    public String method_8112() {
        return "waystone";
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)ModBlocks.warpPlate);
    }

    public class_1865<?> method_8119() {
        return ModRecipes.waystoneRecipeSerializer;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.waystoneRecipeType;
    }

    static class Serializer
    implements class_1865<WaystoneRecipe> {
        private static final Codec<WaystoneRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_47309.fieldOf("result").forGetter(recipe -> recipe.resultItem), (App)class_1856.field_46095.fieldOf("primary").forGetter(recipe -> recipe.primaryIngredient), (App)class_1856.field_46095.listOf().fieldOf("secondary").flatXmap(secondary -> {
            Object[] ingredients = (class_1856[])secondary.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new);
            return ingredients.length > 4 ? DataResult.error(() -> "Too many secondary ingredients for warp plate recipe") : DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients));
        }, DataResult::success).forGetter(recipe -> recipe.secondaryIngredients)).apply((Applicative)instance, WaystoneRecipe::new));

        Serializer() {
        }

        public Codec<WaystoneRecipe> method_53736() {
            return CODEC;
        }

        public WaystoneRecipe fromNetwork(class_2540 buf) {
            class_1799 resultItem = buf.method_10819();
            class_1856 primaryIngredient = class_1856.method_8086((class_2540)buf);
            int secondaryCount = buf.method_10816();
            class_2371 secondaryIngredients = class_2371.method_37434((int)secondaryCount);
            for (int i = 0; i < secondaryCount; ++i) {
                secondaryIngredients.add((Object)class_1856.method_8086((class_2540)buf));
            }
            return new WaystoneRecipe(resultItem, primaryIngredient, (class_2371<class_1856>)secondaryIngredients);
        }

        public void toNetwork(class_2540 buf, WaystoneRecipe recipe) {
            buf.method_10793(recipe.resultItem);
            recipe.primaryIngredient.method_8088(buf);
            buf.method_10804(recipe.secondaryIngredients.size());
            for (class_1856 ingredient : recipe.secondaryIngredients) {
                ingredient.method_8088(buf);
            }
        }
    }
}

