/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.requirement;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.blay09.mods.waystones.api.TeleportFlags;
import net.blay09.mods.waystones.api.WaystoneTeleportContext;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.requirement.ConditionResolver;
import net.blay09.mods.waystones.api.requirement.ParameterSerializer;
import net.blay09.mods.waystones.api.requirement.RequirementFunction;
import net.blay09.mods.waystones.api.requirement.RequirementType;
import net.blay09.mods.waystones.api.requirement.VariableResolver;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.blay09.mods.waystones.api.requirement.WarpRequirementModifierFunction;
import net.blay09.mods.waystones.api.requirement.WarpRequirementsContext;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.WaystoneTeleportManager;
import net.blay09.mods.waystones.requirement.CooldownRequirementType;
import net.blay09.mods.waystones.requirement.ExperienceLevelRequirementType;
import net.blay09.mods.waystones.requirement.ExperiencePointsRequirementType;
import net.blay09.mods.waystones.requirement.ItemRequirementType;
import net.blay09.mods.waystones.requirement.RefuseRequirement;
import net.blay09.mods.waystones.requirement.RequirementModifierParser;
import net.blay09.mods.waystones.tag.ModItemTags;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class RequirementRegistry {
    private static final Map<class_2960, RequirementType<?>> requirementTypes = new HashMap();
    private static final Map<class_2960, RequirementFunction<?, ?>> requirementFunctions = new HashMap();
    private static final Map<Class<?>, ParameterSerializer<?>> parameterSerializers = new HashMap();
    private static final Map<class_2960, VariableResolver> variableResolvers = new HashMap<class_2960, VariableResolver>();
    private static final Map<class_2960, ConditionResolver<?>> conditionResolvers = new HashMap();

    public static void registerDefaults() {
        ExperiencePointsRequirementType experiencePointRequirements = new ExperiencePointsRequirementType();
        ExperienceLevelRequirementType experienceLevelRequirements = new ExperienceLevelRequirementType();
        CooldownRequirementType cooldownRequirements = new CooldownRequirementType();
        ItemRequirementType itemRequirements = new ItemRequirementType();
        RequirementRegistry.register(experiencePointRequirements);
        RequirementRegistry.register(experienceLevelRequirements);
        RequirementRegistry.register(cooldownRequirements);
        RequirementRegistry.register(itemRequirements);
        RequirementRegistry.registerModifier("add_level_cost", experienceLevelRequirements, FloatParameter.class, (cost, context, parameters) -> {
            cost.setLevels((int)((float)cost.getLevels() + parameters.value));
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("multiply_level_cost", experienceLevelRequirements, FloatParameter.class, (cost, context, parameters) -> {
            cost.setLevels((int)((float)cost.getLevels() * parameters.value));
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("scaled_add_level_cost", experienceLevelRequirements, VariableScaledParameter.class, (cost, context, parameters) -> {
            float sourceValue = context.getContextValue(parameters.id.value);
            cost.setLevels((int)((float)cost.getLevels() + sourceValue * parameters.scale.value));
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("multiply_level_cost", experienceLevelRequirements, FloatParameter.class, (cost, context, parameters) -> {
            cost.setLevels((int)((float)cost.getLevels() * parameters.value));
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("min_level_cost", experienceLevelRequirements, IntParameter.class, (cost, context, parameters) -> {
            cost.setLevels(Math.max(cost.getLevels(), parameters.value));
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("max_level_cost", experienceLevelRequirements, IntParameter.class, (cost, context, parameters) -> {
            cost.setLevels(Math.min(cost.getLevels(), parameters.value));
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("add_xp_cost", experiencePointRequirements, IntParameter.class, (cost, context, parameters) -> {
            cost.setPoints(cost.getPoints() + parameters.value);
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("multiply_xp_cost", experiencePointRequirements, FloatParameter.class, (cost, context, parameters) -> {
            cost.setPoints((int)((float)cost.getPoints() * parameters.value));
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("scaled_add_xp_cost", experiencePointRequirements, VariableScaledParameter.class, (cost, context, parameters) -> {
            float sourceValue = context.getContextValue(parameters.id.value);
            cost.setPoints((int)((float)cost.getPoints() + sourceValue * parameters.scale.value));
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("min_xp_cost", experiencePointRequirements, IntParameter.class, (cost, context, parameters) -> {
            cost.setPoints(Math.max(cost.getPoints(), parameters.value));
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("max_xp_cost", experiencePointRequirements, IntParameter.class, (cost, context, parameters) -> {
            cost.setPoints(Math.min(cost.getPoints(), parameters.value));
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("add_cooldown", cooldownRequirements, CooldownParameter.class, (cost, context, parameters) -> {
            cost.setCooldown(parameters.id.value, (int)((float)cost.getCooldownSeconds() + parameters.seconds.value));
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCooldowns);
        RequirementRegistry.registerModifier("multiply_cooldown", cooldownRequirements, CooldownParameter.class, (cost, context, parameters) -> {
            cost.setCooldown(parameters.id.value, (int)((float)cost.getCooldownSeconds() * parameters.seconds.value));
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCooldowns);
        RequirementRegistry.registerModifier("scaled_add_cooldown", cooldownRequirements, VariableScaledCooldownParameter.class, (cost, context, parameters) -> {
            float sourceValue = context.getContextValue(parameters.variable.value);
            cost.setCooldown(parameters.cooldown.value, (int)((float)cost.getCooldownSeconds() + sourceValue * parameters.seconds.value));
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCooldowns);
        RequirementRegistry.registerModifier("min_cooldown", cooldownRequirements, CooldownParameter.class, (cost, context, parameters) -> {
            cost.setCooldown(parameters.id.value, (int)Math.max((float)cost.getCooldownSeconds(), parameters.seconds.value));
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCooldowns);
        RequirementRegistry.registerModifier("max_cooldown", cooldownRequirements, CooldownParameter.class, (cost, context, parameters) -> {
            cost.setCooldown(parameters.id.value, (int)Math.min((float)cost.getCooldownSeconds(), parameters.seconds.value));
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCooldowns);
        RequirementRegistry.registerModifier("add_item_cost", itemRequirements, ItemParameter.class, (cost, context, parameters) -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(parameters.item.value);
            if (cost.getItemStack().method_7909() != item) {
                cost.setItemStack(new class_1799((class_1935)item));
                cost.setCount((int)parameters.count.value);
            } else {
                cost.setCount((int)((float)cost.getCount() + parameters.count.value));
            }
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("multiply_item_cost", itemRequirements, ItemParameter.class, (cost, context, parameters) -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(parameters.item.value);
            if (cost.getItemStack().method_7909() != item) {
                cost.setItemStack(new class_1799((class_1935)item));
                cost.setCount((int)parameters.count.value);
            } else {
                cost.setCount((int)((float)cost.getCount() * parameters.count.value));
            }
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("scaled_add_item_cost", itemRequirements, VariableScaledItemParameter.class, (cost, context, parameters) -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(parameters.item.value);
            if (cost.getItemStack().method_7909() != item) {
                cost.setItemStack(new class_1799((class_1935)item));
                cost.setCount((int)(context.getContextValue(parameters.variable.value) * parameters.count.value));
            } else {
                cost.setCount((int)((float)cost.getCount() + context.getContextValue(parameters.variable.value) * parameters.count.value));
            }
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("min_item_cost", itemRequirements, ItemParameter.class, (cost, context, parameters) -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(parameters.item.value);
            if (cost.getItemStack().method_7909() != item) {
                cost.setItemStack(new class_1799((class_1935)item));
                cost.setCount((int)parameters.count.value);
            } else {
                cost.setCount(Math.max(cost.getCount(), (int)parameters.count.value));
            }
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("max_item_cost", itemRequirements, ItemParameter.class, (cost, context, parameters) -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(parameters.item.value);
            if (cost.getItemStack().method_7909() != item) {
                cost.setItemStack(new class_1799((class_1935)item));
                cost.setCount((int)parameters.count.value);
            } else {
                cost.setCount(Math.min(cost.getCount(), (int)parameters.count.value));
            }
            return cost;
        }, () -> WaystonesConfig.getActive().teleports.enableCosts);
        RequirementRegistry.registerModifier("refuse", RequirementRegistry.createDefaultType("refuse", RefuseRequirement.class), ComponentParameter.class, (cost, context, parameters) -> {
            cost.setMessage(parameters.value);
            return cost;
        }, () -> true);
        RequirementRegistry.registerSerializer(NoParameter.class, it -> NoParameter.INSTANCE);
        RequirementRegistry.registerSerializer(IntParameter.class, it -> new IntParameter(Integer.parseInt(it)));
        RequirementRegistry.registerSerializer(FloatParameter.class, it -> new FloatParameter(Float.parseFloat(it)));
        RequirementRegistry.registerSerializer(IdParameter.class, it -> new IdParameter(new class_2960(it)));
        RequirementRegistry.registerSerializer(WaystonesIdParameter.class, it -> new WaystonesIdParameter(RequirementModifierParser.waystonesResourceLocation(it)));
        RequirementRegistry.registerSerializer(ComponentParameter.class, it -> new ComponentParameter((class_2561)(it.startsWith("$") ? class_2561.method_43471((String)it.substring(1)) : class_2561.method_43470((String)it))));
        RequirementRegistry.registerDefaultSerializer(VariableScaledParameter.class);
        RequirementRegistry.registerDefaultSerializer(CooldownParameter.class);
        RequirementRegistry.registerDefaultSerializer(VariableScaledCooldownParameter.class);
        RequirementRegistry.registerDefaultSerializer(ItemParameter.class);
        RequirementRegistry.registerDefaultSerializer(VariableScaledItemParameter.class);
        RequirementRegistry.registerConditionResolver("is_interdimensional", NoParameter.class, (context, parameters) -> context.isDimensionalTeleport());
        RequirementRegistry.registerConditionResolver("source_is_warp_plate", NoParameter.class, (context, parameters) -> context.getFromWaystone().map(waystone -> waystone.getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE)).orElse(false));
        RequirementRegistry.registerConditionResolver("source_is_portstone", NoParameter.class, (context, parameters) -> context.getFromWaystone().map(waystone -> waystone.getWaystoneType().equals((Object)WaystoneTypes.PORTSTONE)).orElse(false));
        RequirementRegistry.registerConditionResolver("source_is_waystone", NoParameter.class, (context, parameters) -> context.getFromWaystone().map(waystone -> waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)).orElse(false));
        RequirementRegistry.registerConditionResolver("source_is_sharestone", NoParameter.class, (context, parameters) -> context.getFromWaystone().map(waystone -> WaystoneTypes.isSharestone(waystone.getWaystoneType())).orElse(false));
        RequirementRegistry.registerConditionResolver("source_is_inventory_button", NoParameter.class, (context, parameters) -> context.getFlags().contains(TeleportFlags.INVENTORY_BUTTON));
        RequirementRegistry.registerConditionResolver("source_is_scroll", NoParameter.class, (context, parameters) -> context.getWarpItem().method_31573(ModItemTags.SCROLLS));
        RequirementRegistry.registerConditionResolver("source_is_bound_scroll", NoParameter.class, (context, parameters) -> context.getWarpItem().method_31573(ModItemTags.BOUND_SCROLLS));
        RequirementRegistry.registerConditionResolver("source_is_return_scroll", NoParameter.class, (context, parameters) -> context.getWarpItem().method_31573(ModItemTags.RETURN_SCROLLS));
        RequirementRegistry.registerConditionResolver("source_is_warp_scroll", NoParameter.class, (context, parameters) -> context.getWarpItem().method_31573(ModItemTags.WARP_SCROLLS));
        RequirementRegistry.registerConditionResolver("source_is_warp_stone", NoParameter.class, (context, parameters) -> context.getWarpItem().method_31573(ModItemTags.WARP_STONES));
        RequirementRegistry.registerConditionResolver("target_is_warp_plate", NoParameter.class, (context, parameters) -> context.getTargetWaystone().getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE));
        RequirementRegistry.registerConditionResolver("target_is_global", NoParameter.class, (context, parameters) -> context.getTargetWaystone().getVisibility() == WaystoneVisibility.GLOBAL);
        RequirementRegistry.registerConditionResolver("target_is_sharestone", NoParameter.class, (context, parameters) -> WaystoneTypes.isSharestone(context.getTargetWaystone().getWaystoneType()));
        RequirementRegistry.registerConditionResolver("target_is_waystone", NoParameter.class, (context, parameters) -> context.getTargetWaystone().getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE));
        RequirementRegistry.registerConditionResolver("target_is_landing_stone", NoParameter.class, (context, parameters) -> context.getTargetWaystone().getWaystoneType().equals((Object)WaystoneTypes.LANDING_STONE));
        RequirementRegistry.registerConditionResolver("is_with_pets", NoParameter.class, (context, parameters) -> !WaystoneTeleportManager.findPets(context.getEntity()).isEmpty());
        RequirementRegistry.registerConditionResolver("is_with_leashed", NoParameter.class, (context, parameters) -> !WaystoneTeleportManager.findLeashedAnimals(context.getEntity()).isEmpty());
        RequirementRegistry.registerConditionResolver("source_is_dimension", IdParameter.class, (context, parameters) -> context.getFromWaystone().map(waystone -> waystone.getDimension().method_29177()).orElseGet(() -> context.getEntity().method_37908().method_27983().method_29177()).equals((Object)parameters.value));
        RequirementRegistry.registerConditionResolver("target_is_dimension", IdParameter.class, (context, parameters) -> context.getTargetWaystone().getDimension().method_29177().equals((Object)parameters.value));
        RequirementRegistry.registerConditionResolver("involves_dimension", IdParameter.class, (context, parameters) -> context.getTargetWaystone().getDimension().method_29177().equals((Object)parameters.value) || context.getFromWaystone().map(waystone -> waystone.getDimension().method_29177()).orElseGet(() -> context.getEntity().method_37908().method_27983().method_29177()).equals((Object)parameters.value));
        RequirementRegistry.registerConditionResolver("is_within_distance", FloatParameter.class, (context, parameters) -> (float)Math.sqrt(context.getEntity().method_5707(context.getTargetWaystone().getPos().method_46558())) <= parameters.value);
        RequirementRegistry.registerVariableResolver("distance", it -> Float.valueOf((float)Math.sqrt(it.getEntity().method_5707(it.getTargetWaystone().getPos().method_46558()))));
        RequirementRegistry.registerVariableResolver("leashed", it -> Float.valueOf(WaystoneTeleportManager.findLeashedAnimals(it.getEntity()).size()));
        RequirementRegistry.registerVariableResolver("pets", it -> Float.valueOf(WaystoneTeleportManager.findPets(it.getEntity()).size()));
    }

    private static <T extends WarpRequirement> RequirementType<T> createDefaultType(final String name, final Class<T> requirementClass) {
        RequirementType requirementType = new RequirementType<T>(){

            @Override
            public class_2960 getId() {
                return new class_2960("waystones", name);
            }

            @Override
            public T createInstance() {
                try {
                    return (WarpRequirement)requirementClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        RequirementRegistry.register(requirementType);
        return requirementType;
    }

    public static void register(RequirementType<?> requirementType) {
        requirementTypes.put(requirementType.getId(), requirementType);
    }

    public static void register(RequirementFunction<?, ?> requirementFunction) {
        requirementFunctions.put(requirementFunction.getId(), requirementFunction);
    }

    public static void register(ParameterSerializer<?> parameterSerializer) {
        parameterSerializers.put(parameterSerializer.getType(), parameterSerializer);
    }

    public static void register(VariableResolver variableResolver) {
        variableResolvers.put(variableResolver.getId(), variableResolver);
    }

    public static void register(ConditionResolver<?> conditionResolver) {
        conditionResolvers.put(conditionResolver.getId(), conditionResolver);
    }

    public static void registerVariableResolver(final String name, final Function<WaystoneTeleportContext, Float> resolver) {
        RequirementRegistry.register(new VariableResolver(){

            @Override
            public class_2960 getId() {
                return new class_2960("waystones", name);
            }

            @Override
            public float resolve(WaystoneTeleportContext context) {
                return ((Float)resolver.apply(context)).floatValue();
            }
        });
    }

    public static <P> void registerConditionResolver(final String name, final Class<P> parameterType, final BiFunction<WaystoneTeleportContext, P, Boolean> resolver) {
        RequirementRegistry.register(new ConditionResolver<P>(){

            @Override
            public class_2960 getId() {
                return new class_2960("waystones", name);
            }

            @Override
            public Class<P> getParameterType() {
                return parameterType;
            }

            @Override
            public boolean matches(WaystoneTeleportContext context, P parameters) {
                return (Boolean)resolver.apply(context, parameters);
            }
        });
        int index = name.indexOf("is_");
        final String notName = index != -1 ? name.substring(0, index + 3) + "not_" + name.substring(index + 3) : "not_" + name;
        RequirementRegistry.register(new ConditionResolver<P>(){

            @Override
            public class_2960 getId() {
                return new class_2960("waystones", notName);
            }

            @Override
            public Class<P> getParameterType() {
                return parameterType;
            }

            @Override
            public boolean matches(WaystoneTeleportContext context, P parameters) {
                return (Boolean)resolver.apply(context, parameters) == false;
            }
        });
    }

    public static <T> void registerDefaultSerializer(Class<T> type) {
        RequirementRegistry.registerSerializer(type, it -> RequirementModifierParser.deserializeParameterList(type, it));
    }

    public static <T> void registerSerializer(final Class<T> type, final Function<String, T> deserializer) {
        RequirementRegistry.register(new ParameterSerializer<T>(){

            @Override
            public Class<T> getType() {
                return type;
            }

            @Override
            public T deserialize(String value) {
                return deserializer.apply(value);
            }
        });
    }

    private static <T extends WarpRequirement, P> void registerModifier(final String name, final RequirementType<T> requirementType, final Class<P> parameterType, final WarpRequirementModifierFunction<T, P> function, final Supplier<Boolean> predicate) {
        RequirementRegistry.register(new RequirementFunction<T, P>(){

            @Override
            public class_2960 getId() {
                return new class_2960("waystones", name);
            }

            @Override
            public class_2960 getRequirementType() {
                return requirementType.getId();
            }

            @Override
            public Class<P> getParameterType() {
                return parameterType;
            }

            @Override
            public T apply(T requirement, WarpRequirementsContext context, P parameters) {
                return (WarpRequirement)function.apply(requirement, context, parameters);
            }

            @Override
            public boolean isEnabled() {
                return (Boolean)predicate.get();
            }
        });
    }

    public static <T extends WarpRequirement> RequirementType<T> getRequirementType(class_2960 id) {
        return requirementTypes.get(id);
    }

    public static <T extends WarpRequirement, P> RequirementFunction<T, P> getRequirementFunction(class_2960 id) {
        return requirementFunctions.get(id);
    }

    public static VariableResolver getVariableResolver(class_2960 id) {
        return variableResolvers.get(id);
    }

    public static ConditionResolver<?> getConditionResolver(class_2960 id) {
        return conditionResolvers.get(id);
    }

    public static <T> ParameterSerializer<T> getParameterSerializer(Class<T> type) {
        return parameterSerializers.get(type);
    }

    public record FloatParameter(float value) {
    }

    public record VariableScaledParameter(WaystonesIdParameter id, FloatParameter scale) {
    }

    public record IntParameter(int value) {
    }

    public record CooldownParameter(WaystonesIdParameter id, FloatParameter seconds) {
    }

    public record VariableScaledCooldownParameter(WaystonesIdParameter variable, WaystonesIdParameter cooldown, FloatParameter seconds) {
    }

    public record ItemParameter(IdParameter item, FloatParameter count) {
    }

    public record VariableScaledItemParameter(WaystonesIdParameter variable, IdParameter item, FloatParameter count) {
    }

    public record ComponentParameter(class_2561 value) {
    }

    public record NoParameter() {
        public static final NoParameter INSTANCE = new NoParameter();
    }

    public record IdParameter(class_2960 value) {
    }

    public record WaystonesIdParameter(class_2960 value) {
    }
}

